/*
 * Decompiled with CFR 0.152.
 */
package com.xtivia.sgdxp.filter;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.xtivia.sgdxp.annotation.Omniadmin;
import com.xtivia.sgdxp.core.SgDxpApplication;
import com.xtivia.sgdxp.filter.AbstractSecurityFilter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Omniadmin
public class OmniadminFilter
extends AbstractSecurityFilter {
    private static Logger _logger = LoggerFactory.getLogger(OmniadminFilter.class);

    public OmniadminFilter(SgDxpApplication xsfApplication) {
        super(xsfApplication);
    }

    @Override
    public void filter(ContainerRequestContext requestContext) {
        ResourceInfo resourceInfo;
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Omniadmin filter executes for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
        if (!this.checkIsOmniadmin()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Omniadmin filter succeeds for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
    }

    private boolean checkIsOmniadmin() {
        boolean result = true;
        Omniadmin annotation = (Omniadmin)this.getAnnotation(Omniadmin.class);
        if (annotation != null) {
            User user = this.getUser();
            if (user != null && !user.isDefaultUser()) {
                try {
                    result = this.getSgDxpApplication().getRoleLocalService().hasUserRole(user.getUserId(), user.getCompanyId(), "Administrator", true);
                }
                catch (PortalException | SystemException e) {
                    _logger.error("Error accessing DXP role service", e);
                    result = false;
                }
            } else {
                result = false;
            }
        }
        return result;
    }
}

