/*
 * Decompiled with CFR 0.152.
 */
package com.github.aakira.expandablelayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.LinearInterpolator;
import android.widget.RelativeLayout;
import com.github.aakira.expandablelayout.ExpandableLayout;
import com.github.aakira.expandablelayout.ExpandableLayoutListener;
import com.github.aakira.expandablelayout.ExpandableSavedState;
import com.github.aakira.expandablelayout.R;
import com.github.aakira.expandablelayout.Utils;
import java.util.ArrayList;
import java.util.List;

public class ExpandableRelativeLayout
extends RelativeLayout
implements ExpandableLayout {
    private int duration;
    private TimeInterpolator interpolator = new LinearInterpolator();
    private int orientation;
    private boolean defaultExpanded;
    private int defaultChildIndex;
    private int defaultPosition;
    private int closePosition = 0;
    private ExpandableLayoutListener listener;
    private ExpandableSavedState savedState;
    private boolean isExpanded;
    private int layoutSize = 0;
    private boolean isArranged = false;
    private boolean isCalculatedSize = false;
    private boolean isAnimating = false;
    private List<Integer> childSizeList = new ArrayList<Integer>();
    private List<Integer> childPositionList = new ArrayList<Integer>();
    private ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;

    public ExpandableRelativeLayout(Context context) {
        this(context, null);
    }

    public ExpandableRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExpandableRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ExpandableRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.expandableLayout, defStyleAttr, 0);
        this.duration = a.getInteger(R.styleable.expandableLayout_ael_duration, 300);
        this.defaultExpanded = a.getBoolean(R.styleable.expandableLayout_ael_expanded, false);
        this.orientation = a.getInteger(R.styleable.expandableLayout_ael_orientation, 1);
        this.defaultChildIndex = a.getInteger(R.styleable.expandableLayout_ael_defaultChildIndex, Integer.MAX_VALUE);
        this.defaultPosition = a.getDimensionPixelSize(R.styleable.expandableLayout_ael_defaultPosition, Integer.MIN_VALUE);
        int interpolatorType = a.getInteger(R.styleable.expandableLayout_ael_interpolator, 8);
        a.recycle();
        this.interpolator = Utils.createInterpolator(interpolatorType);
        this.isExpanded = this.defaultExpanded;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isCalculatedSize) {
            return;
        }
        int measureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        if (this.isVertical()) {
            int measuredHeight = this.getMeasuredHeight();
            super.onMeasure(widthMeasureSpec, measureSpec);
            this.layoutSize = this.getMeasuredHeight();
            this.setMeasuredDimension(this.getMeasuredWidth(), measuredHeight);
        } else {
            int measuredWidth = this.getMeasuredWidth();
            super.onMeasure(measureSpec, heightMeasureSpec);
            this.layoutSize = this.getMeasuredWidth();
            this.setMeasuredDimension(measuredWidth, this.getMeasuredHeight());
        }
        this.childSizeList.clear();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)view.getLayoutParams();
            this.childSizeList.add(this.isVertical() ? view.getMeasuredHeight() + params.topMargin + params.bottomMargin : view.getMeasuredWidth() + params.leftMargin + params.rightMargin);
        }
        this.isCalculatedSize = true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childNumbers;
        super.onLayout(changed, l, t, r, b);
        if (this.isArranged) {
            return;
        }
        this.childPositionList.clear();
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.childPositionList.add((int)(this.isVertical() ? this.getChildAt(i).getY() : this.getChildAt(i).getX()));
        }
        if (!this.defaultExpanded) {
            this.setLayoutSize(this.closePosition);
        }
        if ((childNumbers = this.childSizeList.size()) > this.defaultChildIndex && childNumbers > 0) {
            this.moveChild(this.defaultChildIndex, 0L, null);
        }
        if (this.defaultPosition > 0 && this.layoutSize >= this.defaultPosition && this.layoutSize > 0) {
            this.move(this.defaultPosition, 0L, null);
        }
        this.isArranged = true;
        if (this.savedState == null) {
            return;
        }
        this.setLayoutSize(this.savedState.getSize());
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        ExpandableSavedState ss = new ExpandableSavedState(parcelable);
        ss.setSize(this.getCurrentPosition());
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof ExpandableSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        ExpandableSavedState ss = (ExpandableSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.savedState = ss;
    }

    @Override
    public void setListener(@NonNull ExpandableLayoutListener listener) {
        this.listener = listener;
    }

    @Override
    public void toggle() {
        this.toggle(this.duration, this.interpolator);
    }

    @Override
    public void toggle(long duration, @Nullable TimeInterpolator interpolator) {
        if (this.closePosition < this.getCurrentPosition()) {
            this.collapse(duration, interpolator);
        } else {
            this.expand(duration, interpolator);
        }
    }

    @Override
    public void expand() {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.layoutSize, this.duration, this.interpolator).start();
    }

    @Override
    public void expand(long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating) {
            return;
        }
        if (duration <= 0L) {
            this.move(this.layoutSize, duration, interpolator);
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.layoutSize, duration, interpolator).start();
    }

    @Override
    public void collapse() {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.closePosition, this.duration, this.interpolator).start();
    }

    @Override
    public void collapse(long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating) {
            return;
        }
        if (duration <= 0L) {
            this.move(this.closePosition, duration, interpolator);
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.closePosition, duration, interpolator).start();
    }

    @Override
    public void setDuration(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.duration = duration;
    }

    @Override
    public void setExpanded(boolean expanded) {
        int currentPosition = this.getCurrentPosition();
        if (expanded && currentPosition == this.layoutSize || !expanded && currentPosition == this.closePosition) {
            return;
        }
        this.isExpanded = expanded;
        this.setLayoutSize(expanded ? this.layoutSize : this.closePosition);
        this.requestLayout();
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public void setInterpolator(@NonNull TimeInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    public void move(int position) {
        this.move(position, this.duration, this.interpolator);
    }

    public void move(int position, long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating || 0 > position || this.layoutSize < position) {
            return;
        }
        if (duration <= 0L) {
            this.isExpanded = position > this.closePosition;
            this.setLayoutSize(position);
            this.requestLayout();
            this.notifyListeners();
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), position, duration, interpolator == null ? this.interpolator : interpolator).start();
    }

    public void moveChild(int index) {
        this.moveChild(index, this.duration, this.interpolator);
    }

    public void moveChild(int index, long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating) {
            return;
        }
        int destination = this.getChildPosition(index) + (this.isVertical() ? this.getPaddingBottom() : this.getPaddingRight());
        if (duration <= 0L) {
            this.isExpanded = destination > this.closePosition;
            this.setLayoutSize(destination);
            this.requestLayout();
            this.notifyListeners();
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), destination, duration, interpolator == null ? this.interpolator : interpolator).start();
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getChildPosition(int index) {
        if (0 > index || this.childSizeList.size() <= index) {
            throw new IllegalArgumentException("There aren't the view having this index.");
        }
        return this.childPositionList.get(index) + this.childSizeList.get(index);
    }

    public int getClosePosition() {
        return this.closePosition;
    }

    public void setClosePosition(int position) {
        this.closePosition = position;
    }

    public int getCurrentPosition() {
        return this.isVertical() ? this.getMeasuredHeight() : this.getMeasuredWidth();
    }

    public void setClosePositionIndex(int childIndex) {
        this.closePosition = this.getChildPosition(childIndex);
    }

    private boolean isVertical() {
        return this.orientation == 1;
    }

    private void setLayoutSize(int size) {
        if (this.isVertical()) {
            this.getLayoutParams().height = size;
        } else {
            this.getLayoutParams().width = size;
        }
    }

    private ValueAnimator createExpandAnimator(int from, final int to, long duration, TimeInterpolator interpolator) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{from, to});
        valueAnimator.setDuration(duration);
        valueAnimator.setInterpolator(interpolator);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                if (ExpandableRelativeLayout.this.isVertical()) {
                    ExpandableRelativeLayout.this.getLayoutParams().height = (Integer)animator.getAnimatedValue();
                } else {
                    ExpandableRelativeLayout.this.getLayoutParams().width = (Integer)animator.getAnimatedValue();
                }
                ExpandableRelativeLayout.this.requestLayout();
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                ExpandableRelativeLayout.this.isAnimating = true;
                if (ExpandableRelativeLayout.this.listener == null) {
                    return;
                }
                ExpandableRelativeLayout.this.listener.onAnimationStart();
                if (ExpandableRelativeLayout.this.layoutSize == to) {
                    ExpandableRelativeLayout.this.listener.onPreOpen();
                    return;
                }
                if (ExpandableRelativeLayout.this.closePosition == to) {
                    ExpandableRelativeLayout.this.listener.onPreClose();
                }
            }

            public void onAnimationEnd(Animator animator) {
                ExpandableRelativeLayout.this.isAnimating = false;
                ExpandableRelativeLayout.this.isExpanded = to > ExpandableRelativeLayout.this.closePosition;
                if (ExpandableRelativeLayout.this.listener == null) {
                    return;
                }
                ExpandableRelativeLayout.this.listener.onAnimationEnd();
                if (to == ExpandableRelativeLayout.this.layoutSize) {
                    ExpandableRelativeLayout.this.listener.onOpened();
                    return;
                }
                if (to == ExpandableRelativeLayout.this.closePosition) {
                    ExpandableRelativeLayout.this.listener.onClosed();
                }
            }
        });
        return valueAnimator;
    }

    private void notifyListeners() {
        if (this.listener == null) {
            return;
        }
        this.listener.onAnimationStart();
        if (this.isExpanded) {
            this.listener.onPreOpen();
        } else {
            this.listener.onPreClose();
        }
        this.mGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    ExpandableRelativeLayout.this.getViewTreeObserver().removeGlobalOnLayoutListener(ExpandableRelativeLayout.this.mGlobalLayoutListener);
                } else {
                    ExpandableRelativeLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener(ExpandableRelativeLayout.this.mGlobalLayoutListener);
                }
                ExpandableRelativeLayout.this.listener.onAnimationEnd();
                if (ExpandableRelativeLayout.this.isExpanded) {
                    ExpandableRelativeLayout.this.listener.onOpened();
                } else {
                    ExpandableRelativeLayout.this.listener.onClosed();
                }
            }
        };
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.mGlobalLayoutListener);
    }
}

