/*
 * Decompiled with CFR 0.152.
 */
package com.github.aakira.expandablelayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import com.github.aakira.expandablelayout.ExpandableLayout;
import com.github.aakira.expandablelayout.ExpandableLayoutListener;
import com.github.aakira.expandablelayout.ExpandableSavedState;
import com.github.aakira.expandablelayout.R;
import com.github.aakira.expandablelayout.Utils;
import java.util.ArrayList;
import java.util.List;

public class ExpandableLinearLayout
extends LinearLayout
implements ExpandableLayout {
    private int duration;
    private boolean isExpanded;
    private TimeInterpolator interpolator = new LinearInterpolator();
    private int defaultChildIndex;
    private int defaultPosition;
    private int closePosition = 0;
    private ExpandableLayoutListener listener;
    private ExpandableSavedState savedState;
    private int layoutSize = 0;
    private boolean isArranged = false;
    private boolean isCalculatedSize = false;
    private boolean isAnimating = false;
    private List<Integer> childSizeList = new ArrayList<Integer>();
    private ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;

    public ExpandableLinearLayout(Context context) {
        this(context, null);
    }

    public ExpandableLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExpandableLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ExpandableLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.expandableLayout, defStyleAttr, 0);
        this.duration = a.getInteger(R.styleable.expandableLayout_ael_duration, 300);
        this.isExpanded = a.getBoolean(R.styleable.expandableLayout_ael_expanded, false);
        this.defaultChildIndex = a.getInteger(R.styleable.expandableLayout_ael_defaultChildIndex, Integer.MAX_VALUE);
        this.defaultPosition = a.getDimensionPixelSize(R.styleable.expandableLayout_ael_defaultPosition, Integer.MIN_VALUE);
        int interpolatorType = a.getInteger(R.styleable.expandableLayout_ael_interpolator, 8);
        this.interpolator = Utils.createInterpolator(interpolatorType);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childNumbers;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.isCalculatedSize) {
            this.childSizeList.clear();
            int childCount = this.getChildCount();
            int sumSize = 0;
            for (int i = 0; i < childCount; ++i) {
                View view = this.getChildAt(i);
                LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
                if (0 < i) {
                    sumSize = this.childSizeList.get(i - 1);
                }
                this.childSizeList.add((this.isVertical() ? view.getMeasuredHeight() + params.topMargin + params.bottomMargin : view.getMeasuredWidth() + params.leftMargin + params.rightMargin) + sumSize);
            }
            this.layoutSize = this.childSizeList.get(childCount - 1) + (this.isVertical() ? this.getPaddingTop() + this.getPaddingBottom() : this.getPaddingLeft() + this.getPaddingRight());
            this.isCalculatedSize = true;
        }
        if (this.isArranged) {
            return;
        }
        if (!this.isExpanded) {
            this.setLayoutSize(this.closePosition);
        }
        if ((childNumbers = this.childSizeList.size()) > this.defaultChildIndex && childNumbers > 0) {
            this.moveChild(this.defaultChildIndex, 0L, null);
        }
        if (this.defaultPosition > 0 && this.layoutSize >= this.defaultPosition && this.layoutSize > 0) {
            this.move(this.defaultPosition, 0L, null);
        }
        this.isArranged = true;
        if (this.savedState == null) {
            return;
        }
        this.setLayoutSize(this.savedState.getSize());
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        ExpandableSavedState ss = new ExpandableSavedState(parcelable);
        ss.setSize(this.getCurrentPosition());
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof ExpandableSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        ExpandableSavedState ss = (ExpandableSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.savedState = ss;
    }

    @Override
    public void setListener(@NonNull ExpandableLayoutListener listener) {
        this.listener = listener;
    }

    @Override
    public void toggle() {
        this.toggle(this.duration, this.interpolator);
    }

    @Override
    public void toggle(long duration, @Nullable TimeInterpolator interpolator) {
        if (this.closePosition < this.getCurrentPosition()) {
            this.collapse(duration, interpolator);
        } else {
            this.expand(duration, interpolator);
        }
    }

    @Override
    public void expand() {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.layoutSize, this.duration, this.interpolator).start();
    }

    @Override
    public void expand(long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating) {
            return;
        }
        if (duration <= 0L) {
            this.move(this.layoutSize, duration, interpolator);
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.layoutSize, duration, interpolator).start();
    }

    @Override
    public void collapse() {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.closePosition, this.duration, this.interpolator).start();
    }

    @Override
    public void collapse(long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating) {
            return;
        }
        if (duration <= 0L) {
            this.move(this.closePosition, duration, interpolator);
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.closePosition, duration, interpolator).start();
    }

    @Override
    public void initLayout(boolean isMaintain) {
        this.closePosition = 0;
        this.layoutSize = 0;
        this.isArranged = isMaintain;
        this.isCalculatedSize = false;
        this.savedState = null;
        super.requestLayout();
    }

    @Override
    public void setDuration(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.duration = duration;
    }

    @Override
    public void setExpanded(boolean expanded) {
        if (this.isExpanded == expanded) {
            return;
        }
        this.isExpanded = expanded;
        this.setLayoutSize(expanded ? this.layoutSize : this.closePosition);
        this.requestLayout();
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public void setInterpolator(@NonNull TimeInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    public void move(int position) {
        this.move(position, this.duration, this.interpolator);
    }

    public void move(int position, long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating || 0 > position || this.layoutSize < position) {
            return;
        }
        if (duration <= 0L) {
            this.isExpanded = position > this.closePosition;
            this.setLayoutSize(position);
            this.requestLayout();
            this.notifyListeners();
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), position, duration, interpolator == null ? this.interpolator : interpolator).start();
    }

    public void moveChild(int index) {
        this.moveChild(index, this.duration, this.interpolator);
    }

    public void moveChild(int index, long duration, @Nullable TimeInterpolator interpolator) {
        if (this.isAnimating) {
            return;
        }
        int destination = this.getChildPosition(index) + (this.isVertical() ? this.getPaddingBottom() : this.getPaddingRight());
        if (duration <= 0L) {
            this.isExpanded = destination > this.closePosition;
            this.setLayoutSize(destination);
            this.requestLayout();
            this.notifyListeners();
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), destination, duration, interpolator == null ? this.interpolator : interpolator).start();
    }

    public int getChildPosition(int index) {
        if (0 > index || this.childSizeList.size() <= index) {
            throw new IllegalArgumentException("There aren't the view having this index.");
        }
        return this.childSizeList.get(index);
    }

    public int getClosePosition() {
        return this.closePosition;
    }

    public void setClosePosition(int position) {
        this.closePosition = position;
    }

    public int getCurrentPosition() {
        return this.isVertical() ? this.getMeasuredHeight() : this.getMeasuredWidth();
    }

    public void setClosePositionIndex(int childIndex) {
        this.closePosition = this.getChildPosition(childIndex);
    }

    private boolean isVertical() {
        return this.getOrientation() == 1;
    }

    private void setLayoutSize(int size) {
        if (this.isVertical()) {
            this.getLayoutParams().height = size;
        } else {
            this.getLayoutParams().width = size;
        }
    }

    private ValueAnimator createExpandAnimator(int from, final int to, long duration, TimeInterpolator interpolator) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{from, to});
        valueAnimator.setDuration(duration);
        valueAnimator.setInterpolator(interpolator);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                if (ExpandableLinearLayout.this.isVertical()) {
                    ExpandableLinearLayout.this.getLayoutParams().height = (Integer)animator.getAnimatedValue();
                } else {
                    ExpandableLinearLayout.this.getLayoutParams().width = (Integer)animator.getAnimatedValue();
                }
                ExpandableLinearLayout.this.requestLayout();
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                ExpandableLinearLayout.this.isAnimating = true;
                if (ExpandableLinearLayout.this.listener == null) {
                    return;
                }
                ExpandableLinearLayout.this.listener.onAnimationStart();
                if (ExpandableLinearLayout.this.layoutSize == to) {
                    ExpandableLinearLayout.this.listener.onPreOpen();
                    return;
                }
                if (ExpandableLinearLayout.this.closePosition == to) {
                    ExpandableLinearLayout.this.listener.onPreClose();
                }
            }

            public void onAnimationEnd(Animator animator) {
                ExpandableLinearLayout.this.isAnimating = false;
                int currentSize = ExpandableLinearLayout.this.getCurrentPosition();
                ExpandableLinearLayout.this.isExpanded = currentSize > ExpandableLinearLayout.this.closePosition;
                if (ExpandableLinearLayout.this.listener == null) {
                    return;
                }
                ExpandableLinearLayout.this.listener.onAnimationEnd();
                if (currentSize == ExpandableLinearLayout.this.layoutSize) {
                    ExpandableLinearLayout.this.listener.onOpened();
                    return;
                }
                if (currentSize == ExpandableLinearLayout.this.closePosition) {
                    ExpandableLinearLayout.this.listener.onClosed();
                }
            }
        });
        return valueAnimator;
    }

    private void notifyListeners() {
        if (this.listener == null) {
            return;
        }
        this.listener.onAnimationStart();
        if (this.isExpanded) {
            this.listener.onPreOpen();
        } else {
            this.listener.onPreClose();
        }
        this.mGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    ExpandableLinearLayout.this.getViewTreeObserver().removeGlobalOnLayoutListener(ExpandableLinearLayout.this.mGlobalLayoutListener);
                } else {
                    ExpandableLinearLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener(ExpandableLinearLayout.this.mGlobalLayoutListener);
                }
                ExpandableLinearLayout.this.listener.onAnimationEnd();
                if (ExpandableLinearLayout.this.isExpanded) {
                    ExpandableLinearLayout.this.listener.onOpened();
                } else {
                    ExpandableLinearLayout.this.listener.onClosed();
                }
            }
        };
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.mGlobalLayoutListener);
    }
}

