/*
 * Decompiled with CFR 0.152.
 */
package com.github.aakira.expandablelayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.RelativeLayout;
import com.github.aakira.expandablelayout.ExpandableLayout;
import com.github.aakira.expandablelayout.ExpandableLayoutListener;
import com.github.aakira.expandablelayout.ExpandableSavedState;
import com.github.aakira.expandablelayout.R;
import com.github.aakira.expandablelayout.Utils;
import java.util.ArrayList;
import java.util.List;

public class ExpandableRelativeLayout
extends RelativeLayout
implements ExpandableLayout {
    private int duration;
    private boolean isExpanded;
    private TimeInterpolator interpolator = new LinearInterpolator();
    private int orientation;
    private int closePosition = 0;
    private ExpandableLayoutListener listener;
    private ExpandableSavedState savedState;
    private int layoutSize = 0;
    private boolean isArranged = false;
    private boolean isCalculatedSize = false;
    private boolean isAnimating = false;
    private List<Integer> childPositionList = new ArrayList<Integer>();

    public ExpandableRelativeLayout(Context context) {
        this(context, null);
    }

    public ExpandableRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExpandableRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ExpandableRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.expandableLayout, defStyleAttr, 0);
        this.duration = a.getInteger(R.styleable.expandableLayout_ael_duration, 300);
        this.isExpanded = a.getBoolean(R.styleable.expandableLayout_ael_expanded, false);
        this.orientation = a.getInteger(R.styleable.expandableLayout_ael_orientation, 1);
        int interpolatorType = a.getInteger(R.styleable.expandableLayout_ael_interpolator, 8);
        this.interpolator = Utils.createInterpolator(interpolatorType);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.isCalculatedSize) {
            this.childPositionList.clear();
            int sumSize = 0;
            for (int i = 0; i < this.getChildCount(); ++i) {
                int childMargin;
                View view = this.getChildAt(i);
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)view.getLayoutParams();
                int childSize = this.isVertical() ? view.getMeasuredHeight() : view.getMeasuredWidth();
                int n = childMargin = this.isVertical() ? params.topMargin + params.bottomMargin : params.leftMargin + params.rightMargin;
                if (0 < i) {
                    sumSize = this.childPositionList.get(i - 1);
                }
                this.childPositionList.add(sumSize + childSize + childMargin);
            }
            this.layoutSize = this.getCurrentPosition();
            if (0 < this.layoutSize) {
                this.isCalculatedSize = true;
            }
        }
        if (this.isArranged) {
            return;
        }
        if (this.isExpanded) {
            this.setLayoutSize(this.layoutSize);
        } else {
            this.setLayoutSize(this.closePosition);
        }
        this.isArranged = true;
        if (this.savedState == null) {
            return;
        }
        this.setLayoutSize(this.savedState.getSize());
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        ExpandableSavedState ss = new ExpandableSavedState(parcelable);
        ss.setSize(this.getCurrentPosition());
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof ExpandableSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        ExpandableSavedState ss = (ExpandableSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.savedState = ss;
    }

    public void requestLayout() {
        this.isArranged = false;
        super.requestLayout();
    }

    @Override
    public void setListener(@NonNull ExpandableLayoutListener listener) {
        this.listener = listener;
    }

    @Override
    public void toggle() {
        if (this.closePosition < this.getCurrentPosition()) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    @Override
    public void expand() {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.layoutSize).start();
    }

    @Override
    public void collapse() {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.closePosition).start();
    }

    @Override
    public void setDuration(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.duration = duration;
    }

    @Override
    @Deprecated
    public void setDefaultVisibility(boolean defaultVisibility) {
        this.setExpanded(defaultVisibility);
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        this.requestLayout();
    }

    @Override
    public void setInterpolator(@NonNull TimeInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    public void move(int position) {
        if (this.isAnimating) {
            return;
        }
        if (0 > position || this.layoutSize < position) {
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), position).start();
    }

    public void moveChild(int index) {
        if (this.isAnimating) {
            return;
        }
        this.createExpandAnimator(this.getCurrentPosition(), this.childPositionList.get(index)).start();
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getChildPosition(int index) {
        if (0 > index || this.childPositionList.size() <= index) {
            throw new IllegalArgumentException("There aren't the view having this index.");
        }
        return this.childPositionList.get(index);
    }

    public int getClosePosition() {
        return this.closePosition;
    }

    public void setClosePosition(int position) {
        this.closePosition = position;
    }

    public int getCurrentPosition() {
        return this.isVertical() ? this.getMeasuredHeight() : this.getMeasuredWidth();
    }

    public void setClosePositionIndex(int childIndex) {
        this.closePosition = this.getChildPosition(childIndex);
    }

    private void updateLayout() {
        super.requestLayout();
    }

    private boolean isVertical() {
        return this.orientation == 1;
    }

    private void setLayoutSize(int size) {
        if (this.isVertical()) {
            this.getLayoutParams().height = size;
        } else {
            this.getLayoutParams().width = size;
        }
    }

    private ValueAnimator createExpandAnimator(int from, final int to) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{from, to});
        valueAnimator.setDuration((long)this.duration);
        valueAnimator.setInterpolator(this.interpolator);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                if (ExpandableRelativeLayout.this.isVertical()) {
                    ExpandableRelativeLayout.this.getLayoutParams().height = (Integer)animator.getAnimatedValue();
                } else {
                    ExpandableRelativeLayout.this.getLayoutParams().width = (Integer)animator.getAnimatedValue();
                }
                ExpandableRelativeLayout.this.updateLayout();
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                ExpandableRelativeLayout.this.isAnimating = true;
                if (ExpandableRelativeLayout.this.listener == null) {
                    return;
                }
                ExpandableRelativeLayout.this.listener.onAnimationStart();
                if (ExpandableRelativeLayout.this.layoutSize == to) {
                    ExpandableRelativeLayout.this.listener.onPreOpen();
                    return;
                }
                if (ExpandableRelativeLayout.this.closePosition == to) {
                    ExpandableRelativeLayout.this.listener.onPreClose();
                }
            }

            public void onAnimationEnd(Animator animator) {
                int currentSize;
                ExpandableRelativeLayout.this.isAnimating = false;
                if (ExpandableRelativeLayout.this.listener == null) {
                    return;
                }
                ExpandableRelativeLayout.this.listener.onAnimationEnd();
                int n = currentSize = ExpandableRelativeLayout.this.isVertical() ? ExpandableRelativeLayout.this.getLayoutParams().height : ExpandableRelativeLayout.this.getLayoutParams().width;
                if (currentSize == ExpandableRelativeLayout.this.layoutSize) {
                    ExpandableRelativeLayout.this.listener.onOpened();
                    return;
                }
                if (currentSize == ExpandableRelativeLayout.this.closePosition) {
                    ExpandableRelativeLayout.this.listener.onClosed();
                }
            }
        });
        return valueAnimator;
    }
}

