/*
 * Decompiled with CFR 0.152.
 */
package in.aabhasjindal.otptextview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.res.ResourcesCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import in.aabhasjindal.otptextview.R;
import in.aabhasjindal.otptextview.Utils;

public class ItemView
extends FrameLayout {
    public static final int ACTIVE = 1;
    public static final int INACTIVE = 0;
    public static final int ERROR = -1;
    public static final int SUCCESS = 2;
    private static final float DEFAULT_BAR_HEIGHT = 2.0f;
    private static final float DEFAULT_OTP_TEXT_SIZE = 24.0f;
    private static final int DEFAULT_BAR_MARGIN = 2;
    private Context context;
    private TextView textView;
    private View view;
    private int barActiveColor;
    private int barInactiveColor;
    private int barErrorColor;
    private int barSuccessColor;
    private int boxBackgroundColorActive;
    private int boxBackgroundColorInactive;
    private int boxBackgroundColorSuccess;
    private int boxBackgroundColorError;
    private int hideOTPDrawable;
    private int defaultOTPDrawable;
    private boolean hideOTP = false;

    public ItemView(@NonNull Context context) {
        super(context);
        this.context = context;
        this.init(null);
    }

    public ItemView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init(attrs);
    }

    public ItemView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.init(attrs);
    }

    @SuppressLint(value={"CustomViewStyleable"})
    private void init(AttributeSet attrs) {
        TypedArray styles = this.getContext().obtainStyledAttributes(attrs, R.styleable.OtpTextView);
        this.generateViews(styles);
        styles.recycle();
    }

    private void generateViews(TypedArray styles) {
        float defaultHeight = Utils.getPixels(this.context, 2.0f);
        float defaultOtpTextSize = Utils.getPixels(this.context, 24.0f);
        int textColor = styles.getColor(R.styleable.OtpTextView_android_textColor, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.black, null));
        float barHeight = styles.getDimension(R.styleable.OtpTextView_bar_height, defaultHeight);
        float barMargin = styles.getDimension(R.styleable.OtpTextView_bar_margin, (float)Utils.getPixels(this.context, 0));
        float barMarginBottom = styles.getDimension(R.styleable.OtpTextView_bar_margin_bottom, 2.0f);
        float barMarginRight = styles.getDimension(R.styleable.OtpTextView_bar_margin_right, 2.0f);
        float barMarginLeft = styles.getDimension(R.styleable.OtpTextView_bar_margin_left, 2.0f);
        float barMarginTop = styles.getDimension(R.styleable.OtpTextView_bar_margin_top, 2.0f);
        this.hideOTP = styles.getBoolean(R.styleable.OtpTextView_hide_otp, false);
        this.hideOTPDrawable = styles.getResourceId(R.styleable.OtpTextView_hide_otp_drawable, R.drawable.bg_pin);
        this.defaultOTPDrawable = ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.transparent, null);
        boolean barEnabled = styles.getBoolean(R.styleable.OtpTextView_bar_enabled, false);
        Float otpTextSize = Float.valueOf(styles.getDimension(R.styleable.OtpTextView_otp_text_size, defaultOtpTextSize));
        String otpTextTypeFace = styles.getString(R.styleable.OtpTextView_text_typeface);
        int boxBackgroundColor = styles.getResourceId(R.styleable.OtpTextView_otp_box_background, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.transparent, null));
        this.boxBackgroundColorActive = styles.getResourceId(R.styleable.OtpTextView_otp_box_background_active, boxBackgroundColor);
        this.boxBackgroundColorInactive = styles.getResourceId(R.styleable.OtpTextView_otp_box_background_inactive, boxBackgroundColor);
        this.boxBackgroundColorSuccess = styles.getResourceId(R.styleable.OtpTextView_otp_box_background_success, boxBackgroundColor);
        this.boxBackgroundColorError = styles.getResourceId(R.styleable.OtpTextView_otp_box_background_error, boxBackgroundColor);
        this.barActiveColor = styles.getColor(R.styleable.OtpTextView_bar_active_color, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.black, null));
        this.barInactiveColor = styles.getColor(R.styleable.OtpTextView_bar_inactive_color, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.grey, null));
        this.barErrorColor = styles.getColor(R.styleable.OtpTextView_bar_error_color, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.red, null));
        this.barSuccessColor = styles.getColor(R.styleable.OtpTextView_bar_success_color, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.black, null));
        this.setBackgroundResource(boxBackgroundColor);
        FrameLayout.LayoutParams textViewParams = new FrameLayout.LayoutParams(-1, -1);
        textViewParams.gravity = 17;
        this.textView = new TextView(this.context);
        this.textView.setGravity(17);
        if (otpTextTypeFace != null) {
            try {
                Typeface tf = Typeface.createFromAsset((AssetManager)this.context.getAssets(), (String)otpTextTypeFace);
                this.textView.setTypeface(tf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.textView.setTextColor(textColor);
        this.textView.setTextSize(0, otpTextSize.floatValue());
        this.addView((View)this.textView, (ViewGroup.LayoutParams)textViewParams);
        if (barEnabled) {
            FrameLayout.LayoutParams barViewParams = new FrameLayout.LayoutParams(-1, (int)barHeight);
            barViewParams.gravity = 80;
            if (barMargin != 0.0f) {
                barMarginLeft = barMargin;
                barMarginRight = barMargin;
                barMarginBottom = barMargin;
                barMarginTop = barMargin;
            }
            barViewParams.leftMargin = (int)barMarginLeft;
            barViewParams.rightMargin = (int)barMarginRight;
            barViewParams.bottomMargin = (int)barMarginBottom;
            barViewParams.topMargin = (int)barMarginTop;
            this.view = new View(this.context);
            this.addView(this.view, (ViewGroup.LayoutParams)barViewParams);
        }
    }

    public void setText(String value) {
        if (!this.hideOTP) {
            if (this.textView != null) {
                this.textView.setText((CharSequence)value);
            }
        } else {
            this.textView.setText((CharSequence)"");
            if (value.equals("")) {
                this.textView.setBackgroundResource(this.defaultOTPDrawable);
            } else {
                this.textView.setBackgroundResource(this.hideOTPDrawable);
            }
        }
    }

    public void setViewState(int state) {
        switch (state) {
            case 1: {
                if (this.view != null) {
                    this.view.setBackgroundColor(this.barActiveColor);
                }
                this.setBackgroundResource(this.boxBackgroundColorActive);
                break;
            }
            case 0: {
                if (this.view != null) {
                    this.view.setBackgroundColor(this.barInactiveColor);
                }
                this.setBackgroundResource(this.boxBackgroundColorInactive);
                break;
            }
            case -1: {
                if (this.view != null) {
                    this.view.setBackgroundColor(this.barErrorColor);
                }
                this.setBackgroundResource(this.boxBackgroundColorError);
                break;
            }
            case 2: {
                if (this.view != null) {
                    this.view.setBackgroundColor(this.barSuccessColor);
                }
                this.setBackgroundResource(this.boxBackgroundColorSuccess);
                break;
            }
        }
    }
}

