/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.gowtham.library.ui.ActVideoTrimmer;
import com.gowtham.library.utils.TrimType;
import com.gowtham.library.utils.TrimVideoOptions;

public class TrimVideo {
    public static int VIDEO_TRIMMER_REQ_CODE = 324;
    public static final String TRIM_VIDEO_OPTION = "trim_video_option";
    public static final String TRIM_VIDEO_URI = "trim_video_uri";
    public static final String TRIMMED_VIDEO_PATH = "trimmed_video_path";

    public static ActivityBuilder activity(String uri) {
        return new ActivityBuilder(uri);
    }

    public static String getTrimmedVideoPath(Intent intent) {
        return intent.getStringExtra(TRIMMED_VIDEO_PATH);
    }

    public static final class ActivityBuilder {
        @Nullable
        private final String videoUri;
        private TrimVideoOptions options;

        public ActivityBuilder(@Nullable String videoUri) {
            this.videoUri = videoUri;
            this.options = new TrimVideoOptions();
            this.options.trimType = TrimType.DEFAULT;
        }

        public ActivityBuilder setTrimType(TrimType trimType) {
            this.options.trimType = trimType;
            return this;
        }

        public ActivityBuilder setHideSeekBar(boolean hide) {
            this.options.hideSeekBar = hide;
            return this;
        }

        public ActivityBuilder setAccurateCut(boolean accurate) {
            this.options.accurateCut = accurate;
            return this;
        }

        public ActivityBuilder setMinDuration(long minDuration) {
            this.options.minDuration = minDuration;
            return this;
        }

        public ActivityBuilder setFixedDuration(long fixedDuration) {
            this.options.fixedDuration = fixedDuration;
            return this;
        }

        public ActivityBuilder setMinToMax(long min, long max) {
            this.options.minToMax = new long[]{min, max};
            return this;
        }

        public ActivityBuilder setDestination(String destination) {
            this.options.destination = destination;
            return this;
        }

        public void start(Activity activity) {
            this.validate();
            activity.startActivityForResult(this.getIntent(activity), VIDEO_TRIMMER_REQ_CODE);
        }

        private void validate() {
            if (this.videoUri == null) {
                throw new NullPointerException("VideoUri cannot be null.");
            }
            if (this.videoUri.isEmpty()) {
                throw new IllegalArgumentException("VideoUri cannot be empty");
            }
            if (this.options.trimType == null) {
                throw new NullPointerException("TrimType cannot be null");
            }
            if (this.options.minDuration < 0L) {
                throw new IllegalArgumentException("Cannot set min duration to a number < 1");
            }
            if (this.options.fixedDuration < 0L) {
                throw new IllegalArgumentException("Cannot set fixed duration to a number < 1");
            }
            if (this.options.trimType == TrimType.MIN_MAX_DURATION && this.options.minToMax == null) {
                throw new IllegalArgumentException("Used trim type is TrimType.MIN_MAX_DURATION.Give the min and max duration");
            }
            if (this.options.minToMax != null) {
                if (this.options.minToMax[0] < 0L || this.options.minToMax[1] < 0L) {
                    throw new IllegalArgumentException("Cannot set min to max duration to a number < 1");
                }
                if (this.options.minToMax[0] > this.options.minToMax[1]) {
                    throw new IllegalArgumentException("Minimum duration cannot be larger than max duration");
                }
                if (this.options.minToMax[0] == this.options.minToMax[1]) {
                    throw new IllegalArgumentException("Minimum duration cannot be same as max duration.Use Fixed duration");
                }
            }
        }

        private Intent getIntent(Activity activity) {
            Intent intent = new Intent((Context)activity, ActVideoTrimmer.class);
            intent.putExtra(TrimVideo.TRIM_VIDEO_URI, this.videoUri);
            intent.putExtra(TrimVideo.TRIM_VIDEO_OPTION, (Parcelable)this.options);
            return intent;
        }
    }
}

