/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.utils;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.io.File;

public class TrimmerUtils {
    protected static final int PER_REQ_CODE = 115;

    private static boolean checkPermission(Activity context, String ... permissions) {
        boolean allPermitted = false;
        for (String permission : permissions) {
            boolean bl = allPermitted = ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
            if (!allPermitted) break;
        }
        if (allPermitted) {
            return true;
        }
        ActivityCompat.requestPermissions((Activity)context, (String[])permissions, (int)115);
        return false;
    }

    protected static boolean isPermissionOk(int ... results) {
        boolean isAllGranted = true;
        for (int result : results) {
            if (0 == result) continue;
            isAllGranted = false;
            break;
        }
        return isAllGranted;
    }

    public static String getvideoPath(Context context, Uri uri) {
        try {
            Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
            cursor.moveToFirst();
            String document_id = cursor.getString(0);
            document_id = document_id.substring(document_id.lastIndexOf(":") + 1);
            cursor.close();
            cursor = context.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, null, "_id = ? ", new String[]{document_id}, null);
            cursor.moveToFirst();
            String path = cursor.getString(cursor.getColumnIndex("_data"));
            cursor.close();
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(uri);
        }
    }

    public static String formatCSeconds(long timeInSeconds) {
        long hours = timeInSeconds / 3600L;
        long secondsLeft = timeInSeconds - hours * 3600L;
        long minutes = secondsLeft / 60L;
        long seconds = secondsLeft - minutes * 60L;
        String formattedTime = "";
        if (hours < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + hours + ":";
        if (minutes < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + minutes + ":";
        if (seconds < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + seconds;
        return formattedTime;
    }

    public static long getVideoDuration(Activity context, Uri videoPath) {
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            String time = retriever.extractMetadata(9);
            long timeInMillisec = Long.parseLong(time);
            retriever.release();
            return timeInMillisec / 1000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getFileExtension(Context context, Uri uri) {
        try {
            String extension;
            if (uri.getScheme() != null && uri.getScheme().equals("content")) {
                MimeTypeMap mime = MimeTypeMap.getSingleton();
                extension = mime.getExtensionFromMimeType(context.getContentResolver().getType(uri));
            } else {
                extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
            }
            return extension == null || extension.isEmpty() ? ".mp4" : extension;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "mp4";
        }
    }

    public static Bitmap getFrameBySec(Activity context, Uri videoPath, long millies) {
        try {
            String formatted = millies + "000000";
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            Bitmap bitmap = retriever.getFrameAtTime(Long.parseLong(formatted));
            retriever.release();
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatSeconds(long timeInSeconds) {
        long hours = timeInSeconds / 3600L;
        long secondsLeft = timeInSeconds - hours * 3600L;
        long minutes = secondsLeft / 60L;
        long seconds = secondsLeft - minutes * 60L;
        String formattedTime = "";
        if (hours < 10L && hours != 0L) {
            formattedTime = formattedTime + "0";
            formattedTime = formattedTime + hours + ":";
        }
        if (minutes < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + minutes + ":";
        if (seconds < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + seconds;
        return formattedTime;
    }
}

