/*
 * Decompiled with CFR 0.152.
 */
package top.wuhaojie.installerlibrary;

import android.accessibilityservice.AccessibilityService;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.HashMap;
import java.util.Map;

public class InstallAccessibilityService
extends AccessibilityService {
    private Map<Integer, Boolean> handledMap = new HashMap<Integer, Boolean>();

    public void onAccessibilityEvent(AccessibilityEvent event) {
        boolean handled;
        int eventType;
        AccessibilityNodeInfo nodeInfo = event.getSource();
        if (nodeInfo != null && ((eventType = event.getEventType()) == 2048 || eventType == 32) && this.handledMap.get(event.getWindowId()) == null && (handled = this.iterateNodesAndHandle(nodeInfo))) {
            this.handledMap.put(event.getWindowId(), true);
        }
    }

    private boolean iterateNodesAndHandle(AccessibilityNodeInfo nodeInfo) {
        if (nodeInfo != null) {
            int childCount = nodeInfo.getChildCount();
            if ("android.widget.Button".equals(nodeInfo.getClassName())) {
                String nodeContent = nodeInfo.getText().toString();
                Log.d((String)"TAG", (String)("content is " + nodeContent));
                if ("\u5b89\u88c5".equals(nodeContent) || "\u5b8c\u6210".equals(nodeContent) || "\u786e\u5b9a".equals(nodeContent)) {
                    nodeInfo.performAction(16);
                    return true;
                }
            } else if ("android.widget.ScrollView".equals(nodeInfo.getClassName())) {
                nodeInfo.performAction(4096);
            }
            for (int i = 0; i < childCount; ++i) {
                AccessibilityNodeInfo childNodeInfo = nodeInfo.getChild(i);
                if (!this.iterateNodesAndHandle(childNodeInfo)) continue;
                return true;
            }
        }
        return false;
    }

    public void onInterrupt() {
    }
}

