/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.webdav.pathresolver;

import java.util.HashMap;
import java.util.Map;
import org.aarboard.nextcloud.api.webdav.pathresolver.NextcloudVersion;
import org.aarboard.nextcloud.api.webdav.pathresolver.PathHelper;
import org.aarboard.nextcloud.api.webdav.pathresolver.WebDavPathResolver;
import org.aarboard.nextcloud.api.webdav.pathresolver.WebDavpathResolverVersionImpl;

public class WebDavPathResolverBuilder {
    public static final String NEXTCLOUD_WEBDAV_BASE_PATH = "nextcloud.webdav.base.path";
    public static final String NEXTCLOUD_WEBDAV_BASE_PATH_SUFFIX = "nextcloud.webdav.base.suffix.path";
    public static final String NEXTCLOUD_WEBDAV_BASE_PATH_PREFIX = "nextcloud.webdav.base.prefix.path";
    public static final String NEXTCLOUD_USER_NAME = "nextcloud.userName";
    private WebDavPathResolver result;
    private TYPE type;
    private NextcloudVersion version = NextcloudVersion.get("20.0.4");
    private Map<String, String> valueMap = new HashMap<String, String>();

    public static WebDavPathResolverBuilder get(TYPE type) {
        return new WebDavPathResolverBuilder(type);
    }

    WebDavPathResolverBuilder(TYPE type) {
        this.type = type;
    }

    public WebDavPathResolverBuilder ofVersion(NextcloudVersion version) {
        this.version = version.ofType(this.type);
        return this;
    }

    public WebDavPathResolverBuilder withUserName(String user) {
        if (null != user) {
            this.valueMap.put(NEXTCLOUD_USER_NAME, user);
        }
        return this;
    }

    public WebDavPathResolverBuilder withBasePathSuffix(String suffix) {
        if (null != suffix) {
            this.valueMap.put(NEXTCLOUD_WEBDAV_BASE_PATH_SUFFIX, suffix);
        }
        return this;
    }

    public WebDavPathResolverBuilder withBasePathPrefix(String prefix) {
        if (null != prefix) {
            this.valueMap.put(NEXTCLOUD_WEBDAV_BASE_PATH_PREFIX, prefix);
        }
        return this;
    }

    public WebDavPathResolverBuilder withBasePath(String path) {
        if (null == path) {
            throw new IllegalArgumentException("WebDav base path cannot be null!");
        }
        this.valueMap.put(NEXTCLOUD_WEBDAV_BASE_PATH, path);
        return this;
    }

    public WebDavPathResolver build() {
        switch (this.type) {
            case FILES: 
            case CALDAV: 
            case VCARD: {
                this.result = new FolderWebDavPathResolverImpl(this.valueMap.getOrDefault(NEXTCLOUD_WEBDAV_BASE_PATH, this.version.getWebdavBasePath())).setPathPrefix(this.valueMap.getOrDefault(NEXTCLOUD_WEBDAV_BASE_PATH_PREFIX, "")).setPathSuffix(this.version.isAppendSuffix() ? this.valueMap.getOrDefault(NEXTCLOUD_WEBDAV_BASE_PATH_SUFFIX, this.type.getSuffix()) : "").setUserName(this.version.isAppendUserName() ? this.valueMap.getOrDefault(NEXTCLOUD_USER_NAME, "") : "");
                break;
            }
            case VERSION: {
                this.result = new WebDavpathResolverVersionImpl(this.valueMap.getOrDefault(NEXTCLOUD_WEBDAV_BASE_PATH, "status.php")).setPathPrefix(this.valueMap.getOrDefault(NEXTCLOUD_WEBDAV_BASE_PATH_PREFIX, ""));
                break;
            }
            default: {
                this.result = null;
            }
        }
        return this.result;
    }

    private static class FolderWebDavPathResolverImpl
    implements WebDavPathResolver {
        private String webDavBasePath;
        private String userName;
        private String pathSuffix;
        private String pathPrefix;
        private String webdavPath = null;

        public FolderWebDavPathResolverImpl(String webDavBasePath) {
            this.webDavBasePath = webDavBasePath;
            this.userName = "";
            this.pathSuffix = "";
            this.pathPrefix = "";
        }

        private FolderWebDavPathResolverImpl setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        private FolderWebDavPathResolverImpl setWebDavBasePath(String webDavBasePath) {
            this.webDavBasePath = webDavBasePath;
            return this;
        }

        private FolderWebDavPathResolverImpl setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        private FolderWebDavPathResolverImpl setPathSuffix(String pathSuffix) {
            this.pathSuffix = pathSuffix;
            return this;
        }

        private String getWebdavPath() {
            if (null == this.webdavPath) {
                this.webdavPath = PathHelper.concatPathElements(true, this.pathPrefix, this.webDavBasePath, this.pathSuffix, this.userName);
            }
            return this.webdavPath;
        }

        @Override
        public String getWebDavPath(String ... remotePath) {
            return PathHelper.concatPathElements(true, this.getWebdavPath(), remotePath);
        }
    }

    public static enum TYPE {
        FILES("files"),
        VCARD("addressbooks/users"),
        CALDAV("calendars"),
        VERSION("");

        private final String suffix;

        private TYPE(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

