/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.webdav;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.aarboard.nextcloud.api.ServerConfig;
import org.aarboard.nextcloud.api.exception.NextcloudApiException;
import org.aarboard.nextcloud.api.utils.WebdavInputStream;
import org.aarboard.nextcloud.api.webdav.AWebdavHandler;
import org.aarboard.nextcloud.api.webdav.ResourceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Files
extends AWebdavHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Files.class);

    public Files(ServerConfig serverConfig) {
        super(serverConfig);
    }

    public boolean fileExists(String remotePath) {
        return this.pathExists(remotePath);
    }

    public void uploadFile(File localSource, String remotePath) {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        try {
            sardine.put(path, localSource, null, true);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (Exception ex2) {
                LOG.warn("Error in sardine shutdown", (Throwable)ex2);
            }
        }
    }

    public void uploadFile(InputStream inputStream, String remotePath) {
        this.uploadFile(inputStream, remotePath, true);
    }

    public void uploadFile(InputStream inputStream, String remotePath, boolean continueHeader) {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        try {
            sardine.put(path, inputStream, null, continueHeader);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (Exception ex2) {
                LOG.warn("Error in sardine shutdown", (Throwable)ex2);
            }
        }
    }

    public void removeFile(String remotePath) {
        this.deletePath(remotePath);
    }

    public void renameFile(String oldPath, String newPath, boolean overwriteExisting) {
        this.renamePath(oldPath, newPath, overwriteExisting);
    }

    public boolean downloadFile(String remotePath, String downloadDirPath) throws IOException {
        boolean status = false;
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        File downloadFilepath = new File(downloadDirPath);
        if (!downloadFilepath.exists()) {
            downloadFilepath.mkdir();
        }
        if (this.fileExists(remotePath)) {
            String[] segments = remotePath.split("/");
            String filename = segments[segments.length - 1];
            downloadDirPath = downloadDirPath + "/" + filename;
        }
        InputStream in = null;
        try {
            in = sardine.get(path);
            byte[] buffer = new byte[4096];
            File targetFile = new File(downloadDirPath);
            try (FileOutputStream outStream = new FileOutputStream(targetFile);){
                int bytesRead;
                while ((bytesRead = in.read(buffer)) != -1) {
                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                }
                outStream.flush();
                ((OutputStream)outStream).close();
            }
            status = true;
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            sardine.shutdown();
            if (in != null) {
                in.close();
            }
        }
        return status;
    }

    public InputStream downloadFile(String remotePath) throws IOException {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        WebdavInputStream in = null;
        try {
            in = new WebdavInputStream(sardine, sardine.get(path));
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (Exception ex2) {
                LOG.warn("Error in sardine shutdown", (Throwable)ex2);
            }
        }
        return in;
    }

    public ResourceProperties getProperties(String remotePath, boolean allProperties) throws IOException {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        try {
            List resources;
            HashSet<QName> props = new HashSet<QName>();
            if (allProperties) {
                props.add(new QName("DAV:", "getlastmodified", "d"));
                props.add(new QName("DAV:", "getetag", "d"));
                props.add(new QName("DAV:", "getcontenttype", "d"));
                props.add(new QName("DAV:", "resourcetype", "d"));
                props.add(new QName("DAV:", "getcontentlength", "d"));
                props.add(new QName("DAV:", "displayname", "d"));
                props.add(new QName("http://owncloud.org/ns", "id", "oc"));
                props.add(new QName("http://owncloud.org/ns", "fileid", "oc"));
                props.add(new QName("http://owncloud.org/ns", "favorite", "oc"));
                props.add(new QName("http://owncloud.org/ns", "comments-href", "oc"));
                props.add(new QName("http://owncloud.org/ns", "comments-count", "oc"));
                props.add(new QName("http://owncloud.org/ns", "comments-unread", "oc"));
                props.add(new QName("http://owncloud.org/ns", "owner-id", "oc"));
                props.add(new QName("http://owncloud.org/ns", "owner-display-name", "oc"));
                props.add(new QName("http://owncloud.org/ns", "share-types", "oc"));
                props.add(new QName("http://owncloud.org/ns", "checksums", "oc"));
                props.add(new QName("http://nextcloud.org/ns", "has-preview", "nc"));
                props.add(new QName("http://owncloud.org/ns", "permissions", "oc"));
                props.add(new QName("http://owncloud.org/ns", "size", "oc"));
            }
            if ((resources = sardine.propfind(path, 0, props)) != null && resources.size() == 1) {
                DavResource res = (DavResource)resources.get(0);
                ResourceProperties retVal = new ResourceProperties();
                retVal.setModified(res.getModified());
                retVal.setEtag(res.getEtag());
                retVal.setContentType(res.getContentType());
                retVal.setContentLength(res.getContentLength());
                retVal.setCreation(res.getCreation());
                retVal.setDisplayName(res.getDisplayName());
                if (allProperties) {
                    Map custProps = res.getCustomProps();
                    retVal.setResourceType((String)custProps.get("resourcetype"));
                    retVal.setId((String)custProps.get("id"));
                    retVal.setFileId((String)custProps.get("fileid"));
                    retVal.setFavorite("1".equals(custProps.get("favorite")));
                    retVal.setCommentsHref((String)custProps.get("comments-href"));
                    retVal.setCommentsCount(this.convertStringToLong((String)custProps.get("comments-count")));
                    retVal.setCommentsUnread(this.convertStringToLong((String)custProps.get("comments-unread")));
                    retVal.setOwnerId((String)custProps.get("owner-id"));
                    retVal.setOwnerDisplayName((String)custProps.get("owner-display-name"));
                    retVal.setShareTypes((String)custProps.get("share-types"));
                    retVal.setChecksums((String)custProps.get("checksums"));
                    retVal.setHasPreview("1".equals(custProps.get("has-preview")));
                    retVal.setPermissions((String)custProps.get("permissions"));
                    retVal.setSize(this.convertStringToLong((String)custProps.get("size")));
                }
                ResourceProperties resourceProperties = retVal;
                return resourceProperties;
            }
            try {
                throw new NextcloudApiException("Unexpected number of resources received");
            }
            catch (IOException e) {
                throw new NextcloudApiException(e);
            }
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (Exception ex2) {
                LOG.warn("Error in sardine shutdown", (Throwable)ex2);
            }
        }
    }

    private long convertStringToLong(String number) {
        if (number == null || number.equals("")) {
            return 0L;
        }
        return Long.parseLong(number);
    }
}

