/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.webdav;

import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import com.github.sardine.impl.SardineImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.aarboard.nextcloud.api.ServerConfig;
import org.aarboard.nextcloud.api.exception.NextcloudApiException;
import org.aarboard.nextcloud.api.provisioning.ProvisionConnector;
import org.aarboard.nextcloud.api.provisioning.User;
import org.aarboard.nextcloud.api.webdav.pathresolver.NextcloudVersion;
import org.aarboard.nextcloud.api.webdav.pathresolver.WebDavPathResolver;
import org.aarboard.nextcloud.api.webdav.pathresolver.WebDavPathResolverBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AWebdavHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AWebdavHandler.class);
    public static final int FILE_BUFFER_SIZE = 4096;
    public static String WEB_DAV_BASE_PATH = "remote.php/webdav/";
    private final ServerConfig _serverConfig;
    private WebDavPathResolver resolver;
    private String nextcloudServerVersion;

    public AWebdavHandler(ServerConfig serverConfig) {
        this._serverConfig = serverConfig;
    }

    public void setWebDavPathResolver(WebDavPathResolver resolver) {
        this.resolver = resolver;
    }

    public String getServerVersion() {
        if (null == this.nextcloudServerVersion) {
            this.resolveNextcloudServerVersion();
        }
        return this.nextcloudServerVersion;
    }

    private void resolveNextcloudServerVersion() {
        WebDavPathResolver versionResolver = WebDavPathResolverBuilder.get(WebDavPathResolverBuilder.TYPE.VERSION).withBasePathPrefix(this._serverConfig.getSubPathPrefix()).build();
        String url = this.buildWebdavPath(versionResolver, "");
        Sardine sardine = this.buildAuthSardine();
        try (InputStream inputStream = sardine.get(url);){
            String json = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            this.nextcloudServerVersion = Arrays.asList(json.split(",")).stream().filter(x -> x.contains("version")).map(x -> x.split(":")[1]).findAny().orElse("20.0").replaceAll("\"", "");
        }
        catch (IOException ex) {
            throw new NextcloudApiException(ex);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn("error in closing sardine connector", (Throwable)ex);
            }
        }
    }

    protected WebDavPathResolver getWebDavPathResolver() {
        if (null == this.resolver) {
            ProvisionConnector pc = new ProvisionConnector(this._serverConfig);
            User currentUser = pc.getCurrentUser();
            this.resolver = WebDavPathResolverBuilder.get(WebDavPathResolverBuilder.TYPE.FILES).ofVersion(NextcloudVersion.get(this.getServerVersion())).withUserName(currentUser.getId()).withBasePathSuffix("files").withBasePathPrefix(this._serverConfig.getSubPathPrefix()).build();
        }
        return this.resolver;
    }

    protected String buildWebdavPath(String remotePath) {
        return this.buildWebdavPath(this.getWebDavPathResolver(), remotePath);
    }

    protected String buildWebdavPath(WebDavPathResolver resolver, String remotePath) {
        URIBuilder uB = new URIBuilder().setScheme(this._serverConfig.isUseHTTPS() ? "https" : "http").setHost(this._serverConfig.getServerName()).setPort(this._serverConfig.getPort()).setPath(resolver.getWebDavPath(remotePath));
        return uB.toString();
    }

    protected String getWebdavPathPrefix() {
        if (this.resolver != null) {
            return this.resolver.getWebDavPath(new String[0]);
        }
        return "/" + WEB_DAV_BASE_PATH;
    }

    protected Sardine buildAuthSardine() {
        if (this._serverConfig.getAuthenticationConfig().usesBasicAuthentication()) {
            Sardine sardine = SardineFactory.begin();
            sardine.setCredentials(this._serverConfig.getUserName(), this._serverConfig.getAuthenticationConfig().getPassword());
            sardine.enablePreemptiveAuthentication(this._serverConfig.getServerName());
            return sardine;
        }
        SardineImpl sardine = new SardineImpl(this._serverConfig.getAuthenticationConfig().getBearerToken());
        return sardine;
    }

    public boolean pathExists(String remotePath) {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        try {
            boolean bl = sardine.exists(path);
            return bl;
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn("error in closing sardine connector", (Throwable)ex);
            }
        }
    }

    public void deletePath(String remotePath) {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        try {
            sardine.delete(path);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn("error in closing sardine connector", (Throwable)ex);
            }
        }
    }

    public void renamePath(String oldPath, String newPath, boolean overwriteExisting) {
        String oldWEBDavpath = this.buildWebdavPath(oldPath);
        String newWEBDavpath = this.buildWebdavPath(newPath);
        Sardine sardine = this.buildAuthSardine();
        try {
            sardine.move(oldWEBDavpath, newWEBDavpath, overwriteExisting);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn("error in closing sardine connector", (Throwable)ex);
            }
        }
    }
}

