/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.utils;

import java.util.concurrent.CompletableFuture;
import org.aarboard.nextcloud.api.exception.NextcloudApiException;
import org.aarboard.nextcloud.api.exception.NextcloudOperationFailedException;
import org.aarboard.nextcloud.api.utils.NextcloudResponse;

public class NextcloudResponseHelper {
    public static final int NC_OK = 100;

    private NextcloudResponseHelper() {
    }

    public static <A extends NextcloudResponse> A getAndCheckStatus(CompletableFuture<A> answer) {
        NextcloudResponse wrappedAnswer = (NextcloudResponse)NextcloudResponseHelper.getAndWrapException(answer);
        if (NextcloudResponseHelper.isStatusCodeOkay(wrappedAnswer)) {
            return (A)wrappedAnswer;
        }
        throw new NextcloudOperationFailedException(wrappedAnswer.getStatusCode(), wrappedAnswer.getMessage());
    }

    public static <A extends NextcloudResponse> boolean isStatusCodeOkay(CompletableFuture<A> answer) {
        return NextcloudResponseHelper.isStatusCodeOkay((NextcloudResponse)NextcloudResponseHelper.getAndWrapException(answer));
    }

    public static boolean isStatusCodeOkay(NextcloudResponse answer) {
        return answer.getStatusCode() == 100;
    }

    public static <A> A getAndWrapException(CompletableFuture<A> answer) {
        try {
            return answer.get();
        }
        catch (Exception e) {
            throw new NextcloudApiException(e);
        }
    }
}

