/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.aarboard.nextcloud.api.exception.NextcloudApiException;
import org.aarboard.nextcloud.api.utils.ConnectorCommon;
import org.aarboard.nextcloud.api.utils.JsonAnswer;

public class JsonAnswerParser<A extends JsonAnswer>
implements ConnectorCommon.ResponseParser<A> {
    private static final Map<String, JsonAnswerParser<? extends JsonAnswer>> PARSERS = new HashMap<String, JsonAnswerParser<? extends JsonAnswer>>();
    private final ObjectReader objectReader;

    private JsonAnswerParser(Class<A> answerClass) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(DeserializationFeature.UNWRAP_ROOT_VALUE);
        this.objectReader = objectMapper.readerFor(answerClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends JsonAnswer> JsonAnswerParser<A> getInstance(Class<A> answerClass) {
        JsonAnswerParser<JsonAnswer> parser = PARSERS.get(answerClass.getName());
        if (parser == null) {
            Map<String, JsonAnswerParser<? extends JsonAnswer>> map = PARSERS;
            synchronized (map) {
                if (parser == null) {
                    parser = new JsonAnswerParser<A>(answerClass);
                    PARSERS.put(answerClass.getName(), parser);
                }
            }
        }
        return parser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public A parseResponse(Reader reader) {
        try (Reader response = reader;){
            JsonAnswer jsonAnswer = (JsonAnswer)this.objectReader.readValue(response);
            return (A)jsonAnswer;
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
    }
}

