/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.aarboard.nextcloud.api.ServerConfig;
import org.aarboard.nextcloud.api.exception.NextcloudApiException;
import org.aarboard.nextcloud.api.utils.JsonAnswerParser;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class ConnectorCommon {
    private final ServerConfig serverConfig;

    public ConnectorCommon(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public <R> CompletableFuture<R> executeGet(String part, ResponseParser<R> parser) {
        return this.executeGet(part, null, parser);
    }

    public <R> CompletableFuture<R> executeGet(String part, List<NameValuePair> queryParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part, queryParams, parser instanceof JsonAnswerParser);
            HttpGet request = new HttpGet(url.toString());
            return this.executeRequest(parser, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
    }

    public <R> CompletableFuture<R> executePost(String part, ResponseParser<R> parser) {
        return this.executePost(part, null, parser);
    }

    public <R> CompletableFuture<R> executePost(String part, List<NameValuePair> postParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part, postParams, parser instanceof JsonAnswerParser);
            HttpPost request = new HttpPost(url.toString());
            return this.executeRequest(parser, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
    }

    public <R> CompletableFuture<R> executePut(String part1, String part2, ResponseParser<R> parser) {
        return this.executePut(part1, part2, null, parser);
    }

    public <R> CompletableFuture<R> executePut(String part1, String part2, List<NameValuePair> putParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part1 + "/" + part2, putParams, parser instanceof JsonAnswerParser);
            HttpPut request = new HttpPut(url.toString());
            return this.executeRequest(parser, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
    }

    public <R> CompletableFuture<R> executeDelete(String part1, String part2, ResponseParser<R> parser) {
        return this.executeDelete(part1, part2, null, parser);
    }

    public <R> CompletableFuture<R> executeDelete(String part1, String part2, List<NameValuePair> deleteParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part1 + "/" + part2, deleteParams, parser instanceof JsonAnswerParser);
            HttpDelete request = new HttpDelete(url.toString());
            return this.executeRequest(parser, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
    }

    private URI buildUrl(String subPath, List<NameValuePair> queryParams, boolean useJson) {
        if (this.serverConfig.getSubPathPrefix() != null) {
            subPath = this.serverConfig.getSubPathPrefix() + "/" + subPath;
        }
        if (useJson) {
            if (queryParams == null || queryParams.isEmpty()) {
                queryParams = new ArrayList<NameValuePair>();
            }
            queryParams.add((NameValuePair)new BasicNameValuePair("format", "json"));
        }
        URIBuilder uB = new URIBuilder().setScheme(this.serverConfig.isUseHTTPS() ? "https" : "http").setHost(this.serverConfig.getServerName()).setPort(this.serverConfig.getPort()).setPath(subPath);
        if (this.serverConfig.getAuthenticationConfig().usesBasicAuthentication()) {
            uB.setUserInfo(this.serverConfig.getAuthenticationConfig().getLoginName(), this.serverConfig.getAuthenticationConfig().getPassword());
        }
        if (queryParams != null) {
            uB.addParameters(queryParams);
        }
        try {
            return uB.build();
        }
        catch (URISyntaxException e) {
            throw new NextcloudApiException(e);
        }
    }

    private <R> CompletableFuture<R> executeRequest(ResponseParser<R> parser, HttpRequestBase request) throws IOException, ClientProtocolException {
        request.addHeader("OCS-APIRequest", "true");
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpClientContext context = this.prepareContext();
        CompletableFuture futureResponse = new CompletableFuture();
        HttpAsyncClientSingleton.getInstance(this.serverConfig).execute((HttpUriRequest)request, (HttpContext)context, new ResponseCallback(parser, futureResponse));
        return futureResponse;
    }

    private HttpClientContext prepareContext() {
        if (this.serverConfig.getAuthenticationConfig().usesBasicAuthentication()) {
            HttpHost targetHost = new HttpHost(this.serverConfig.getServerName(), this.serverConfig.getPort(), this.serverConfig.isUseHTTPS() ? "https" : "http");
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(targetHost, (AuthScheme)new BasicScheme());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.serverConfig.getAuthenticationConfig().getLoginName(), this.serverConfig.getAuthenticationConfig().getPassword());
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            HttpClientContext context = HttpClientContext.create();
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
            context.setAuthCache((AuthCache)authCache);
            return context;
        }
        return HttpClientContext.create();
    }

    public static void shutdown() throws IOException {
        if (HttpAsyncClientSingleton.HTTPC_CLIENT != null) {
            HttpAsyncClientSingleton.getInstance(null).close();
        }
    }

    public static interface ResponseParser<R> {
        public R parseResponse(Reader var1);
    }

    private static class HttpAsyncClientSingleton {
        private static CloseableHttpAsyncClient HTTPC_CLIENT;

        private HttpAsyncClientSingleton() {
        }

        public static CloseableHttpAsyncClient getInstance(ServerConfig serverConfig) throws IOException {
            if (HTTPC_CLIENT == null) {
                if (serverConfig.isTrustAllCertificates()) {
                    try {
                        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
                        HTTPC_CLIENT = HttpAsyncClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(sslContext).build();
                    }
                    catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                        throw new IOException(e);
                    }
                } else {
                    HTTPC_CLIENT = HttpAsyncClients.createDefault();
                }
                HTTPC_CLIENT.start();
            }
            return HTTPC_CLIENT;
        }
    }

    private final class ResponseCallback<R>
    implements FutureCallback<HttpResponse> {
        private final ResponseParser<R> parser;
        private final CompletableFuture<R> futureResponse;

        private ResponseCallback(ResponseParser<R> parser, CompletableFuture<R> futureResponse) {
            this.parser = parser;
            this.futureResponse = futureResponse;
        }

        public void completed(HttpResponse response) {
            try {
                R result = this.handleResponse(this.parser, response);
                this.futureResponse.complete(result);
            }
            catch (Exception ex) {
                this.futureResponse.completeExceptionally(ex);
            }
        }

        private R handleResponse(ResponseParser<R> parser, HttpResponse response) throws IOException {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    Charset charset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                    InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);
                    return parser.parseResponse(reader);
                }
                throw new NextcloudApiException("Empty response received");
            }
            throw new NextcloudApiException(String.format("Request failed with %d %s", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
        }

        public void failed(Exception ex) {
            this.futureResponse.completeExceptionally(ex);
        }

        public void cancelled() {
            this.futureResponse.cancel(true);
        }
    }
}

