/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.provisioning;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.aarboard.nextcloud.api.ServerConfig;
import org.aarboard.nextcloud.api.provisioning.GroupListAnswer;
import org.aarboard.nextcloud.api.provisioning.User;
import org.aarboard.nextcloud.api.provisioning.UserData;
import org.aarboard.nextcloud.api.provisioning.UserDetailsAnswer;
import org.aarboard.nextcloud.api.provisioning.UserDetailsListAnswer;
import org.aarboard.nextcloud.api.provisioning.UserListAnswer;
import org.aarboard.nextcloud.api.utils.ConnectorCommon;
import org.aarboard.nextcloud.api.utils.JsonAnswerParser;
import org.aarboard.nextcloud.api.utils.JsonListAnswer;
import org.aarboard.nextcloud.api.utils.JsonVoidAnswer;
import org.aarboard.nextcloud.api.utils.NextcloudResponseHelper;
import org.aarboard.nextcloud.api.utils.NextcloudSearch;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ProvisionConnector {
    private static final String ROOT_PART = "ocs/v1.php/cloud/";
    private static final String USER_PART = "ocs/v1.php/cloud/user";
    private static final String USERS_PART = "ocs/v1.php/cloud/users";
    private static final String GROUPS_PART = "ocs/v1.php/cloud/groups";
    private final ConnectorCommon connectorCommon;

    public ProvisionConnector(ServerConfig serverConfig) {
        this.connectorCommon = new ConnectorCommon(serverConfig);
    }

    public CompletableFuture<JsonVoidAnswer> createUserAsync(String userId, String password, Optional<String> displayName, Optional<String> email, Optional<String> quota, Optional<String> language, List<String> groups) {
        LinkedList<NameValuePair> postParams = new LinkedList<NameValuePair>();
        postParams.add((NameValuePair)new BasicNameValuePair("userid", userId));
        postParams.add((NameValuePair)new BasicNameValuePair("password", password));
        if (displayName.isPresent()) {
            postParams.add((NameValuePair)new BasicNameValuePair("displayName", displayName.get()));
        }
        if (email.isPresent()) {
            postParams.add((NameValuePair)new BasicNameValuePair("email", email.get()));
        }
        if (quota.isPresent()) {
            postParams.add((NameValuePair)new BasicNameValuePair("quota", quota.get()));
        }
        if (language.isPresent()) {
            postParams.add((NameValuePair)new BasicNameValuePair("language", language.get()));
        }
        groups.forEach(group -> postParams.add((NameValuePair)new BasicNameValuePair("groups[]", group)));
        return this.connectorCommon.executePost(USERS_PART, postParams, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public boolean deleteUser(String userId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.deleteUserAsync(userId));
    }

    public CompletableFuture<JsonVoidAnswer> deleteUserAsync(String userId) {
        return this.connectorCommon.executeDelete(USERS_PART, userId, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public List<String> getAllUsers() {
        return this.getAllUsers(null, -1, -1);
    }

    public CompletableFuture<UserListAnswer> getAllUsersAsync() {
        return this.getAllUsersAsync(null, -1, -1);
    }

    public List<String> getAllUsers(String search, int limit, int offset) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getAllUsersAsync(search, limit, offset)).getAllUsers();
    }

    public CompletableFuture<UserListAnswer> getAllUsersAsync(String search, int limit, int offset) {
        NextcloudSearch nextcloudSearch = new NextcloudSearch(search, limit, offset);
        return this.connectorCommon.executeGet(USERS_PART, nextcloudSearch.asQueryParameters(), JsonAnswerParser.getInstance(UserListAnswer.class));
    }

    public List<User> getAllUserDetails() {
        return this.getAllUserDetails(null, -1, -1);
    }

    public CompletableFuture<UserDetailsListAnswer> getAllUserDetailsAsync() {
        return this.getAllUserDetailsAsync(null, -1, -1);
    }

    public List<User> getAllUserDetails(String search, int limit, int offset) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getAllUserDetailsAsync(search, limit, offset)).getAllUserDetails();
    }

    public CompletableFuture<UserDetailsListAnswer> getAllUserDetailsAsync(String search, int limit, int offset) {
        NextcloudSearch nextcloudSearch = new NextcloudSearch(search, limit, offset);
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/users/details", nextcloudSearch.asQueryParameters(), JsonAnswerParser.getInstance(UserDetailsListAnswer.class));
    }

    public User getUser(String userId) {
        return NextcloudResponseHelper.getAndWrapException(this.getUserAsync(userId)).getUserDetails();
    }

    public CompletableFuture<UserDetailsAnswer> getUserAsync(String userId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/users/" + userId, JsonAnswerParser.getInstance(UserDetailsAnswer.class));
    }

    public User getCurrentUser() {
        return NextcloudResponseHelper.getAndCheckStatus(this.getCurrentUserAsync()).getUserDetails();
    }

    public CompletableFuture<UserDetailsAnswer> getCurrentUserAsync() {
        return this.connectorCommon.executeGet(USER_PART, JsonAnswerParser.getInstance(UserDetailsAnswer.class));
    }

    public boolean editUser(String userId, UserData key, String value) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.editUserAsync(userId, key, value));
    }

    public CompletableFuture<JsonVoidAnswer> editUserAsync(String userId, UserData key, String value) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        queryParams.add((NameValuePair)new BasicNameValuePair("key", key.name().toLowerCase()));
        queryParams.add((NameValuePair)new BasicNameValuePair("value", value));
        return this.connectorCommon.executePut(USERS_PART, userId, queryParams, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public boolean enableUser(String userId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.enableUserAsync(userId));
    }

    public CompletableFuture<JsonVoidAnswer> enableUserAsync(String userId) {
        return this.connectorCommon.executePut(USERS_PART, userId + "/enable", null, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public boolean disableUser(String userId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.disableUserAsync(userId));
    }

    public CompletableFuture<JsonVoidAnswer> disableUserAsync(String userId) {
        return this.connectorCommon.executePut(USERS_PART, userId + "/disable", null, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public List<String> getGroupsOfUser(String userId) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getGroupsOfUserAsync(userId)).getAllGroups();
    }

    public CompletableFuture<GroupListAnswer> getGroupsOfUserAsync(String userId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/users/" + userId + "/groups", null, JsonAnswerParser.getInstance(GroupListAnswer.class));
    }

    public boolean addUserToGroup(String userId, String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.addUserToGroupAsync(userId, groupId));
    }

    public CompletableFuture<JsonVoidAnswer> addUserToGroupAsync(String userId, String groupId) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        queryParams.add((NameValuePair)new BasicNameValuePair("groupid", groupId));
        return this.connectorCommon.executePost("ocs/v1.php/cloud/users/" + userId + "/groups", queryParams, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public boolean removeUserFromGroup(String userId, String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.removeUserFromGroupAsync(userId, groupId));
    }

    public CompletableFuture<JsonVoidAnswer> removeUserFromGroupAsync(String userId, String groupId) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        queryParams.add((NameValuePair)new BasicNameValuePair("groupid", groupId));
        return this.connectorCommon.executeDelete(USERS_PART, userId + "/groups", queryParams, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public List<String> getSubadminGroupsOfUser(String userId) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getSubadminGroupsOfUserAsync(userId)).getResult();
    }

    public CompletableFuture<JsonListAnswer> getSubadminGroupsOfUserAsync(String userId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/users/" + userId + "/subadmins", null, JsonAnswerParser.getInstance(JsonListAnswer.class));
    }

    public boolean promoteToSubadmin(String userId, String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.promoteToSubadminAsync(userId, groupId));
    }

    public CompletableFuture<JsonVoidAnswer> promoteToSubadminAsync(String userId, String groupId) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        queryParams.add((NameValuePair)new BasicNameValuePair("groupid", groupId));
        return this.connectorCommon.executePost("ocs/v1.php/cloud/users/" + userId + "/subadmins", queryParams, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public boolean demoteSubadmin(String userId, String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.demoteSubadminAsync(userId, groupId));
    }

    public CompletableFuture<JsonVoidAnswer> demoteSubadminAsync(String userId, String groupId) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        queryParams.add((NameValuePair)new BasicNameValuePair("groupid", groupId));
        return this.connectorCommon.executeDelete(USERS_PART, userId + "/subadmins", queryParams, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public boolean sendWelcomeMail(String userId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.sendWelcomeMailAsync(userId));
    }

    public CompletableFuture<JsonVoidAnswer> sendWelcomeMailAsync(String userId) {
        return this.connectorCommon.executePost("ocs/v1.php/cloud/users/" + userId + "/welcome", JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public List<String> getMembersOfGroup(String groupId) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getMembersOfGroupAsync(groupId)).getAllUsers();
    }

    public CompletableFuture<UserListAnswer> getMembersOfGroupAsync(String groupId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/groups/" + groupId + "/users", JsonAnswerParser.getInstance(UserListAnswer.class));
    }

    public List<User> getMembersDetailsOfGroup(String groupId) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getMembersDetailsOfGroupAsync(groupId)).getAllUserDetails();
    }

    public CompletableFuture<UserDetailsListAnswer> getMembersDetailsOfGroupAsync(String groupId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/groups/" + groupId + "/users/details", JsonAnswerParser.getInstance(UserDetailsListAnswer.class));
    }

    public List<String> getSubadminsOfGroup(String groupId) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getSubadminsOfGroupAsync(groupId)).getResult();
    }

    public CompletableFuture<JsonListAnswer> getSubadminsOfGroupAsync(String groupId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/groups/" + groupId + "/subadmins", null, JsonAnswerParser.getInstance(JsonListAnswer.class));
    }

    public boolean createGroup(String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.createGroupAsync(groupId));
    }

    public CompletableFuture<JsonVoidAnswer> createGroupAsync(String groupId) {
        LinkedList<NameValuePair> postParams = new LinkedList<NameValuePair>();
        postParams.add((NameValuePair)new BasicNameValuePair("groupid", groupId));
        return this.connectorCommon.executePost(GROUPS_PART, postParams, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public boolean deleteGroup(String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.deleteGroupAsync(groupId));
    }

    public CompletableFuture<JsonVoidAnswer> deleteGroupAsync(String groupId) {
        return this.connectorCommon.executeDelete(GROUPS_PART, groupId, null, JsonAnswerParser.getInstance(JsonVoidAnswer.class));
    }

    public List<String> getGroups() {
        return this.getGroups(null, -1, -1);
    }

    public CompletableFuture<GroupListAnswer> getGroupsAsync() {
        return this.getGroupsAsync(null, -1, -1);
    }

    public List<String> getGroups(String search, int limit, int offset) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getGroupsAsync(search, limit, offset)).getAllGroups();
    }

    public CompletableFuture<GroupListAnswer> getGroupsAsync(String search, int limit, int offset) {
        NextcloudSearch nextcloudSearch = new NextcloudSearch(search, limit, offset);
        return this.connectorCommon.executeGet(GROUPS_PART, nextcloudSearch.asQueryParameters(), JsonAnswerParser.getInstance(GroupListAnswer.class));
    }
}

