/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.filesharing;

public class SharePermissions {
    private final int currentPermission;

    public SharePermissions(int currentPermission) {
        this.currentPermission = currentPermission;
    }

    public SharePermissions(SingleRight ... permissions) {
        int calculatedPermission = 0;
        for (SingleRight permission : permissions) {
            calculatedPermission += permission.getIntValue();
        }
        this.currentPermission = calculatedPermission;
    }

    public boolean hasAllRights() {
        return this.currentPermission == SingleRight.READ.getIntValue() + SingleRight.UPDATE.getIntValue() + SingleRight.CREATE.getIntValue() + SingleRight.DELETE.getIntValue() + SingleRight.SHARE.getIntValue();
    }

    public boolean hasRight(SingleRight permission) {
        return (this.currentPermission & permission.intValue) != 0;
    }

    public int getCurrentPermission() {
        return this.currentPermission;
    }

    public String toString() {
        return Integer.toString(this.currentPermission);
    }

    public static enum SingleRight {
        READ(1),
        UPDATE(2),
        CREATE(4),
        DELETE(8),
        SHARE(16);

        private final int intValue;

        private SingleRight(int iV) {
            this.intValue = iV;
        }

        public int getIntValue() {
            return this.intValue;
        }
    }
}

