/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.config;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.aarboard.nextcloud.api.ServerConfig;
import org.aarboard.nextcloud.api.config.AppConfigAppKeyValueAnswer;
import org.aarboard.nextcloud.api.config.AppConfigAppsAnswer;
import org.aarboard.nextcloud.api.utils.ConnectorCommon;
import org.aarboard.nextcloud.api.utils.NextcloudResponseHelper;
import org.aarboard.nextcloud.api.utils.XMLAnswerParser;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ConfigConnector {
    private static final String CONFIG_PART = "ocs/v2.php/apps/provisioning_api/api/v1/config/";
    private final ConnectorCommon connectorCommon;

    public ConfigConnector(ServerConfig serverConfig) {
        this.connectorCommon = new ConnectorCommon(serverConfig);
    }

    public List<String> getAppConfigApps() {
        return NextcloudResponseHelper.getAndWrapException(this.getAppConfigAppsAsync()).getAppConfigApps();
    }

    private CompletableFuture<AppConfigAppsAnswer> getAppConfigAppsAsync() {
        return this.connectorCommon.executeGet("ocs/v2.php/apps/provisioning_api/api/v1/config/apps", Collections.emptyList(), XMLAnswerParser.getInstance(AppConfigAppsAnswer.class));
    }

    public List<String> getAppConfigAppKeys(String appConfigApp) {
        return NextcloudResponseHelper.getAndWrapException(this.getAppConfigAppsAsync(appConfigApp)).getAppConfigApps();
    }

    private CompletableFuture<AppConfigAppsAnswer> getAppConfigAppsAsync(String appConfigApp) {
        return this.connectorCommon.executeGet("ocs/v2.php/apps/provisioning_api/api/v1/config/apps/" + appConfigApp, Collections.emptyList(), XMLAnswerParser.getInstance(AppConfigAppsAnswer.class));
    }

    public String getAppConfigAppKeyValue(String appConfigApp, String appConfigAppKey) {
        return NextcloudResponseHelper.getAndWrapException(this.getAppConfigAppsKeyAsync(appConfigApp + "/" + appConfigAppKey)).getAppConfigAppKeyValue();
    }

    public String getAppConfigAppKeyValue(String appConfigAppKeyPath) {
        return NextcloudResponseHelper.getAndWrapException(this.getAppConfigAppsKeyAsync(appConfigAppKeyPath)).getAppConfigAppKeyValue();
    }

    private CompletableFuture<AppConfigAppKeyValueAnswer> getAppConfigAppsKeyAsync(String appConfigAppKeyPath) {
        return this.connectorCommon.executeGet("ocs/v2.php/apps/provisioning_api/api/v1/config/apps/" + appConfigAppKeyPath, Collections.emptyList(), XMLAnswerParser.getInstance(AppConfigAppKeyValueAnswer.class));
    }

    public boolean setAppConfigAppKeyValue(String appConfigApp, String appConfigAppKey, Object value) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.setAppConfigAppKeyValueAsync(appConfigApp + "/" + appConfigAppKey, value));
    }

    public boolean setAppConfigAppKeyValue(String appConfigAppKeyPath, Object value) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.setAppConfigAppKeyValueAsync(appConfigAppKeyPath, value));
    }

    public CompletableFuture<AppConfigAppKeyValueAnswer> setAppConfigAppKeyValueAsync(String appConfigAppKeyPath, Object value) {
        LinkedList<NameValuePair> postParams = new LinkedList<NameValuePair>();
        postParams.add((NameValuePair)new BasicNameValuePair("value", value.toString()));
        return this.connectorCommon.executePost("ocs/v2.php/apps/provisioning_api/api/v1/config/apps/" + appConfigAppKeyPath, postParams, XMLAnswerParser.getInstance(AppConfigAppKeyValueAnswer.class));
    }

    public boolean deleteAppConfigAppKeyEntry(String appConfigApp, String appConfigAppkey) {
        throw new UnsupportedOperationException();
    }
}

