/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.statebundle;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class StateBundle
implements Parcelable {
    static final int type_boolean = 0;
    static final int type_byte = 1;
    static final int type_char = 2;
    static final int type_short = 3;
    static final int type_int = 4;
    static final int type_long = 5;
    static final int type_float = 6;
    static final int type_double = 7;
    static final int type_String = 8;
    static final int type_CharSequence = 9;
    static final int type_Serializable = 10;
    static final int type_IntegerArrayList = 11;
    static final int type_StringArrayList = 12;
    static final int type_CharSequenceArrayList = 13;
    static final int type_BooleanArray = 14;
    static final int type_ByteArray = 15;
    static final int type_ShortArray = 16;
    static final int type_CharArray = 17;
    static final int type_IntArray = 18;
    static final int type_LongArray = 19;
    static final int type_FloatArray = 20;
    static final int type_DoubleArray = 21;
    static final int type_StateBundle = 26;
    static final int type_Parcelable = 27;
    static final int type_ParcelableArrayList = 29;
    static final int type_SparseParcelableArray = 30;
    private static final String TAG = "StateBundle";
    Map<String, Object> map = new LinkedHashMap<String, Object>();
    Map<String, Integer> typeMap = new LinkedHashMap<String, Integer>();
    public static final Parcelable.Creator<StateBundle> CREATOR = new Parcelable.Creator<StateBundle>(){

        public StateBundle createFromParcel(Parcel in) {
            return new StateBundle(in);
        }

        public StateBundle[] newArray(int size) {
            return new StateBundle[size];
        }
    };

    public StateBundle() {
    }

    public StateBundle(StateBundle bundle) {
        this.putAll(bundle);
    }

    protected StateBundle(Parcel in) {
        int size = in.readInt();
        block28: for (int i = 0; i < size; ++i) {
            TypeElement typeElement = (TypeElement)in.readParcelable(TypeElement.class.getClassLoader());
            Object object = in.readValue(this.getClass().getClassLoader());
            switch (typeElement.type) {
                case 0: {
                    this.putBoolean(typeElement.key, (Boolean)object);
                    continue block28;
                }
                case 1: {
                    this.putByte(typeElement.key, (Byte)object);
                    continue block28;
                }
                case 2: {
                    this.putChar(typeElement.key, ((Character)object).charValue());
                    continue block28;
                }
                case 3: {
                    this.putShort(typeElement.key, (Short)object);
                    continue block28;
                }
                case 4: {
                    this.putInt(typeElement.key, (Integer)object);
                    continue block28;
                }
                case 5: {
                    this.putLong(typeElement.key, (Long)object);
                    continue block28;
                }
                case 6: {
                    this.putFloat(typeElement.key, ((Float)object).floatValue());
                    continue block28;
                }
                case 7: {
                    this.putDouble(typeElement.key, (Double)object);
                    continue block28;
                }
                case 8: {
                    this.putString(typeElement.key, (String)object);
                    continue block28;
                }
                case 9: {
                    this.putCharSequence(typeElement.key, (CharSequence)object);
                    continue block28;
                }
                case 10: {
                    this.putSerializable(typeElement.key, (Serializable)object);
                    continue block28;
                }
                case 11: {
                    this.putIntegerArrayList(typeElement.key, (ArrayList)object);
                    continue block28;
                }
                case 12: {
                    this.putStringArrayList(typeElement.key, (ArrayList)object);
                    continue block28;
                }
                case 13: {
                    this.putCharSequenceArrayList(typeElement.key, (ArrayList)object);
                    continue block28;
                }
                case 14: {
                    this.putBooleanArray(typeElement.key, (boolean[])object);
                    continue block28;
                }
                case 15: {
                    this.putByteArray(typeElement.key, (byte[])object);
                    continue block28;
                }
                case 16: {
                    this.putShortArray(typeElement.key, (short[])object);
                    continue block28;
                }
                case 17: {
                    this.putCharArray(typeElement.key, (char[])object);
                    continue block28;
                }
                case 18: {
                    this.putIntArray(typeElement.key, (int[])object);
                    continue block28;
                }
                case 19: {
                    this.putLongArray(typeElement.key, (long[])object);
                    continue block28;
                }
                case 20: {
                    this.putFloatArray(typeElement.key, (float[])object);
                    continue block28;
                }
                case 21: {
                    this.putDoubleArray(typeElement.key, (double[])object);
                    continue block28;
                }
                case 26: {
                    this.putBundle(typeElement.key, (StateBundle)object);
                    continue block28;
                }
                case 27: {
                    this.putParcelable(typeElement.key, (Parcelable)object);
                    continue block28;
                }
                case 29: {
                    this.putParcelableArrayList(typeElement.key, (ArrayList)object);
                    continue block28;
                }
                case 30: {
                    this.putSparseParcelableArray(typeElement.key, (SparseArray<? extends Parcelable>)((SparseArray)object));
                }
            }
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
        this.typeMap.clear();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Nullable
    public Object get(String key) {
        return this.map.get(key);
    }

    public void remove(String key) {
        this.map.remove(key);
        this.typeMap.remove(key);
    }

    public StateBundle putAll(StateBundle bundle) {
        if (bundle.map != null) {
            this.map.putAll(bundle.map);
            this.typeMap.putAll(bundle.typeMap);
        }
        return this;
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public StateBundle putBoolean(@Nullable String key, boolean value) {
        this.map.put(key, value);
        this.typeMap.put(key, 0);
        return this;
    }

    public StateBundle putByte(@Nullable String key, byte value) {
        this.map.put(key, value);
        this.typeMap.put(key, 1);
        return this;
    }

    public StateBundle putChar(@Nullable String key, char value) {
        this.map.put(key, Character.valueOf(value));
        this.typeMap.put(key, 2);
        return this;
    }

    public StateBundle putShort(@Nullable String key, short value) {
        this.map.put(key, value);
        this.typeMap.put(key, 3);
        return this;
    }

    public StateBundle putInt(@Nullable String key, int value) {
        this.map.put(key, value);
        this.typeMap.put(key, 4);
        return this;
    }

    public StateBundle putLong(@Nullable String key, long value) {
        this.map.put(key, value);
        this.typeMap.put(key, 5);
        return this;
    }

    public StateBundle putFloat(@Nullable String key, float value) {
        this.map.put(key, Float.valueOf(value));
        this.typeMap.put(key, 6);
        return this;
    }

    public StateBundle putDouble(@Nullable String key, double value) {
        this.map.put(key, value);
        this.typeMap.put(key, 7);
        return this;
    }

    public StateBundle putString(@Nullable String key, @Nullable String value) {
        this.map.put(key, value);
        this.typeMap.put(key, 8);
        return this;
    }

    public StateBundle putCharSequence(@Nullable String key, @Nullable CharSequence value) {
        this.map.put(key, value);
        this.typeMap.put(key, 9);
        return this;
    }

    public StateBundle putIntegerArrayList(@Nullable String key, @Nullable ArrayList<Integer> value) {
        this.map.put(key, value);
        this.typeMap.put(key, 11);
        return this;
    }

    public StateBundle putStringArrayList(@Nullable String key, @Nullable ArrayList<String> value) {
        this.map.put(key, value);
        this.typeMap.put(key, 12);
        return this;
    }

    public StateBundle putCharSequenceArrayList(@Nullable String key, @Nullable ArrayList<CharSequence> value) {
        this.map.put(key, value);
        this.typeMap.put(key, 13);
        return this;
    }

    public StateBundle putSerializable(@Nullable String key, @Nullable Serializable value) {
        this.map.put(key, value);
        this.typeMap.put(key, 10);
        return this;
    }

    public StateBundle putBooleanArray(@Nullable String key, @Nullable boolean[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 14);
        return this;
    }

    public StateBundle putByteArray(@Nullable String key, @Nullable byte[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 15);
        return this;
    }

    public StateBundle putShortArray(@Nullable String key, @Nullable short[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 16);
        return this;
    }

    public StateBundle putCharArray(@Nullable String key, @Nullable char[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 17);
        return this;
    }

    public StateBundle putIntArray(@Nullable String key, @Nullable int[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 18);
        return this;
    }

    public StateBundle putLongArray(@Nullable String key, @Nullable long[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 19);
        return this;
    }

    public StateBundle putFloatArray(@Nullable String key, @Nullable float[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 20);
        return this;
    }

    public StateBundle putDoubleArray(@Nullable String key, @Nullable double[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 21);
        return this;
    }

    public StateBundle putParcelable(@Nullable String key, @Nullable Parcelable value) {
        this.map.put(key, value);
        this.typeMap.put(key, 27);
        return this;
    }

    public StateBundle putParcelableArrayList(@Nullable String key, @Nullable ArrayList<? extends Parcelable> value) {
        this.map.put(key, value);
        this.typeMap.put(key, 29);
        return this;
    }

    public StateBundle putSparseParcelableArray(@Nullable String key, @Nullable SparseArray<? extends Parcelable> value) {
        this.map.put(key, value);
        this.typeMap.put(key, 30);
        return this;
    }

    public StateBundle putBundle(@Nullable String key, @Nullable StateBundle value) {
        this.map.put(key, value);
        this.typeMap.put(key, 26);
        return this;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Boolean)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Boolean", defaultValue, e);
            return defaultValue;
        }
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public Byte getByte(String key, byte defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Byte)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Byte", defaultValue, e);
            return defaultValue;
        }
    }

    public char getChar(String key) {
        return this.getChar(key, '\u0000');
    }

    public char getChar(String key, char defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Character)o).charValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Character", Character.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Short)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Short", defaultValue, e);
            return defaultValue;
        }
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Integer)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Integer", defaultValue, e);
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Long)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Long", defaultValue, e);
            return defaultValue;
        }
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Float)o).floatValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Float", Float.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Double)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Double", defaultValue, e);
            return defaultValue;
        }
    }

    @Nullable
    public String getString(@Nullable String key) {
        Object o = this.map.get(key);
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "String", e);
            return null;
        }
    }

    public String getString(@Nullable String key, String defaultValue) {
        String s = this.getString(key);
        return s == null ? defaultValue : s;
    }

    @Nullable
    public CharSequence getCharSequence(@Nullable String key) {
        Object o = this.map.get(key);
        try {
            return (CharSequence)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "CharSequence", e);
            return null;
        }
    }

    public CharSequence getCharSequence(@Nullable String key, CharSequence defaultValue) {
        CharSequence cs = this.getCharSequence(key);
        return cs == null ? defaultValue : cs;
    }

    @Nullable
    public Serializable getSerializable(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Serializable)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Serializable", e);
            return null;
        }
    }

    @Nullable
    public ArrayList<Integer> getIntegerArrayList(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<Integer>", e);
            return null;
        }
    }

    @Nullable
    public ArrayList<String> getStringArrayList(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<String>", e);
            return null;
        }
    }

    @Nullable
    public ArrayList<CharSequence> getCharSequenceArrayList(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<CharSequence>", e);
            return null;
        }
    }

    @Nullable
    public boolean[] getBooleanArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (boolean[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    @Nullable
    public byte[] getByteArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (byte[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    @Nullable
    public short[] getShortArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (short[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "short[]", e);
            return null;
        }
    }

    @Nullable
    public char[] getCharArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (char[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "char[]", e);
            return null;
        }
    }

    @Nullable
    public int[] getIntArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (int[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "int[]", e);
            return null;
        }
    }

    @Nullable
    public long[] getLongArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (long[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "long[]", e);
            return null;
        }
    }

    @Nullable
    public float[] getFloatArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (float[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "float[]", e);
            return null;
        }
    }

    @Nullable
    public double[] getDoubleArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (double[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "double[]", e);
            return null;
        }
    }

    @Nullable
    public StateBundle getBundle(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (StateBundle)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Bundle", e);
            return null;
        }
    }

    @Nullable
    public <T extends Parcelable> T getParcelable(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (T)((Parcelable)o);
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Parcelable", e);
            return null;
        }
    }

    @Nullable
    public <T extends Parcelable> ArrayList<T> getParcelableArrayList(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList", e);
            return null;
        }
    }

    @Nullable
    public <T extends Parcelable> SparseArray<T> getSparseParcelableArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (SparseArray)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "SparseArray", e);
            return null;
        }
    }

    void typeWarning(String key, Object value, String className, Object defaultValue, ClassCastException e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key ");
        sb.append(key);
        sb.append(" expected ");
        sb.append(className);
        sb.append(" but value was a ");
        sb.append(value.getClass().getName());
        sb.append(".  The default value ");
        sb.append(defaultValue);
        sb.append(" was returned.");
        System.out.println(sb.toString());
    }

    void typeWarning(String key, Object value, String className, ClassCastException e) {
        this.typeWarning(key, value, className, "<null>", e);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.map.keySet().size());
        for (String key : this.map.keySet()) {
            TypeElement typeElement = new TypeElement(key, this.typeMap.get(key));
            dest.writeParcelable((Parcelable)typeElement, 0);
            dest.writeValue(this.get(key));
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        Set<Map.Entry<String, Object>> entrySet = this.map.entrySet();
        if (entrySet.isEmpty()) {
            stringBuilder.append("[]");
        } else {
            for (Map.Entry<String, Object> entry : entrySet) {
                stringBuilder.append("{[");
                stringBuilder.append(entry.getKey());
                stringBuilder.append("]::[");
                int type = this.typeMap.get(entry.getKey());
                if (entry.getValue() == null) {
                    stringBuilder.append("<null>");
                } else if (type == 14) {
                    stringBuilder.append(Arrays.toString((boolean[])entry.getValue()));
                } else if (type == 15) {
                    stringBuilder.append(Arrays.toString((byte[])entry.getValue()));
                } else if (type == 16) {
                    stringBuilder.append(Arrays.toString((short[])entry.getValue()));
                } else if (type == 17) {
                    stringBuilder.append(Arrays.toString((char[])entry.getValue()));
                } else if (type == 18) {
                    stringBuilder.append(Arrays.toString((int[])entry.getValue()));
                } else if (type == 19) {
                    stringBuilder.append(Arrays.toString((long[])entry.getValue()));
                } else if (type == 20) {
                    stringBuilder.append(Arrays.toString((float[])entry.getValue()));
                } else if (type == 21) {
                    stringBuilder.append(Arrays.toString((double[])entry.getValue()));
                } else {
                    stringBuilder.append(entry.getValue());
                }
                stringBuilder.append("]}");
                if (++i >= entrySet.size()) continue;
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int result = 0;
        Set<Map.Entry<String, Object>> entrySet = this.map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            result += 31 * entry.getKey().hashCode();
            int type = this.typeMap.get(entry.getKey());
            if (entry.getValue() == null) {
                result += 0;
                continue;
            }
            if (type == 14) {
                result += 31 * Arrays.hashCode((boolean[])entry.getValue());
                continue;
            }
            if (type == 15) {
                result += 31 * Arrays.hashCode((byte[])entry.getValue());
                continue;
            }
            if (type == 16) {
                result += 31 * Arrays.hashCode((short[])entry.getValue());
                continue;
            }
            if (type == 17) {
                result += 31 * Arrays.hashCode((char[])entry.getValue());
                continue;
            }
            if (type == 18) {
                result += 31 * Arrays.hashCode((int[])entry.getValue());
                continue;
            }
            if (type == 19) {
                result += 31 * Arrays.hashCode((long[])entry.getValue());
                continue;
            }
            if (type == 20) {
                result += 31 * Arrays.hashCode((float[])entry.getValue());
                continue;
            }
            if (type == 21) {
                result += 31 * Arrays.hashCode((double[])entry.getValue());
                continue;
            }
            result += 31 * entry.getValue().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateBundle)) {
            return false;
        }
        StateBundle other = (StateBundle)obj;
        for (Map.Entry<String, Object> stored : this.map.entrySet()) {
            boolean eq;
            if (!other.containsKey(stored.getKey())) {
                return false;
            }
            if (!other.typeMap.containsKey(stored.getKey())) {
                return false;
            }
            int type = this.typeMap.get(stored.getKey());
            if (!other.typeMap.get(stored.getKey()).equals(type)) {
                return false;
            }
            Object thisObj = stored.getValue();
            Object thatObj = other.get(stored.getKey());
            if (thisObj == null && thatObj == null) continue;
            if (thisObj == null && thatObj != null || thisObj != null && thatObj == null) {
                return false;
            }
            if (!(type == 14 ? !(eq = Arrays.equals((boolean[])thisObj, (boolean[])thatObj)) : (type == 15 ? !(eq = Arrays.equals((byte[])thisObj, (byte[])thatObj)) : (type == 16 ? !(eq = Arrays.equals((short[])thisObj, (short[])thatObj)) : (type == 17 ? !(eq = Arrays.equals((char[])thisObj, (char[])thatObj)) : (type == 18 ? !(eq = Arrays.equals((int[])thisObj, (int[])thatObj)) : (type == 19 ? !(eq = Arrays.equals((long[])thisObj, (long[])thatObj)) : (type == 20 ? !(eq = Arrays.equals((float[])thisObj, (float[])thatObj)) : (type == 21 ? !(eq = Arrays.equals((double[])thisObj, (double[])thatObj)) : !thisObj.equals(thatObj)))))))))) continue;
            return false;
        }
        return true;
    }

    static class TypeElement
    implements Parcelable {
        String key;
        int type;
        public static final Parcelable.Creator<TypeElement> CREATOR = new Parcelable.Creator<TypeElement>(){

            public TypeElement createFromParcel(Parcel in) {
                return new TypeElement(in);
            }

            public TypeElement[] newArray(int size) {
                return new TypeElement[size];
            }
        };

        TypeElement() {
        }

        TypeElement(String key, int type) {
            this.key = key;
            this.type = type;
        }

        protected TypeElement(Parcel in) {
            this.key = in.readString();
            this.type = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.key);
            dest.writeInt(this.type);
        }
    }
}

