/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import java.util.ArrayList;
import java.util.List;

public abstract class AheadOfTimeBackCallback {
    private final long threadId = Thread.currentThread().getId();
    private final List<EnabledChangedListener> enabledChangedListeners = new ArrayList<EnabledChangedListener>();
    private boolean isEnabled;

    public AheadOfTimeBackCallback(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.checkCorrectThread();
        boolean previousDisabled = this.isEnabled;
        this.isEnabled = isEnabled;
        if (previousDisabled != isEnabled) {
            this.notifyEnabledChangedListeners(isEnabled);
        }
    }

    private void checkCorrectThread() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException("Object should only be mutated on the same thread where the object was created.");
        }
    }

    public void addEnabledChangedListener(EnabledChangedListener enabledChangedListener) {
        this.checkCorrectThread();
        this.enabledChangedListeners.add(enabledChangedListener);
    }

    public void removeEnabledChangedListener(EnabledChangedListener enabledChangedListener) {
        this.checkCorrectThread();
        this.enabledChangedListeners.remove(enabledChangedListener);
    }

    private void notifyEnabledChangedListeners(boolean isEnabled) {
        ArrayList<EnabledChangedListener> copy = new ArrayList<EnabledChangedListener>(this.enabledChangedListeners);
        for (EnabledChangedListener listener : copy) {
            listener.onEnabledChanged(isEnabled);
        }
    }

    public abstract void onBackReceived();

    public static interface EnabledChangedListener {
        public void onEnabledChanged(boolean var1);
    }
}

