/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import com.zhuinden.simplestack.AheadOfTimeBackCallback;
import com.zhuinden.simplestack.AheadOfTimeBackCallbackRegistry;
import com.zhuinden.simplestack.AheadOfTimeBackProcessingContractViolationException;
import com.zhuinden.simplestack.AheadOfTimeWillHandleBackChangedListener;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.Bundleable;
import com.zhuinden.simplestack.CollectionHelper;
import com.zhuinden.simplestack.GlobalServices;
import com.zhuinden.simplestack.ScopeKey;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopeNode;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.simplestack.ServiceBinder;
import com.zhuinden.statebundle.StateBundle;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ScopeManager {
    private boolean willHandleAheadOfTimeBackEvent;
    private List<AheadOfTimeWillHandleBackChangedListener> aheadOfTimeWillHandleBackChangedListeners = new ArrayList<AheadOfTimeWillHandleBackChangedListener>();
    private final AheadOfTimeBackCallback.EnabledChangedListener innerEnabledChangedListener = new AheadOfTimeBackCallback.EnabledChangedListener(){

        @Override
        public void onEnabledChanged(boolean isEnabled) {
            if (((ScopeManager)ScopeManager.this).backstack.previousTopKeyWithAssociatedScope != null) {
                ScopeManager.this.updateWillHandleAheadOfTimeBackEvent(((ScopeManager)ScopeManager.this).backstack.previousTopKeyWithAssociatedScope);
            }
        }
    };
    private static final String GLOBAL_SCOPE_TAG = "__SIMPLE_STACK_INTERNAL_GLOBAL_SCOPE__";
    private final ScopeRegistration globalScopeRegistration = new ScopeRegistration(null, "__SIMPLE_STACK_INTERNAL_GLOBAL_SCOPE__", Collections.emptyList(), true, true, false);
    private static final GlobalServices EMPTY_GLOBAL_SERVICES = GlobalServices.builder().build();
    private final ScopeRegistrations scopes = new ScopeRegistrations();
    private final IdentityHashMap<ScopedServices.HandlesBack, Boolean> backDispatchedServices = new IdentityHashMap();
    private final LinkedHashSet<Object> trackedKeys = new LinkedHashSet();
    private final IdentityHashMap<Object, Set<String>> scopeEnteredServices = new IdentityHashMap();
    private final IdentityHashMap<Object, Set<String>> scopeActivatedServices = new IdentityHashMap();
    private final IdentityHashMap<Object, Integer> untrackEventInvocationTracker = new IdentityHashMap();
    private boolean isGlobalScopePendingActivation = true;
    private GlobalServices globalServices = EMPTY_GLOBAL_SERVICES;
    private GlobalServices.Factory globalServiceFactory = null;
    private ScopedServices scopedServices = new AssertingScopedServices();
    private Backstack backstack;
    private final StateBundle rootBundle = new StateBundle();
    private boolean isInitialized = false;
    private boolean isFinalized = false;
    private IdentityHashMap<Object, String> dummyScopeTags = new IdentityHashMap();

    public void addAheadOfTimeWillHandleBackChangedListener(AheadOfTimeWillHandleBackChangedListener aheadOfTimeWillHandleBackChangedListener) {
        this.aheadOfTimeWillHandleBackChangedListeners.add(aheadOfTimeWillHandleBackChangedListener);
    }

    public void removeAheadOfTimeWillHandleBackChangedListener(AheadOfTimeWillHandleBackChangedListener aheadOfTimeWillHandleBackChangedListener) {
        this.aheadOfTimeWillHandleBackChangedListeners.remove(aheadOfTimeWillHandleBackChangedListener);
    }

    void activateGlobalScope() {
        this.notifyScopeActivation(GLOBAL_SCOPE_TAG, this.globalServices.getScope());
    }

    void deactivateGlobalScope() {
        this.notifyScopeDeactivation(GLOBAL_SCOPE_TAG, this.globalServices.getScope());
    }

    ScopeManager() {
    }

    void setBackstack(Backstack backstack) {
        this.backstack = backstack;
    }

    Backstack getBackstack() {
        return this.backstack;
    }

    void setScopedServices(ScopedServices scopedServices) {
        this.scopedServices = scopedServices;
    }

    void setGlobalServices(GlobalServices globalServices) {
        this.globalServices = globalServices;
    }

    void setGlobalServices(GlobalServices.Factory globalServiceFactory) {
        this.globalServiceFactory = globalServiceFactory;
    }

    private void buildGlobalScope() {
        if (!this.scopes.containsKey(GLOBAL_SCOPE_TAG)) {
            if (this.globalServiceFactory != null) {
                this.globalServices = this.globalServiceFactory.create(this.backstack);
                for (Map.Entry<String, Object> entry : this.globalServices.services()) {
                    if (entry.getValue() != this.backstack) continue;
                    throw new IllegalArgumentException("The root backstack should not be added as a service, as it would cause a circular save-state loop. Adding it as an alias would work, but should typically not be necessary because of `serviceBinder.getBackstack()`.");
                }
            }
            ScopeNode scope = this.globalServices.getScope();
            this.scopes.put(this.globalScopeRegistration, new ScopeRegistrations.ScopeInternals(scope, new AheadOfTimeBackCallbackRegistry()));
            this.restoreAndNotifyServices(GLOBAL_SCOPE_TAG, scope);
        }
    }

    private void buildScope(Object key, String scopeTag, boolean isExplicitParent, boolean isDummyScope) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag provided by scope key cannot be null!");
        }
        if (!this.scopes.containsKey(scopeTag)) {
            ScopeRegistrations.ScopeInternals scopeInternals = new ScopeRegistrations.ScopeInternals(new ScopeNode(), new AheadOfTimeBackCallbackRegistry());
            this.scopes.putKey(key, scopeTag, scopeInternals, isExplicitParent, false, isDummyScope);
            scopeInternals.aheadOfTimeBackCallbackRegistry.addEnabledChangedListener(this.innerEnabledChangedListener);
            if (!isDummyScope) {
                this.scopedServices.bindServices(new ServiceBinder(this, key, scopeTag, scopeInternals.scopeNode, scopeInternals.aheadOfTimeBackCallbackRegistry));
                for (Map.Entry<String, Object> entry : scopeInternals.scopeNode.services()) {
                    if (entry.getValue() != this.backstack) continue;
                    throw new IllegalArgumentException("The root backstack should not be added as a service, as it would cause a circular save-state loop. Adding it as an alias would work, but should typically not be necessary because of `serviceBinder.getBackstack()`.");
                }
                this.restoreAndNotifyServices(scopeTag, scopeInternals.scopeNode);
            }
        }
    }

    private void restoreAndNotifyServices(String scopeTag, ScopeNode scope) {
        for (Map.Entry<String, Object> serviceEntry : scope.services()) {
            String serviceTag = serviceEntry.getKey();
            Object service = serviceEntry.getValue();
            if (this.isServiceNotRegistered(service)) {
                StateBundle scopeBundle;
                if (this.rootBundle.containsKey(scopeTag) && service instanceof Bundleable && (scopeBundle = this.rootBundle.getBundle(scopeTag)) != null && scopeBundle.containsKey(serviceTag)) {
                    ((Bundleable)service).fromBundle(scopeBundle.getBundle(serviceTag));
                }
                if (service instanceof ScopedServices.Registered) {
                    ((ScopedServices.Registered)service).onServiceRegistered();
                }
            }
            if (!this.isServiceNotTrackedInScope(this.scopeEnteredServices, service, scopeTag)) continue;
            this.trackServiceInScope(this.scopeEnteredServices, service, scopeTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchBack(@Nonnull Object currentTop) {
        this.backDispatchedServices.clear();
        ArrayList<String> scopeTags = new ArrayList<String>(this.scopes.findScopesForKey(currentTop, true));
        try {
            for (String scopeTag : scopeTags) {
                ScopeNode scopeNode = this.scopes.get((String)scopeTag).scopeNode;
                ArrayList<Map.Entry<String, Object>> services = new ArrayList<Map.Entry<String, Object>>(scopeNode.services());
                for (int i = services.size() - 1; i >= 0; --i) {
                    ScopedServices.HandlesBack handlesBack;
                    Object service = ((Map.Entry)services.get(i)).getValue();
                    if (!(service instanceof ScopedServices.HandlesBack) || this.backDispatchedServices.containsKey(handlesBack = (ScopedServices.HandlesBack)service)) continue;
                    this.backDispatchedServices.put(handlesBack, true);
                    boolean handled = handlesBack.onBackEvent();
                    if (!handled) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.backDispatchedServices.clear();
        }
    }

    public boolean willHandleAheadOfTimeBackEvent() {
        return this.willHandleAheadOfTimeBackEvent;
    }

    private void updateWillHandleAheadOfTimeBackEventAndNotifyListeners(boolean willHandleAheadOfTimeBackEvent) {
        boolean previousWillHandleAheadOfTimeBackEvent = this.willHandleAheadOfTimeBackEvent;
        this.willHandleAheadOfTimeBackEvent = willHandleAheadOfTimeBackEvent;
        if (previousWillHandleAheadOfTimeBackEvent != willHandleAheadOfTimeBackEvent) {
            this.notifyWillHandleAheadOfTimeChangedListeners(willHandleAheadOfTimeBackEvent);
        }
    }

    private void notifyWillHandleAheadOfTimeChangedListeners(boolean willHandleAheadOfTimeBackEvent) {
        ArrayList<AheadOfTimeWillHandleBackChangedListener> copy = new ArrayList<AheadOfTimeWillHandleBackChangedListener>(this.aheadOfTimeWillHandleBackChangedListeners);
        for (AheadOfTimeWillHandleBackChangedListener listener : copy) {
            listener.willHandleBackChanged(willHandleAheadOfTimeBackEvent);
        }
    }

    public void updateWillHandleAheadOfTimeBackEvent(@Nonnull Object keyWithAssociatedScope) {
        ArrayList<String> scopeTags = new ArrayList<String>(this.scopes.findScopesForKey(keyWithAssociatedScope, true));
        for (String scopeTag : scopeTags) {
            AheadOfTimeBackCallbackRegistry aheadOfTimeBackCallbackRegistry = this.scopes.get((String)scopeTag).aheadOfTimeBackCallbackRegistry;
            if (!aheadOfTimeBackCallbackRegistry.isEnabled()) continue;
            this.updateWillHandleAheadOfTimeBackEventAndNotifyListeners(true);
            return;
        }
        this.updateWillHandleAheadOfTimeBackEventAndNotifyListeners(false);
    }

    public void handleAheadOfTimeBackEvent(@Nonnull Object currentTop) {
        ArrayList<String> scopeTags = new ArrayList<String>(this.scopes.findScopesForKey(currentTop, true));
        for (String scopeTag : scopeTags) {
            AheadOfTimeBackCallbackRegistry aheadOfTimeBackCallbackRegistry = this.scopes.get((String)scopeTag).aheadOfTimeBackCallbackRegistry;
            if (!aheadOfTimeBackCallbackRegistry.isEnabled()) continue;
            aheadOfTimeBackCallbackRegistry.onBackReceived();
            return;
        }
        throw new AheadOfTimeBackProcessingContractViolationException("ScopeManager attempted to dispatch back, even though no enabled registration was present. This is most likely an error, and shouldn't have happened.");
    }

    private boolean isServiceNotRegistered(Object service) {
        return !this.scopeEnteredServices.containsKey(service) || this.scopeEnteredServices.get(service).isEmpty();
    }

    private boolean isServiceNotActivated(Object service) {
        return !this.scopeActivatedServices.containsKey(service) || this.scopeActivatedServices.get(service).isEmpty();
    }

    private boolean isServiceNotTrackedInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        return !scopeEventTracker.containsKey(service) || !scopeEventTracker.get(service).contains(scopeTag);
    }

    private void trackServiceInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        Set<String> trackedScopes = scopeEventTracker.get(service);
        if (trackedScopes == null) {
            trackedScopes = new LinkedHashSet<String>();
            scopeEventTracker.put(service, trackedScopes);
        }
        trackedScopes.add(scopeTag);
    }

    private void untrackServiceInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        Set<String> trackedScopes = scopeEventTracker.get(service);
        trackedScopes.remove(scopeTag);
        if (trackedScopes.isEmpty()) {
            scopeEventTracker.remove(service);
        }
    }

    boolean isFinalized() {
        return this.isFinalized;
    }

    void finalizeScopes() {
        this.isFinalized = true;
        this.destroyScope(GLOBAL_SCOPE_TAG);
        this.isInitialized = false;
    }

    void buildScopes(List<Object> newKeys) {
        if (this.isFinalized) {
            this.isFinalized = false;
            this.isGlobalScopePendingActivation = true;
        }
        if (!this.isInitialized) {
            this.buildGlobalScope();
        }
        this.isInitialized = true;
        this.trackedKeys.addAll(newKeys);
        for (Object key : newKeys) {
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                for (String parent : child.getParentScopes()) {
                    this.buildScope(key, parent, true, false);
                }
            }
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                String scopeTag = scopeKey.getScopeTag();
                this.buildScope(key, scopeTag, false, false);
                continue;
            }
            String dummyScope = this.dummyScopeTags.containsKey(key) ? this.dummyScopeTags.get(key) : UUID.randomUUID().toString();
            this.dummyScopeTags.put(key, dummyScope);
            this.buildScope(key, dummyScope, false, true);
        }
    }

    void cleanupScopesBy(List<Object> newKeys) {
        LinkedHashSet<String> currentScopes = new LinkedHashSet<String>();
        currentScopes.add(GLOBAL_SCOPE_TAG);
        for (Object key : newKeys) {
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                currentScopes.addAll(child.getParentScopes());
            }
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                currentScopes.add(scopeKey.getScopeTag());
                continue;
            }
            if (!this.dummyScopeTags.containsKey(key)) continue;
            currentScopes.add(this.dummyScopeTags.get(key));
        }
        ArrayList<String> activeScopes = new ArrayList<String>(this.scopes.keySet());
        Collections.reverse(activeScopes);
        for (String activeScope : activeScopes) {
            if (currentScopes.contains(activeScope)) continue;
            this.destroyScope(activeScope);
        }
        CollectionHelper.retainAll(this.trackedKeys, newKeys);
        CollectionHelper.retainAll(this.dummyScopeTags.keySet(), newKeys);
        for (String currentScope : currentScopes) {
            if (!activeScopes.contains(currentScope)) continue;
            this.scopes.reorderToEnd(currentScope);
        }
    }

    void destroyScope(String scopeTag) {
        if (this.scopes.containsKey(scopeTag)) {
            ScopeRegistrations.ScopeInternals scopeInternals = this.scopes.remove(scopeTag);
            this.destroyServicesAndRemoveState(scopeTag, scopeInternals.scopeNode);
            scopeInternals.aheadOfTimeBackCallbackRegistry.removeEnabledChangedListener(this.innerEnabledChangedListener);
        }
    }

    private void destroyServicesAndRemoveState(String scopeTag, ScopeNode scopeNode) {
        Set<Map.Entry<String, Object>> services = scopeNode.services();
        ArrayList<Object> previousServices = new ArrayList<Object>(services.size());
        for (Map.Entry<String, Object> entry : services) {
            previousServices.add(entry.getValue());
        }
        Collections.reverse(previousServices);
        this.untrackEventInvocationTracker.clear();
        for (Map.Entry<String, Object> entry : previousServices) {
            if (!this.isServiceNotTrackedInScope(this.scopeEnteredServices, entry, scopeTag)) {
                this.untrackServiceInScope(this.scopeEnteredServices, entry, scopeTag);
            }
            if (!this.isServiceNotRegistered(entry) || !(entry instanceof ScopedServices.Registered) || this.untrackEventInvocationTracker.containsKey(entry)) continue;
            this.untrackEventInvocationTracker.put(entry, 1);
            ((ScopedServices.Registered)((Object)entry)).onServiceUnregistered();
        }
        this.untrackEventInvocationTracker.clear();
        this.rootBundle.remove(scopeTag);
    }

    void dispatchActivation(@Nonnull Set<String> scopesToDeactivate, @Nonnull Set<String> scopesToActivate) {
        if (this.isGlobalScopePendingActivation) {
            this.isGlobalScopePendingActivation = false;
            this.activateGlobalScope();
        }
        for (String newScopeTag : scopesToActivate) {
            if (!this.scopes.containsKey(newScopeTag)) {
                throw new AssertionError((Object)("The new scope [" + newScopeTag + "] should exist, but it doesn't exist in [" + Arrays.toString(this.scopes.keySet().toArray()) + "]! This shouldn't happen. If you see this error, this functionality is broken."));
            }
            ScopeRegistrations.ScopeInternals newScope = this.scopes.get(newScopeTag);
            this.notifyScopeActivation(newScopeTag, newScope.scopeNode);
        }
        for (String previousScopeTag : scopesToDeactivate) {
            if (!this.scopes.containsKey(previousScopeTag)) {
                throw new AssertionError((Object)("The previous scope [" + previousScopeTag + "] should exist in [" + Arrays.toString(this.scopes.keySet().toArray()) + "]! This shouldn't happen. If you see this error, this functionality is broken."));
            }
            ScopeRegistrations.ScopeInternals previousScopeNode = this.scopes.get(previousScopeTag);
            this.notifyScopeDeactivation(previousScopeTag, previousScopeNode.scopeNode);
        }
    }

    private void notifyScopeActivation(@Nonnull String newScopeTag, @Nonnull ScopeNode newScope) {
        for (Map.Entry<String, Object> entry : newScope.services()) {
            Object service = entry.getValue();
            if (this.isServiceNotActivated(service) && service instanceof ScopedServices.Activated) {
                ((ScopedServices.Activated)service).onServiceActive();
            }
            if (!this.isServiceNotTrackedInScope(this.scopeActivatedServices, service, newScopeTag)) continue;
            this.trackServiceInScope(this.scopeActivatedServices, service, newScopeTag);
        }
    }

    private void notifyScopeDeactivation(String previousScopeTag, ScopeNode previousScope) {
        Set<Map.Entry<String, Object>> services = previousScope.services();
        ArrayList<Object> previousServices = new ArrayList<Object>(services.size());
        for (Map.Entry<String, Object> entry : services) {
            previousServices.add(entry.getValue());
        }
        Collections.reverse(previousServices);
        this.untrackEventInvocationTracker.clear();
        for (Map.Entry<String, Object> entry : previousServices) {
            if (!this.isServiceNotTrackedInScope(this.scopeActivatedServices, entry, previousScopeTag)) {
                this.untrackServiceInScope(this.scopeActivatedServices, entry, previousScopeTag);
            }
            if (!this.isServiceNotActivated(entry) || !(entry instanceof ScopedServices.Activated) || this.untrackEventInvocationTracker.containsKey(entry)) continue;
            this.untrackEventInvocationTracker.put(entry, 1);
            ((ScopedServices.Activated)((Object)entry)).onServiceInactive();
        }
        this.untrackEventInvocationTracker.clear();
    }

    StateBundle saveStates() {
        StateBundle rootBundle = new StateBundle();
        for (Map.Entry<String, ScopeRegistrations.ScopeInternals> scopeSet : this.scopes.entrySet()) {
            String scopeKey = scopeSet.getKey();
            ScopeRegistrations.ScopeInternals scopeInternals = scopeSet.getValue();
            ScopeNode services = scopeInternals.scopeNode;
            StateBundle scopeBundle = new StateBundle();
            for (Map.Entry<String, Object> serviceEntry : services.services()) {
                String serviceTag = serviceEntry.getKey();
                Object service = serviceEntry.getValue();
                if (!(service instanceof Bundleable)) continue;
                scopeBundle.putBundle(serviceTag, ((Bundleable)service).toBundle());
            }
            rootBundle.putBundle(scopeKey, scopeBundle);
        }
        return rootBundle;
    }

    void setRestoredStates(StateBundle rootBundle) {
        if (rootBundle != null) {
            this.rootBundle.putAll(rootBundle);
        }
    }

    boolean hasService(@Nonnull String scopeTag, @Nonnull String serviceTag) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        if (!this.scopes.containsKey(scopeTag)) {
            return false;
        }
        ScopeRegistrations.ScopeInternals scopeInternals = this.scopes.get(scopeTag);
        return scopeInternals != null && scopeInternals.scopeNode.hasService(serviceTag);
    }

    @Nonnull
    <T> T getService(@Nonnull String scopeTag, @Nonnull String serviceTag) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        if (!this.scopes.containsKey(scopeTag)) {
            throw new IllegalArgumentException("The specified scope with tag [" + scopeTag + "] does not exist!");
        }
        ScopeRegistrations.ScopeInternals scopeInternals = this.scopes.get(scopeTag);
        if (!scopeInternals.scopeNode.hasService(serviceTag)) {
            throw new IllegalArgumentException("The specified service with tag [" + serviceTag + "] does not exist in scope [" + scopeTag + "]! Did you accidentally try to use the same scope tag with different services?");
        }
        return scopeInternals.scopeNode.getService(serviceTag);
    }

    boolean hasScope(@Nonnull String scopeTag) {
        ScopeManager.checkScopeTag(scopeTag);
        return this.scopes.containsKey(scopeTag);
    }

    @Nonnull
    Set<String> findScopesForKey(@Nonnull Object key, @Nonnull ScopeLookupMode lookupMode) {
        ScopeManager.checkKey(key);
        ScopeManager.checkScopeLookupMode(lookupMode);
        return lookupMode.executeFindScopesForKey(this, key);
    }

    @Nonnull
    Set<String> findScopesForKeyAll(Object targetKey) {
        if (!this.isInitialized) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForKey(targetKey, false);
        if (!this.isFinalized && !this.globalServices.isEmpty()) {
            activeScopes.add(GLOBAL_SCOPE_TAG);
        }
        return Collections.unmodifiableSet(activeScopes);
    }

    @Nonnull
    Set<String> findScopesForKeyExplicit(Object targetKey) {
        if (!this.isInitialized) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForKey(targetKey, true);
        if (!this.isFinalized && !this.globalServices.isEmpty()) {
            activeScopes.add(GLOBAL_SCOPE_TAG);
        }
        return Collections.unmodifiableSet(activeScopes);
    }

    boolean canFindFromScope(String scopeTag, String serviceTag, ScopeLookupMode lookupMode) {
        ScopeManager.checkServiceTag(serviceTag);
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkScopeLookupMode(lookupMode);
        return lookupMode.executeCanFindFromService(this, scopeTag, serviceTag);
    }

    boolean canFindScope(Object targetKey, String scopeTag, ScopeLookupMode lookupMode) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkScopeLookupMode(lookupMode);
        if (!this.isInitialized) {
            return false;
        }
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForKey(targetKey, lookupMode == ScopeLookupMode.EXPLICIT);
        return activeScopes.contains(scopeTag);
    }

    boolean canFindFromScopeExplicit(String scopeTag, String identifier) {
        if (!this.isInitialized) {
            return false;
        }
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForScopeTag(scopeTag, true);
        for (String scope : activeScopes) {
            ScopeRegistrations.ScopeInternals scopeInternals = this.scopes.get(scope);
            if (scopeInternals == null || !scopeInternals.scopeNode.hasService(identifier)) continue;
            return true;
        }
        return !this.isFinalized && this.globalServices.hasService(identifier);
    }

    boolean canFindFromScopeAll(String scopeTag, String identifier) {
        if (!this.isInitialized) {
            return false;
        }
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForScopeTag(scopeTag, false);
        for (String scope : activeScopes) {
            ScopeRegistrations.ScopeInternals scopeInternals = this.scopes.get(scope);
            if (scopeInternals == null || !scopeInternals.scopeNode.hasService(identifier)) continue;
            return true;
        }
        return !this.isFinalized && this.globalServices.hasService(identifier);
    }

    <T> T lookupFromScope(String scopeTag, String serviceTag, ScopeLookupMode lookupMode) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        ScopeManager.checkScopeLookupMode(lookupMode);
        return lookupMode.executeLookupFromScope(this, scopeTag, serviceTag);
    }

    <T> T lookupFromScopeExplicit(String scopeTag, String identifier) {
        this.verifyStackIsInitialized();
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForScopeTag(scopeTag, true);
        for (String scope : activeScopes) {
            ScopeRegistrations.ScopeInternals scopeInternals = this.scopes.get(scope);
            if (scopeInternals == null || !scopeInternals.scopeNode.hasService(identifier)) continue;
            return scopeInternals.scopeNode.getService(identifier);
        }
        if (!this.isFinalized && this.globalServices.hasService(identifier)) {
            return this.globalServices.getService(identifier);
        }
        throw new IllegalStateException(this.createErrorMessageForServiceLookupFromScope(scopeTag, identifier, activeScopes));
    }

    <T> T lookupFromScopeAll(String scopeTag, String identifier) {
        this.verifyStackIsInitialized();
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForScopeTag(scopeTag, false);
        for (String scope : activeScopes) {
            ScopeRegistrations.ScopeInternals scopeInternals = this.scopes.get(scope);
            if (scopeInternals == null || !scopeInternals.scopeNode.hasService(identifier)) continue;
            return scopeInternals.scopeNode.getService(identifier);
        }
        if (!this.isFinalized && this.globalServices.hasService(identifier)) {
            return this.globalServices.getService(identifier);
        }
        throw new IllegalStateException(this.createErrorMessageForServiceLookupFromScope(scopeTag, identifier, activeScopes));
    }

    String createErrorMessageForServiceLookupFromScope(String scopeTag, String identifier, LinkedHashSet<String> activeScopes) {
        LinkedHashSet<String> as = activeScopes == null ? this.scopes.findScopesForScopeTag(scopeTag, false) : activeScopes;
        return "The service [" + identifier + "] does not exist in any scope that is accessible from [" + scopeTag + "], the nearest scopes are [" + Arrays.toString(as.toArray()) + "]!";
    }

    boolean canFindService(@Nonnull String identifier) {
        ScopeManager.checkServiceTag(identifier);
        List<String> activeScopes = this.scopes.getScopeTagsInTraversalOrder();
        for (String scope : activeScopes) {
            ScopeRegistrations.ScopeInternals scopeInternals = this.scopes.get(scope);
            if (scopeInternals == null || !scopeInternals.scopeNode.hasService(identifier)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    <T> T lookupService(@Nonnull String identifier) {
        ScopeManager.checkServiceTag(identifier);
        this.verifyStackIsInitialized();
        List<String> activeScopes = this.scopes.getScopeTagsInTraversalOrder();
        for (String scope : activeScopes) {
            ScopeRegistrations.ScopeInternals scopeInternals = this.scopes.get(scope);
            if (scopeInternals == null || !scopeInternals.scopeNode.hasService(identifier)) continue;
            return scopeInternals.scopeNode.getService(identifier);
        }
        if (!this.isFinalized && this.globalServices.hasService(identifier)) {
            return this.globalServices.getService(identifier);
        }
        throw new IllegalStateException(this.createErrorMessageForScopeLookup(identifier, activeScopes));
    }

    String createErrorMessageForScopeLookup(String serviceTag, List<String> activeScopes) {
        List<String> as = activeScopes == null ? this.scopes.getScopeTagsInTraversalOrder() : activeScopes;
        return "The service [" + serviceTag + "] does not exist in any accessible scopes, the nearest scopes are " + Arrays.toString(as.toArray()) + "! Is the scope tag registered via a ScopeKey? If yes, make sure the StateChanger has been set by this time, and that you've bound and are trying to lookup the service with the correct service tag. Otherwise, it is likely that the scope you intend to inherit the service from does not exist.";
    }

    private void verifyStackIsInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Cannot lookup from an empty stack.");
        }
    }

    private static void checkKey(@Nonnull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
    }

    private static void checkScopeTag(@Nonnull String scopeTag) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag cannot be null!");
        }
    }

    private static void checkServiceTag(@Nonnull String serviceTag) {
        if (serviceTag == null) {
            throw new IllegalArgumentException("Service tag cannot be null!");
        }
    }

    static void checkParentScopes(ScopeKey.Child child) {
        if (child.getParentScopes() == null) {
            throw new IllegalArgumentException("Parent scopes cannot be null!");
        }
    }

    private static void checkScopeLookupMode(ScopeLookupMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null!");
        }
    }

    static class AssertingScopedServices
    implements ScopedServices {
        AssertingScopedServices() {
        }

        @Override
        public void bindServices(@Nonnull ServiceBinder serviceBinder) {
            throw new IllegalStateException("No scoped services are defined. To create scoped services, an instance of ScopedServices must be provided to configure the services that are available in a given scope.");
        }
    }

    private static class ScopeRegistration {
        private Object key;
        private String scopeTag;
        private List<String> explicitParentScopes;
        private boolean isExplicitParent;
        private boolean isGlobalScope;
        private boolean isDummyScope;

        public ScopeRegistration(@Nullable Object key, @Nonnull String scopeTag, @Nonnull List<String> explicitParentScopes, boolean isExplicitParent, boolean isGlobalScope, boolean isDummyScope) {
            if (scopeTag == null) {
                throw new NullPointerException("scopeTag must not be null!");
            }
            if (explicitParentScopes == null) {
                throw new NullPointerException("explicitParentScopes must not be null!");
            }
            this.key = key;
            this.scopeTag = scopeTag;
            this.explicitParentScopes = explicitParentScopes;
            this.isExplicitParent = isExplicitParent;
            this.isGlobalScope = isGlobalScope;
            this.isDummyScope = isDummyScope;
        }

        public int hashCode() {
            return this.scopeTag.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof ScopeRegistration && ((ScopeRegistration)obj).scopeTag.equals(this.scopeTag);
        }

        @Nonnull
        public String toString() {
            return "ScopeRegistration[scopeTag=[" + this.scopeTag + "], explicitParents=[" + Arrays.toString(this.explicitParentScopes.toArray()) + "]]";
        }
    }

    private static class ScopeRegistrations {
        private final Map<ScopeRegistration, ScopeInternals> scopeRegistrations = new LinkedHashMap<ScopeRegistration, ScopeInternals>();

        private ScopeRegistrations() {
        }

        public boolean containsKey(String scopeTag) {
            for (ScopeRegistration registration : this.scopeRegistrations.keySet()) {
                if (!registration.scopeTag.equals(scopeTag)) continue;
                return true;
            }
            return false;
        }

        public Set<String> keySet() {
            LinkedHashSet<String> scopes = new LinkedHashSet<String>();
            for (ScopeRegistration registration : this.scopeRegistrations.keySet()) {
                scopes.add(registration.scopeTag);
                scopes.addAll(registration.explicitParentScopes);
            }
            return Collections.unmodifiableSet(scopes);
        }

        public Set<Map.Entry<String, ScopeInternals>> entrySet() {
            LinkedHashSet<AbstractMap.SimpleEntry<String, ScopeInternals>> set = new LinkedHashSet<AbstractMap.SimpleEntry<String, ScopeInternals>>();
            for (Map.Entry<ScopeRegistration, ScopeInternals> entry : this.scopeRegistrations.entrySet()) {
                AbstractMap.SimpleEntry<String, ScopeInternals> mappedEntry = new AbstractMap.SimpleEntry<String, ScopeInternals>(entry.getKey().scopeTag, entry.getValue());
                set.add(mappedEntry);
            }
            return Collections.unmodifiableSet(set);
        }

        public void putKey(Object key, String scopeTag, ScopeInternals scopeInternals, boolean isExplicitParent, boolean isGlobalScope, boolean isDummyScope) {
            List<String> explicitParentScopes = key instanceof ScopeKey.Child ? ((ScopeKey.Child)key).getParentScopes() : Collections.emptyList();
            ScopeRegistration scopeRegistration = new ScopeRegistration(key, scopeTag, explicitParentScopes, isExplicitParent, isGlobalScope, isDummyScope);
            this.put(scopeRegistration, scopeInternals);
        }

        @Nullable
        public ScopeInternals get(String scopeTag) {
            for (ScopeRegistration registration : this.scopeRegistrations.keySet()) {
                if (!registration.scopeTag.equals(scopeTag)) continue;
                return this.scopeRegistrations.get(registration);
            }
            return null;
        }

        public void put(ScopeRegistration scopeRegistration, ScopeInternals scopeInternals) {
            this.scopeRegistrations.put(scopeRegistration, scopeInternals);
        }

        @Nullable
        public ScopeInternals remove(String scopeTag) {
            Iterator<Map.Entry<ScopeRegistration, ScopeInternals>> iterator = this.scopeRegistrations.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ScopeRegistration, ScopeInternals> entry = iterator.next();
                String currentScopeTag = entry.getKey().scopeTag;
                if (!currentScopeTag.equals(scopeTag)) continue;
                ScopeInternals scopeInternals = entry.getValue();
                iterator.remove();
                return scopeInternals;
            }
            return null;
        }

        public List<String> getScopeTagsInTraversalOrder() {
            LinkedHashSet<String> scopeTags = new LinkedHashSet<String>();
            ArrayList<ScopeRegistration> registrations = new ArrayList<ScopeRegistration>(this.scopeRegistrations.keySet());
            for (int i = registrations.size() - 1; i >= 0; --i) {
                ScopeRegistration registration = (ScopeRegistration)registrations.get(i);
                if (!registration.isDummyScope) {
                    scopeTags.add(registration.scopeTag);
                }
                for (int j = registration.explicitParentScopes.size() - 1; j >= 0; --j) {
                    scopeTags.add((String)registration.explicitParentScopes.get(j));
                }
            }
            return Collections.unmodifiableList(new ArrayList(scopeTags));
        }

        public LinkedHashSet<String> findScopesForKey(@Nonnull Object targetKey, boolean explicitOnly) {
            LinkedHashSet<String> scopeTags = new LinkedHashSet<String>();
            int indexInRegistrations = -1;
            ArrayList<ScopeRegistration> registrations = new ArrayList<ScopeRegistration>(this.scopeRegistrations.keySet());
            for (int i = registrations.size() - 1; i >= 0; --i) {
                ScopeRegistration registration = (ScopeRegistration)registrations.get(i);
                if (registration.key == null || !registration.key.equals(targetKey)) continue;
                indexInRegistrations = i;
                break;
            }
            if (indexInRegistrations >= 0) {
                int initialIndex = explicitOnly ? indexInRegistrations : 0;
                for (int i = indexInRegistrations; i >= initialIndex; --i) {
                    ScopeRegistration currentRegistration = (ScopeRegistration)registrations.get(i);
                    if (currentRegistration.isGlobalScope) continue;
                    if (!currentRegistration.isDummyScope) {
                        scopeTags.add(currentRegistration.scopeTag);
                    }
                    ArrayList explicitParents = new ArrayList(currentRegistration.explicitParentScopes);
                    Collections.reverse(explicitParents);
                    scopeTags.addAll(explicitParents);
                }
            }
            return scopeTags;
        }

        public LinkedHashSet<String> findScopesForScopeTag(@Nonnull String scopeTag, boolean explicitOnly) {
            LinkedHashSet<String> scopeTags = new LinkedHashSet<String>();
            int indexInRegistrations = -1;
            ArrayList<ScopeRegistration> registrations = new ArrayList<ScopeRegistration>(this.scopeRegistrations.keySet());
            for (int i = registrations.size() - 1; i >= 0; --i) {
                ScopeRegistration registration = (ScopeRegistration)registrations.get(i);
                if (!scopeTag.equals(registration.scopeTag)) continue;
                indexInRegistrations = i;
                break;
            }
            if (indexInRegistrations >= 0) {
                int initialIndex = explicitOnly ? indexInRegistrations : 0;
                for (int x = indexInRegistrations; x >= initialIndex; --x) {
                    ScopeRegistration registration = (ScopeRegistration)registrations.get(x);
                    int indexOfParentScope = registration.explicitParentScopes.indexOf(scopeTag);
                    if (indexOfParentScope != -1) {
                        for (int i = indexOfParentScope; i >= 0; --i) {
                            scopeTags.add((String)registration.explicitParentScopes.get(i));
                        }
                        continue;
                    }
                    if (!registration.isDummyScope) {
                        scopeTags.add(registration.scopeTag);
                    }
                    ArrayList explicitParents = new ArrayList(registration.explicitParentScopes);
                    Collections.reverse(explicitParents);
                    scopeTags.addAll(explicitParents);
                }
            }
            return scopeTags;
        }

        public ScopeRegistration findScopeRegistrationForScopeTag(@Nonnull String scopeTag) {
            for (ScopeRegistration scopeRegistration : this.scopeRegistrations.keySet()) {
                if (!scopeTag.equals(scopeRegistration.scopeTag)) continue;
                return scopeRegistration;
            }
            return null;
        }

        void reorderToEnd(@Nonnull String scopeTag) {
            ScopeRegistration scopeRegistration = this.findScopeRegistrationForScopeTag(scopeTag);
            if (scopeRegistration != null) {
                ScopeInternals scopeInternals = this.scopeRegistrations.remove(scopeRegistration);
                this.scopeRegistrations.put(scopeRegistration, scopeInternals);
            }
        }

        public static class ScopeInternals {
            public final ScopeNode scopeNode;
            public final AheadOfTimeBackCallbackRegistry aheadOfTimeBackCallbackRegistry;

            public ScopeInternals(ScopeNode scopeNode, AheadOfTimeBackCallbackRegistry aheadOfTimeBackCallbackRegistry) {
                this.scopeNode = scopeNode;
                this.aheadOfTimeBackCallbackRegistry = aheadOfTimeBackCallbackRegistry;
            }
        }
    }
}

