/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.content.Context;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import com.zhuinden.simplestack.Bundleable;
import com.zhuinden.simplestack.DefaultKeyFilter;
import com.zhuinden.simplestack.DefaultKeyParceler;
import com.zhuinden.simplestack.DefaultStateClearStrategy;
import com.zhuinden.simplestack.GlobalServices;
import com.zhuinden.simplestack.History;
import com.zhuinden.simplestack.KeyContextWrapper;
import com.zhuinden.simplestack.KeyFilter;
import com.zhuinden.simplestack.KeyParceler;
import com.zhuinden.simplestack.NavigationCore;
import com.zhuinden.simplestack.ParcelledState;
import com.zhuinden.simplestack.SavedState;
import com.zhuinden.simplestack.ScopeKey;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopeManager;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.statebundle.StateBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Backstack
implements Bundleable {
    private final long threadId = Thread.currentThread().getId();
    private static final String HISTORY_TAG = "HISTORY";
    private static final String STATES_TAG = "STATES";
    private static final String SCOPES_TAG = "SCOPES";
    private static final String RETAINED_OBJECT_STATES_TAG = "RETAINED_OBJECT_STATES_TAG";
    private Object previousTopKeyWithAssociatedScope = null;
    private final StateChanger managedStateChanger = new StateChanger(){

        @Override
        public void handleStateChange(@Nonnull StateChange stateChange, @Nonnull StateChanger.Callback completionCallback) {
            Backstack.this.scopeManager.buildScopes(stateChange.getNewKeys());
            Backstack.this.stateChanger.handleStateChange(stateChange, completionCallback);
        }
    };
    private final CompletionListener managedStateChangerCompletionListener = new CompletionListener(){

        @Override
        public void stateChangeCompleted(@Nonnull StateChange stateChange) {
            if (!Backstack.this.isStateChangePending()) {
                ScopeKey.Child child;
                ScopeKey scopeKey;
                if (Backstack.this.isStateChangerAttached) {
                    Backstack.this.core.removeStateChanger();
                }
                Backstack.this.stateClearStrategy.clearStatesNotIn(Backstack.this.keyStateMap, stateChange);
                History<Object> newState = stateChange.getNewKeys();
                Object newTopKeyWithAssociatedScope = null;
                int size = newState.size();
                for (int i = 0; i < size; ++i) {
                    Object key = newState.fromTop(i);
                    if (!(key instanceof ScopeKey) && !(key instanceof ScopeKey.Child)) continue;
                    newTopKeyWithAssociatedScope = key;
                    break;
                }
                LinkedHashSet<String> scopesToDeactivate = new LinkedHashSet<String>();
                LinkedHashSet<String> scopesToActivate = new LinkedHashSet<String>();
                if (Backstack.this.previousTopKeyWithAssociatedScope != null) {
                    if (Backstack.this.previousTopKeyWithAssociatedScope instanceof ScopeKey) {
                        scopeKey = (ScopeKey)Backstack.this.previousTopKeyWithAssociatedScope;
                        scopesToDeactivate.add(scopeKey.getScopeTag());
                    }
                    if (Backstack.this.previousTopKeyWithAssociatedScope instanceof ScopeKey.Child) {
                        child = (ScopeKey.Child)Backstack.this.previousTopKeyWithAssociatedScope;
                        ScopeManager.checkParentScopes(child);
                        List<String> parentScopes = child.getParentScopes();
                        for (int i = parentScopes.size() - 1; i >= 0; --i) {
                            scopesToDeactivate.add(parentScopes.get(i));
                        }
                    }
                }
                if (newTopKeyWithAssociatedScope != null) {
                    if (newTopKeyWithAssociatedScope instanceof ScopeKey.Child) {
                        child = newTopKeyWithAssociatedScope;
                        ScopeManager.checkParentScopes(child);
                        scopesToActivate.addAll(child.getParentScopes());
                    }
                    if (newTopKeyWithAssociatedScope instanceof ScopeKey) {
                        scopeKey = newTopKeyWithAssociatedScope;
                        scopesToActivate.add(scopeKey.getScopeTag());
                    }
                }
                Backstack.this.previousTopKeyWithAssociatedScope = newTopKeyWithAssociatedScope;
                Iterator scopeToActivate = scopesToActivate.iterator();
                while (scopeToActivate.hasNext()) {
                    String activeScope = (String)scopeToActivate.next();
                    if (!scopesToDeactivate.contains(activeScope)) continue;
                    scopesToDeactivate.remove(activeScope);
                    scopeToActivate.remove();
                }
                if (!scopesToActivate.isEmpty() || !scopesToDeactivate.isEmpty()) {
                    Backstack.this.scopeManager.dispatchActivation(scopesToDeactivate, scopesToActivate);
                }
                Backstack.this.scopeManager.cleanupScopesBy(newState);
                if (Backstack.this.isStateChangerAttached) {
                    Backstack.this.core.setStateChanger(Backstack.this.managedStateChanger, 1);
                }
            }
        }
    };
    private KeyFilter keyFilter = new DefaultKeyFilter();
    private KeyParceler keyParceler = new DefaultKeyParceler();
    private StateClearStrategy stateClearStrategy = new DefaultStateClearStrategy();
    NavigationCore core;
    Map<Object, SavedState> keyStateMap = new HashMap<Object, SavedState>();
    ScopeManager scopeManager = new ScopeManager();
    StateChanger stateChanger;
    private boolean isStateChangerAttached;
    private boolean didRunInitialStateChange;
    private final Map<String, Object> retainedObjects;
    private final StateBundle pendingRestoredRetainedObjectStates;

    public Backstack() {
        this.scopeManager.setBackstack(this);
        this.isStateChangerAttached = false;
        this.didRunInitialStateChange = false;
        this.retainedObjects = new LinkedHashMap<String, Object>();
        this.pendingRestoredRetainedObjectStates = new StateBundle();
    }

    @Nonnull
    public static <K> K getKey(@Nonnull Context context) {
        return (K)KeyContextWrapper.getKey(context);
    }

    static String getHistoryTag() {
        return HISTORY_TAG;
    }

    static String getStatesTag() {
        return STATES_TAG;
    }

    static String getScopesTag() {
        return SCOPES_TAG;
    }

    static String getRetainedObjectStatesTag() {
        return RETAINED_OBJECT_STATES_TAG;
    }

    public void setKeyFilter(@Nonnull KeyFilter keyFilter) {
        if (this.core != null) {
            throw new IllegalStateException("Custom key filter should be set before calling `setup()`");
        }
        if (keyFilter == null) {
            throw new IllegalArgumentException("The key filter cannot be null!");
        }
        this.keyFilter = keyFilter;
    }

    public void setKeyParceler(@Nonnull KeyParceler keyParceler) {
        if (this.core != null) {
            throw new IllegalStateException("Custom key parceler should be set before calling `setup()`");
        }
        if (keyParceler == null) {
            throw new IllegalArgumentException("The key parceler cannot be null!");
        }
        this.keyParceler = keyParceler;
    }

    public void setStateClearStrategy(@Nonnull StateClearStrategy stateClearStrategy) {
        if (this.core != null) {
            throw new IllegalStateException("Custom state clear strategy should be set before calling `setup()`");
        }
        if (stateClearStrategy == null) {
            throw new IllegalArgumentException("The state clear strategy cannot be null!");
        }
        this.stateClearStrategy = stateClearStrategy;
    }

    public final boolean canSetScopeProviders() {
        return !this.didRunInitialStateChange;
    }

    public void setScopedServices(@Nonnull ScopedServices scopedServices) {
        if (!this.canSetScopeProviders()) {
            throw new IllegalStateException("Scope provider should be set before the initial state change!");
        }
        if (scopedServices == null) {
            throw new IllegalArgumentException("The scope provider cannot be null!");
        }
        this.scopeManager.setScopedServices(scopedServices);
    }

    public void setGlobalServices(@Nonnull GlobalServices globalServices) {
        if (!this.canSetScopeProviders()) {
            throw new IllegalStateException("Scope provider should be set before the initial state change!");
        }
        if (globalServices == null) {
            throw new IllegalArgumentException("The global services cannot be null!");
        }
        this.scopeManager.setGlobalServices(globalServices);
    }

    public void setGlobalServices(@Nonnull GlobalServices.Factory globalServiceFactory) {
        if (!this.canSetScopeProviders()) {
            throw new IllegalStateException("Scope provider should be set before the initial state change!");
        }
        if (globalServiceFactory == null) {
            throw new IllegalArgumentException("The global service factory cannot be null!");
        }
        this.scopeManager.setGlobalServices(globalServiceFactory);
    }

    public void setup(@Nonnull List<?> initialKeys) {
        this.core = new NavigationCore(initialKeys);
        this.core.setBackstack(this);
        this.core.addCompletionListener(this.managedStateChangerCompletionListener);
    }

    public boolean isInitialized() {
        return this.core != null;
    }

    private void initializeBackstack(StateChanger stateChanger) {
        if (stateChanger != null) {
            if (!this.didRunInitialStateChange) {
                this.didRunInitialStateChange = true;
            }
            this.isStateChangerAttached = true;
            this.core.setStateChanger(this.managedStateChanger);
        }
    }

    public void setStateChanger(@Nullable StateChanger stateChanger) {
        this.checkBackstack("You must call `setup()` before calling `setStateChanger()`.");
        if (this.core.hasStateChanger()) {
            this.core.removeStateChanger();
        }
        this.stateChanger = stateChanger;
        this.initializeBackstack(stateChanger);
    }

    public void detachStateChanger() {
        this.checkBackstack("You must call `setup()` before calling `detachStateChanger()`.");
        if (this.core.hasStateChanger()) {
            this.core.removeStateChanger();
            this.isStateChangerAttached = false;
        }
    }

    public void reattachStateChanger() {
        this.checkBackstack("You must call `setup()` before calling `reattachStateChanger()`.");
        if (!this.core.hasStateChanger()) {
            this.isStateChangerAttached = true;
            this.core.setStateChanger(this.managedStateChanger, 1);
        }
    }

    public void finalizeScopes() {
        if (this.scopeManager.isFinalized()) {
            return;
        }
        if (this.previousTopKeyWithAssociatedScope != null) {
            LinkedHashSet<String> scopesToDeactivate = new LinkedHashSet<String>();
            if (this.previousTopKeyWithAssociatedScope instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)this.previousTopKeyWithAssociatedScope;
                ScopeManager.checkParentScopes(child);
                ArrayList<String> parentScopes = new ArrayList<String>(child.getParentScopes());
                scopesToDeactivate.addAll(parentScopes);
            }
            if (this.previousTopKeyWithAssociatedScope instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)this.previousTopKeyWithAssociatedScope;
                scopesToDeactivate.add(scopeKey.getScopeTag());
            }
            ArrayList scopesToDeactivateList = new ArrayList(scopesToDeactivate);
            Collections.reverse(scopesToDeactivateList);
            this.scopeManager.dispatchActivation(new LinkedHashSet<String>(scopesToDeactivateList), Collections.emptySet());
        }
        this.scopeManager.deactivateGlobalScope();
        History history = this.getHistory();
        LinkedHashSet<String> scopeSet = new LinkedHashSet<String>();
        int size = history.size();
        for (int i = 0; i < size; ++i) {
            Object key = history.fromTop(i);
            if (key instanceof ScopeKey) {
                scopeSet.add(((ScopeKey)key).getScopeTag());
            }
            if (!(key instanceof ScopeKey.Child)) continue;
            ScopeKey.Child child = (ScopeKey.Child)key;
            ArrayList<String> parentScopes = new ArrayList<String>(child.getParentScopes());
            Collections.reverse(parentScopes);
            for (String parent : parentScopes) {
                if (scopeSet.contains(parent)) {
                    scopeSet.remove(parent);
                }
                scopeSet.add(parent);
            }
        }
        ArrayList scopes = new ArrayList(scopeSet);
        for (String scope : scopes) {
            this.scopeManager.destroyScope(scope);
        }
        this.scopeManager.finalizeScopes();
        this.previousTopKeyWithAssociatedScope = null;
    }

    public boolean hasService(@Nonnull ScopeKey scopeKey, @Nonnull String serviceTag) {
        return this.hasService(scopeKey.getScopeTag(), serviceTag);
    }

    @Nonnull
    public <T> T getService(@Nonnull ScopeKey scopeKey, @Nonnull String serviceTag) {
        return this.getService(scopeKey.getScopeTag(), serviceTag);
    }

    public boolean hasService(@Nonnull String scopeTag, @Nonnull String serviceTag) {
        return this.scopeManager.hasService(scopeTag, serviceTag);
    }

    @Nonnull
    public <T> T getService(@Nonnull String scopeTag, @Nonnull String serviceTag) {
        return this.scopeManager.getService(scopeTag, serviceTag);
    }

    public boolean hasScope(@Nonnull String scopeTag) {
        return this.scopeManager.hasScope(scopeTag);
    }

    public boolean canFindService(@Nonnull String serviceTag) {
        return this.scopeManager.canFindService(serviceTag);
    }

    public boolean canFindFromScope(@Nonnull String scopeTag, @Nonnull String serviceTag) {
        return this.scopeManager.canFindFromScope(scopeTag, serviceTag, ScopeLookupMode.ALL);
    }

    public boolean canFindFromScope(@Nonnull String scopeTag, @Nonnull String serviceTag, @Nonnull ScopeLookupMode lookupMode) {
        return this.scopeManager.canFindFromScope(scopeTag, serviceTag, lookupMode);
    }

    @Nonnull
    public <T> T lookupService(@Nonnull String serviceTag) {
        return this.scopeManager.lookupService(serviceTag);
    }

    @Nonnull
    public List<String> findScopesForKey(@Nonnull Object key, @Nonnull ScopeLookupMode lookupMode) {
        Set<String> scopes = this.scopeManager.findScopesForKey(key, lookupMode);
        return Collections.unmodifiableList(new ArrayList<String>(scopes));
    }

    @Nonnull
    public <T> T lookupFromScope(String scopeTag, String serviceTag) {
        return this.scopeManager.lookupFromScope(scopeTag, serviceTag, ScopeLookupMode.ALL);
    }

    @Nonnull
    public <T> T lookupFromScope(String scopeTag, String serviceTag, ScopeLookupMode lookupMode) {
        return this.scopeManager.lookupFromScope(scopeTag, serviceTag, lookupMode);
    }

    @Nonnull
    public SavedState getSavedState(@Nonnull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        if (!this.keyStateMap.containsKey(key)) {
            this.keyStateMap.put(key, SavedState.builder().setKey(key).build());
        }
        return this.keyStateMap.get(key);
    }

    public boolean hasRetainedObject(@Nonnull String objectTag) {
        this.assertCorrectThread();
        return this.retainedObjects.containsKey(objectTag);
    }

    @Nonnull
    public <T> T getRetainedObject(@Nonnull String objectTag) {
        this.assertCorrectThread();
        if (!this.retainedObjects.containsKey(objectTag)) {
            throw new IllegalArgumentException("Retained object with tag [" + objectTag + "] was not found.!");
        }
        return (T)this.retainedObjects.get(objectTag);
    }

    public void addRetainedObject(@Nonnull String objectTag, @Nonnull Object retainedObject) {
        if (objectTag == null) {
            throw new NullPointerException("objectTag cannot be null!");
        }
        if (retainedObject == null) {
            throw new NullPointerException("retainedObject cannot be null!");
        }
        this.assertCorrectThread();
        if (this.retainedObjects.containsKey(objectTag)) {
            throw new IllegalArgumentException("A retained object is already added with the object tag [" + objectTag + "]");
        }
        if (this.pendingRestoredRetainedObjectStates.containsKey(objectTag)) {
            if (!(retainedObject instanceof Bundleable)) {
                throw new IllegalStateException("State restoration mismatch: expected [" + objectTag + "] to be restored, but was not actually Bundleable anymore.");
            }
            ((Bundleable)retainedObject).fromBundle(this.pendingRestoredRetainedObjectStates.getBundle(objectTag));
            this.pendingRestoredRetainedObjectStates.remove(objectTag);
        }
        this.retainedObjects.put(objectTag, retainedObject);
    }

    @Nullable
    public <T> T removeRetainedObject(@Nonnull String objectTag) {
        if (objectTag == null) {
            throw new NullPointerException("objectTag cannot be null!");
        }
        this.assertCorrectThread();
        this.pendingRestoredRetainedObjectStates.remove(objectTag);
        return (T)this.retainedObjects.remove(objectTag);
    }

    public void persistViewToState(@Nullable View view) {
        this.assertCorrectThread();
        if (view != null) {
            Object key = KeyContextWrapper.getKey(view.getContext());
            if (key == null) {
                throw new IllegalArgumentException("The view [" + view + "] contained no key in its context hierarchy. The view or its parent hierarchy should be inflated by a layout inflater from `stateChange.createContext(baseContext, key)`, or a KeyContextWrapper.");
            }
            SparseArray viewHierarchyState = new SparseArray();
            view.saveHierarchyState(viewHierarchyState);
            StateBundle bundle = null;
            if (view instanceof Bundleable) {
                bundle = ((Bundleable)view).toBundle();
            }
            SavedState previousSavedState = this.getSavedState(key);
            previousSavedState.setViewHierarchyState((SparseArray<Parcelable>)viewHierarchyState);
            previousSavedState.setViewBundle(bundle);
        }
    }

    public void restoreViewFromState(@Nonnull View view) {
        this.assertCorrectThread();
        if (view == null) {
            throw new IllegalArgumentException("You cannot restore state into null view!");
        }
        Object newKey = KeyContextWrapper.getKey(view.getContext());
        SavedState savedState = this.getSavedState(newKey);
        view.restoreHierarchyState(savedState.getViewHierarchyState());
        if (view instanceof Bundleable) {
            ((Bundleable)view).fromBundle(savedState.getViewBundle());
        }
    }

    public void addStateChangeCompletionListener(@Nonnull CompletionListener stateChangeCompletionListener) {
        this.checkBackstack("A backstack must be set up before a state change completion listener is added to it.");
        if (stateChangeCompletionListener == null) {
            throw new IllegalArgumentException("StateChangeCompletionListener cannot be null!");
        }
        this.core.addCompletionListener(stateChangeCompletionListener);
    }

    public void removeStateChangeCompletionListener(@Nonnull CompletionListener stateChangeCompletionListener) {
        this.checkBackstack("A backstack must be set up before a state change completion listener is removed from it.");
        if (stateChangeCompletionListener == null) {
            throw new IllegalArgumentException("StateChangeCompletionListener cannot be null!");
        }
        this.core.removeCompletionListener(stateChangeCompletionListener);
    }

    @Deprecated
    public void removeAllStateChangeCompletionListeners() {
        this.checkBackstack("A backstack must be set up before state change completion listeners are removed from it.");
        this.core.removeCompletionListeners();
        this.core.addCompletionListener(this.managedStateChangerCompletionListener);
    }

    @Override
    public void fromBundle(@Nullable StateBundle stateBundle) {
        this.checkBackstack("A backstack must be set up before it is restored!");
        this.assertCorrectThread();
        if (stateBundle != null) {
            ArrayList savedStates;
            List<Object> keys = new ArrayList();
            ArrayList parcelledKeys = stateBundle.getParcelableArrayList(Backstack.getHistoryTag());
            if (parcelledKeys != null) {
                for (Object parcelledKey : parcelledKeys) {
                    keys.add(this.keyParceler.fromParcelable((Parcelable)parcelledKey));
                }
            }
            if ((keys = this.keyFilter.filterHistory(new ArrayList<Object>(keys))) == null) {
                keys = Collections.emptyList();
            }
            if (!keys.isEmpty()) {
                this.core.setInitialParameters(keys);
            }
            if ((savedStates = stateBundle.getParcelableArrayList(Backstack.getStatesTag())) != null) {
                for (ParcelledState parcelledState : savedStates) {
                    Object key = this.keyParceler.fromParcelable(parcelledState.parcelableKey);
                    if (!keys.contains(key)) continue;
                    SavedState savedState = SavedState.builder().setKey(key).setViewHierarchyState(parcelledState.viewHierarchyState).setBundle(parcelledState.bundle).setViewBundle(parcelledState.viewBundle).build();
                    this.keyStateMap.put(savedState.getKey(), savedState);
                }
            }
            this.scopeManager.setRestoredStates(stateBundle.getBundle(SCOPES_TAG));
            StateBundle retainedStates = stateBundle.getBundle(RETAINED_OBJECT_STATES_TAG);
            if (retainedStates != null) {
                this.pendingRestoredRetainedObjectStates.putAll(retainedStates);
                for (Map.Entry<String, Object> retainedEntry : this.retainedObjects.entrySet()) {
                    String objectTag = retainedEntry.getKey();
                    Object retainedObject = retainedEntry.getValue();
                    if (!this.pendingRestoredRetainedObjectStates.containsKey(objectTag)) continue;
                    if (!(retainedObject instanceof Bundleable)) {
                        throw new IllegalStateException("State restoration mismatch: expected [" + objectTag + "] to be restored, but was not actually Bundleable anymore.");
                    }
                    ((Bundleable)retainedObject).fromBundle(this.pendingRestoredRetainedObjectStates.getBundle(objectTag));
                    this.pendingRestoredRetainedObjectStates.remove(objectTag);
                }
            }
        }
    }

    private void assertCorrectThread() {
        if (Thread.currentThread().getId() != this.threadId) {
            throw new IllegalStateException("The backstack is not thread-safe, and must be manipulated only from the thread where it was originally created.");
        }
    }

    private void checkBackstack(String message) {
        if (this.core == null) {
            throw new IllegalStateException(message);
        }
    }

    @Override
    @Nonnull
    public StateBundle toBundle() {
        this.assertCorrectThread();
        StateBundle stateBundle = new StateBundle();
        ArrayList<Parcelable> history = new ArrayList<Parcelable>();
        for (Object key : this.getHistory()) {
            history.add(this.keyParceler.toParcelable(key));
        }
        stateBundle.putParcelableArrayList(Backstack.getHistoryTag(), history);
        ArrayList<ParcelledState> parcelledStates = new ArrayList<ParcelledState>();
        for (SavedState savedState : this.keyStateMap.values()) {
            ParcelledState parcelledState = new ParcelledState();
            parcelledState.parcelableKey = this.keyParceler.toParcelable(savedState.getKey());
            parcelledState.viewHierarchyState = savedState.getViewHierarchyState();
            parcelledState.bundle = savedState.getBundle();
            parcelledState.viewBundle = savedState.getViewBundle();
            parcelledStates.add(parcelledState);
        }
        stateBundle.putParcelableArrayList(Backstack.getStatesTag(), parcelledStates);
        stateBundle.putParcelable(Backstack.getScopesTag(), (Parcelable)this.scopeManager.saveStates());
        StateBundle retainedObjectStates = new StateBundle();
        for (Map.Entry<String, Object> entry : this.retainedObjects.entrySet()) {
            String objectTag = entry.getKey();
            Object retainedObject = entry.getValue();
            if (!(retainedObject instanceof Bundleable)) continue;
            StateBundle retainedBundle = ((Bundleable)retainedObject).toBundle();
            retainedObjectStates.putParcelable(objectTag, (Parcelable)retainedBundle);
        }
        stateBundle.putParcelable(Backstack.getRetainedObjectStatesTag(), (Parcelable)retainedObjectStates);
        return stateBundle;
    }

    public boolean hasStateChanger() {
        this.checkBackstack("A backstack must be set up before checking state changer.");
        return this.core.hasStateChanger();
    }

    public void removeStateChanger() {
        this.checkBackstack("A backstack must be set up before removing state changer.");
        this.core.removeStateChanger();
    }

    public void goTo(@Nonnull Object newKey) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.goTo(newKey);
    }

    public void replaceTop(@Nonnull Object newTop, int direction) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.replaceTop(newTop, direction);
    }

    public void goUp(@Nonnull Object newKey) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.goUp(newKey);
    }

    public void goUp(@Nonnull Object newKey, boolean fallbackToBack) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.goUp(newKey, fallbackToBack);
    }

    public void moveToTop(@Nonnull Object newKey) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.moveToTop(newKey);
    }

    public void moveToTop(@Nonnull Object newKey, boolean asReplace) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.moveToTop(newKey, asReplace);
    }

    public void jumpToRoot() {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.jumpToRoot();
    }

    public void jumpToRoot(int direction) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.jumpToRoot(direction);
    }

    public void goUpChain(@Nonnull List<?> parentChain) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.goUpChain(parentChain);
    }

    public void exitScope(@Nonnull String scopeTag) {
        this.exitScope(scopeTag, -1);
    }

    public void exitScope(@Nonnull String scopeTag, int direction) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.assertCorrectThread();
        if (scopeTag == null) {
            throw new NullPointerException("scopeTag must not be null!");
        }
        History keys = this.getHistory();
        if (keys.isEmpty()) {
            throw new IllegalStateException("Cannot exit scope [" + scopeTag + "] within an empty backstack.");
        }
        if (!this.scopeManager.hasScope(scopeTag)) {
            throw new IllegalArgumentException("Cannot exit scope [" + scopeTag + "] as it does not exist.");
        }
        Object candidateKey = keys.get(0);
        for (Object key : keys) {
            if (this.scopeManager.canFindScope(key, scopeTag, ScopeLookupMode.EXPLICIT)) break;
            candidateKey = key;
        }
        this.core.setHistory(History.builderFrom(keys).removeUntil(candidateKey).build(), direction);
    }

    public void exitScopeTo(@Nonnull String scopeTag, @Nonnull Object targetKey, int direction) {
        this.checkBackstack("A backstack must be set up before navigation.");
        if (scopeTag == null) {
            throw new NullPointerException("scopeTag must not be null!");
        }
        if (targetKey == null) {
            throw new NullPointerException("newKey must not be null!");
        }
        History keys = this.getHistory();
        if (keys.isEmpty()) {
            throw new IllegalStateException("Cannot exit scope [" + scopeTag + "] within an empty backstack.");
        }
        if (!this.scopeManager.hasScope(scopeTag)) {
            throw new IllegalArgumentException("Cannot exit scope [" + scopeTag + "] as it does not exist.");
        }
        Object candidateKey = keys.get(0);
        for (Object key : keys) {
            if (this.scopeManager.canFindScope(key, scopeTag, ScopeLookupMode.EXPLICIT)) break;
            candidateKey = key;
        }
        History.Builder builder = History.builderFrom(keys).removeUntil(candidateKey);
        if (this.scopeManager.canFindScope(builder.get(0), scopeTag, ScopeLookupMode.EXPLICIT)) {
            builder.removeAt(0);
        }
        if (!builder.contains(targetKey)) {
            builder.add(targetKey);
        } else {
            builder.removeUntil(targetKey);
        }
        this.core.setHistory(builder.build(), direction);
    }

    public void goUpChain(@Nonnull List<?> parentChain, boolean fallbackToBack) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.goUpChain(parentChain, fallbackToBack);
    }

    public boolean goBack() {
        this.checkBackstack("A backstack must be set up before navigation.");
        if (this.isStateChangePending()) {
            return true;
        }
        Object topKey = this.getHistory().top();
        if (topKey == null) {
            return false;
        }
        boolean handled = this.scopeManager.dispatchBack(topKey);
        if (handled) {
            return true;
        }
        return this.core.goBack();
    }

    public void forceClear() {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.finalizeScopes();
        this.core.forceClear();
    }

    public void setHistory(@Nonnull List<?> newHistory, int direction) {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.setHistory(newHistory, direction);
    }

    @Nonnull
    public <K> K root() {
        this.checkBackstack("A backstack must be set up before getting keys from it.");
        return this.core.root();
    }

    @Nonnull
    public <K> K top() {
        this.checkBackstack("A backstack must be set up before getting keys from it.");
        return this.core.top();
    }

    @Nonnull
    public <K> K fromTop(int offset) {
        this.checkBackstack("A backstack must be set up before getting keys from it.");
        return this.core.fromTop(offset);
    }

    @Nonnull
    public <K> History<K> getHistory() {
        this.checkBackstack("A backstack must be set up before getting keys from it.");
        return this.core.getHistory();
    }

    @Nonnull
    public <K> History<K> getInitialKeys() {
        this.checkBackstack("A backstack must be set up before getting keys from it.");
        return this.core.getInitialKeys();
    }

    public boolean isStateChangePending() {
        this.checkBackstack("A backstack must be set up before navigation.");
        return this.core.isStateChangePending();
    }

    @Deprecated
    public void addCompletionListener(@Nonnull CompletionListener completionListener) {
        this.addStateChangeCompletionListener(completionListener);
    }

    @Deprecated
    public void removeCompletionListener(@Nonnull CompletionListener completionListener) {
        this.removeStateChangeCompletionListener(completionListener);
    }

    @Deprecated
    public void removeCompletionListeners() {
        this.removeAllStateChangeCompletionListeners();
    }

    public void executePendingStateChange() {
        this.checkBackstack("A backstack must be set up before navigation.");
        this.core.executePendingStateChange();
    }

    public static interface CompletionListener {
        public void stateChangeCompleted(@Nonnull StateChange var1);
    }

    public static interface StateClearStrategy {
        public void clearStatesNotIn(@Nonnull Map<Object, SavedState> var1, @Nonnull StateChange var2);
    }
}

