/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack.navigator;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.view.View;
import android.view.ViewGroup;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.DefaultKeyFilter;
import com.zhuinden.simplestack.DefaultKeyParceler;
import com.zhuinden.simplestack.DefaultStateClearStrategy;
import com.zhuinden.simplestack.GlobalServices;
import com.zhuinden.simplestack.KeyFilter;
import com.zhuinden.simplestack.KeyParceler;
import com.zhuinden.simplestack.SavedState;
import com.zhuinden.simplestack.ScopeKey;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.simplestack.navigator.BackstackHost;
import com.zhuinden.simplestack.navigator.DefaultStateChanger;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@TargetApi(value=11)
public class Navigator {
    private Navigator() {
    }

    @Nonnull
    public static Installer configure() {
        return new Installer();
    }

    @Nonnull
    public static void install(@Nonnull Activity activity, @Nonnull ViewGroup container, @Nonnull List<?> initialKeys) {
        Navigator.configure().install(activity, container, initialKeys);
    }

    private static Backstack install(Installer installer, @Nonnull Activity activity, @Nonnull ViewGroup container, @Nonnull List<?> initialKeys) {
        if (activity == null) {
            throw new IllegalArgumentException("Activity cannot be null!");
        }
        if (container == null) {
            throw new IllegalArgumentException("Container cannot be null!");
        }
        if (initialKeys == null || initialKeys.isEmpty()) {
            throw new IllegalArgumentException("Initial keys cannot be null!");
        }
        BackstackHost backstackHost = Navigator.findBackstackHost(activity);
        if (backstackHost == null) {
            backstackHost = new BackstackHost();
            activity.getFragmentManager().beginTransaction().add((Fragment)backstackHost, "NAVIGATOR_BACKSTACK_HOST").commit();
            activity.getFragmentManager().executePendingTransactions();
        }
        backstackHost.stateChanger = installer.stateChanger;
        backstackHost.keyFilter = installer.keyFilter;
        backstackHost.keyParceler = installer.keyParceler;
        backstackHost.stateClearStrategy = installer.stateClearStrategy;
        backstackHost.scopedServices = installer.scopedServices;
        backstackHost.globalServices = installer.globalServices;
        backstackHost.globalServiceFactory = installer.globalServiceFactory;
        backstackHost.stateChangeCompletionListeners = installer.stateChangeCompletionListeners;
        backstackHost.shouldPersistContainerChild = installer.shouldPersistContainerChild;
        backstackHost.container = container;
        backstackHost.initialKeys = initialKeys;
        return backstackHost.initialize(installer.isInitializeDeferred);
    }

    public static void executeDeferredInitialization(@Nonnull Context context) {
        Object activity = Navigator.findActivity(context);
        BackstackHost backstackHost = Navigator.findBackstackHost(activity);
        backstackHost.initialize(false);
    }

    public static boolean onBackPressed(@Nonnull Context context) {
        return Navigator.getBackstack(context).goBack();
    }

    public static boolean hasScope(@Nonnull Context context, @Nonnull String scopeTag) {
        return Navigator.getBackstack(context).hasScope(scopeTag);
    }

    public static boolean hasService(@Nonnull Context context, @Nonnull ScopeKey scopeKey, @Nonnull String serviceTag) {
        return Navigator.getBackstack(context).hasService(scopeKey, serviceTag);
    }

    public static boolean hasService(@Nonnull Context context, @Nonnull String scopeTag, @Nonnull String serviceTag) {
        return Navigator.getBackstack(context).hasService(scopeTag, serviceTag);
    }

    @Nonnull
    public static <T> T getService(@Nonnull Context context, @Nonnull ScopeKey scopeKey, @Nonnull String serviceTag) {
        return Navigator.getBackstack(context).getService(scopeKey, serviceTag);
    }

    @Nonnull
    public static <T> T getService(@Nonnull Context context, @Nonnull String scopeTag, @Nonnull String serviceTag) {
        return Navigator.getBackstack(context).getService(scopeTag, serviceTag);
    }

    public static boolean canFindService(@Nonnull Context context, @Nonnull String serviceTag) {
        return Navigator.getBackstack(context).canFindService(serviceTag);
    }

    @Nonnull
    public static <T> T lookupService(@Nonnull Context context, @Nonnull String serviceTag) {
        return Navigator.getBackstack(context).lookupService(serviceTag);
    }

    @Nonnull
    public static List<String> findScopesForKey(@Nonnull Context context, @Nonnull Object key, @Nonnull ScopeLookupMode lookupMode) {
        return Navigator.getBackstack(context).findScopesForKey(key, lookupMode);
    }

    public static boolean canFindFromScope(@Nonnull Context context, @Nonnull String scopeTag, @Nonnull String serviceTag) {
        return Navigator.getBackstack(context).canFindFromScope(scopeTag, serviceTag);
    }

    public static boolean canFindFromScope(@Nonnull Context context, @Nonnull String scopeTag, @Nonnull String serviceTag, @Nonnull ScopeLookupMode lookupMode) {
        return Navigator.getBackstack(context).canFindFromScope(scopeTag, serviceTag, lookupMode);
    }

    @Nonnull
    public static <T> T lookupFromScope(@Nonnull Context context, @Nonnull String scopeTag, @Nonnull String serviceTag) {
        return Navigator.getBackstack(context).lookupFromScope(scopeTag, serviceTag);
    }

    @Nonnull
    public static <T> T lookupFromScope(@Nonnull Context context, @Nonnull String scopeTag, @Nonnull String serviceTag, @Nonnull ScopeLookupMode lookupMode) {
        return Navigator.getBackstack(context).lookupFromScope(scopeTag, serviceTag, lookupMode);
    }

    @Nonnull
    public static Backstack getBackstack(@Nonnull Context context) {
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        return backstackHost.getBackstack();
    }

    public static void persistViewToState(@Nullable View view) {
        if (view != null) {
            Context context = view.getContext();
            BackstackHost backstackHost = Navigator.getBackstackHost(context);
            backstackHost.getBackstack().persistViewToState(view);
        }
    }

    public static void restoreViewFromState(@Nonnull View view) {
        if (view == null) {
            throw new NullPointerException("You cannot restore state into null view!");
        }
        Context context = view.getContext();
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        backstackHost.getBackstack().restoreViewFromState(view);
    }

    @Nonnull
    public static SavedState getSavedState(@Nonnull Context context, @Nonnull Object key) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        return backstackHost.getBackstack().getSavedState(key);
    }

    public static boolean isNavigatorAvailable(@Nonnull Activity activity) {
        return Navigator.findBackstackHost(activity) != null;
    }

    private static BackstackHost findBackstackHost(Activity activity) {
        return (BackstackHost)activity.getFragmentManager().findFragmentByTag("NAVIGATOR_BACKSTACK_HOST");
    }

    @Nonnull
    public static <T extends Activity> T findActivity(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null!");
        }
        if (context instanceof Activity) {
            return (T)((Activity)context);
        }
        ContextWrapper contextWrapper = (ContextWrapper)context;
        Context baseContext = contextWrapper.getBaseContext();
        if (baseContext == null) {
            throw new IllegalStateException("Activity was not found as base context of view!");
        }
        return Navigator.findActivity(baseContext);
    }

    private static BackstackHost getBackstackHost(Context context) {
        Object activity = Navigator.findActivity(context);
        return Navigator.findBackstackHost(activity);
    }

    @TargetApi(value=11)
    public static class Installer {
        StateChanger stateChanger;
        KeyFilter keyFilter = new DefaultKeyFilter();
        KeyParceler keyParceler = new DefaultKeyParceler();
        Backstack.StateClearStrategy stateClearStrategy = new DefaultStateClearStrategy();
        ScopedServices scopedServices = null;
        GlobalServices globalServices = null;
        GlobalServices.Factory globalServiceFactory = null;
        boolean isInitializeDeferred = false;
        boolean shouldPersistContainerChild = false;
        List<Backstack.CompletionListener> stateChangeCompletionListeners = new LinkedList<Backstack.CompletionListener>();

        @Nonnull
        public Installer setStateChanger(@Nonnull StateChanger stateChanger) {
            if (stateChanger == null) {
                throw new IllegalArgumentException("If set, StateChanger cannot be null!");
            }
            this.stateChanger = stateChanger;
            return this;
        }

        @Nonnull
        public Installer setKeyFilter(@Nonnull KeyFilter keyFilter) {
            if (keyFilter == null) {
                throw new IllegalArgumentException("If set, KeyFilter cannot be null!");
            }
            this.keyFilter = keyFilter;
            return this;
        }

        @Nonnull
        public Installer setKeyParceler(@Nonnull KeyParceler keyParceler) {
            if (keyParceler == null) {
                throw new IllegalArgumentException("If set, KeyParceler cannot be null!");
            }
            this.keyParceler = keyParceler;
            return this;
        }

        @Nonnull
        public Installer setStateClearStrategy(@Nonnull Backstack.StateClearStrategy stateClearStrategy) {
            if (stateClearStrategy == null) {
                throw new IllegalArgumentException("If set, StateClearStrategy cannot be null!");
            }
            this.stateClearStrategy = stateClearStrategy;
            return this;
        }

        @Nonnull
        public Installer setScopedServices(@Nonnull ScopedServices scopedServices) {
            if (scopedServices == null) {
                throw new IllegalArgumentException("If set, scoped services cannot be null!");
            }
            this.scopedServices = scopedServices;
            return this;
        }

        @Nonnull
        public Installer setGlobalServices(@Nonnull GlobalServices globalServices) {
            if (globalServices == null) {
                throw new IllegalArgumentException("If set, global services cannot be null!");
            }
            this.globalServices = globalServices;
            return this;
        }

        @Nonnull
        public Installer setGlobalServices(@Nonnull GlobalServices.Factory globalServiceFactory) {
            if (globalServiceFactory == null) {
                throw new IllegalArgumentException("If set, global service factory cannot be null!");
            }
            this.globalServiceFactory = globalServiceFactory;
            return this;
        }

        @Nonnull
        public Installer setDeferredInitialization(boolean isInitializeDeferred) {
            this.isInitializeDeferred = isInitializeDeferred;
            return this;
        }

        @Nonnull
        public Installer setShouldPersistContainerChild(boolean shouldPersistContainerChild) {
            this.shouldPersistContainerChild = shouldPersistContainerChild;
            return this;
        }

        @Nonnull
        public Installer addStateChangeCompletionListener(@Nonnull Backstack.CompletionListener stateChangeCompletionListener) {
            if (stateChangeCompletionListener == null) {
                throw new IllegalArgumentException("If added, state change completion listener cannot be null!");
            }
            this.stateChangeCompletionListeners.add(stateChangeCompletionListener);
            return this;
        }

        @Nonnull
        public Backstack install(@Nonnull Activity activity, @Nonnull ViewGroup container, @Nonnull List<?> initialKeys) {
            if (this.stateChanger == null) {
                this.shouldPersistContainerChild = true;
                this.stateChanger = DefaultStateChanger.create((Context)activity, container);
            }
            return Navigator.install(this, activity, container, initialKeys);
        }
    }
}

