/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack.navigator;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.simplestack.navigator.DefaultViewKey;
import com.zhuinden.simplestack.navigator.Navigator;
import com.zhuinden.simplestack.navigator.ViewChangeHandler;
import com.zhuinden.simplestack.navigator.changehandlers.FadeViewChangeHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DefaultStateChanger
implements StateChanger {
    private static final FadeViewChangeHandler FADE_VIEW_CHANGE_HANDLER = new FadeViewChangeHandler();
    private Context baseContext;
    private ViewGroup container;
    private StateChanger externalStateChanger;
    private ViewChangeStartListener viewChangeStartListener;
    private ViewChangeCompletionListener viewChangeCompletionListener;
    private LayoutInflationStrategy layoutInflationStrategy;
    private StatePersistenceStrategy statePersistenceStrategy;
    private GetViewChangeHandlerStrategy getViewChangeHandlerStrategy;
    private GetPreviousViewStrategy getPreviousViewStrategy;
    private ContextCreationStrategy contextCreationStrategy;

    public static Configurer configure() {
        return new Configurer();
    }

    @Nonnull
    public static DefaultStateChanger create(Context baseContext, ViewGroup container) {
        return new DefaultStateChanger(baseContext, container, null, null, null, null, null, null, null, null);
    }

    DefaultStateChanger(@Nonnull Context baseContext, @Nonnull ViewGroup container, @Nullable StateChanger externalStateChanger, ViewChangeStartListener viewChangeStartListener, @Nullable ViewChangeCompletionListener viewChangeCompletionListener, @Nullable LayoutInflationStrategy layoutInflationStrategy, @Nullable StatePersistenceStrategy statePersistenceStrategy, @Nullable GetPreviousViewStrategy getPreviousViewStrategy, @Nullable ContextCreationStrategy contextCreationStrategy, GetViewChangeHandlerStrategy getViewChangeHandlerStrategy) {
        if (baseContext == null) {
            throw new NullPointerException("baseContext cannot be null");
        }
        if (container == null) {
            throw new NullPointerException("container cannot be null");
        }
        this.baseContext = baseContext;
        this.container = container;
        if (externalStateChanger == null) {
            externalStateChanger = new NoOpStateChanger();
        }
        this.externalStateChanger = externalStateChanger;
        if (viewChangeStartListener == null) {
            viewChangeStartListener = new NoOpViewChangeStartListener();
        }
        this.viewChangeStartListener = viewChangeStartListener;
        if (viewChangeCompletionListener == null) {
            viewChangeCompletionListener = new NoOpViewChangeCompletionListener();
        }
        this.viewChangeCompletionListener = viewChangeCompletionListener;
        if (layoutInflationStrategy == null) {
            layoutInflationStrategy = new DefaultLayoutInflationStrategy();
        }
        this.layoutInflationStrategy = layoutInflationStrategy;
        if (statePersistenceStrategy == null) {
            statePersistenceStrategy = new NavigatorStatePersistenceStrategy();
        }
        this.statePersistenceStrategy = statePersistenceStrategy;
        if (getPreviousViewStrategy == null) {
            getPreviousViewStrategy = new DefaultGetPreviousViewStrategy();
        }
        this.getPreviousViewStrategy = getPreviousViewStrategy;
        if (contextCreationStrategy == null) {
            contextCreationStrategy = new DefaultContextCreationStrategy();
        }
        this.contextCreationStrategy = contextCreationStrategy;
        if (getViewChangeHandlerStrategy == null) {
            getViewChangeHandlerStrategy = new DefaultGetViewChangeHandlerStrategy();
        }
        this.getViewChangeHandlerStrategy = getViewChangeHandlerStrategy;
    }

    private void finishStateChange(StateChange stateChange, ViewGroup container, View previousView, View newView, final StateChanger.Callback completionCallback) {
        this.viewChangeCompletionListener.handleViewChangeComplete(stateChange, container, previousView, newView, new ViewChangeCompletionListener.Callback(){

            @Override
            public void viewChangeComplete() {
                completionCallback.stateChangeComplete();
            }
        });
    }

    @Override
    public final void handleStateChange(final @Nonnull StateChange stateChange, final @Nonnull StateChanger.Callback completionCallback) {
        this.externalStateChanger.handleStateChange(stateChange, new StateChanger.Callback(){

            @Override
            public void stateChangeComplete() {
                if (stateChange.isTopNewKeyEqualToPrevious()) {
                    completionCallback.stateChangeComplete();
                    return;
                }
                DefaultStateChanger.this.performViewChange(stateChange.topPreviousKey(), stateChange.topNewKey(), stateChange, completionCallback);
            }
        });
    }

    public final void performViewChange(@Nullable Object previousKey, @Nonnull Object newKey, @Nonnull StateChange stateChange, @Nonnull StateChanger.Callback completionCallback) {
        this.performViewChange(previousKey, newKey, stateChange, stateChange.getDirection(), completionCallback);
    }

    public void performViewChange(final @Nullable Object previousKey, final @Nonnull Object newKey, final @Nonnull StateChange stateChange, final int direction, final @Nonnull StateChanger.Callback completionCallback) {
        final View previousView = this.getPreviousViewStrategy.getPreviousView(this.container, stateChange, previousKey);
        if (previousView != null && previousKey != null) {
            this.statePersistenceStrategy.persistViewToState(previousKey, previousView);
        }
        Context newContext = this.contextCreationStrategy.createContext(stateChange.createContext(this.baseContext, newKey), newKey, this.container, stateChange);
        this.layoutInflationStrategy.inflateLayout(stateChange, newKey, newContext, this.container, new LayoutInflationStrategy.Callback(){

            @Override
            public void layoutInflationComplete(final @Nonnull View newView) {
                DefaultStateChanger.this.statePersistenceStrategy.restoreViewFromState(newKey, newView);
                DefaultStateChanger.this.viewChangeStartListener.handleViewChangeStart(stateChange, DefaultStateChanger.this.container, previousView, newView, new ViewChangeStartListener.Callback(){

                    @Override
                    public void startViewChange() {
                        if (previousView == null) {
                            DefaultStateChanger.this.container.addView(newView);
                            DefaultStateChanger.this.finishStateChange(stateChange, DefaultStateChanger.this.container, previousView, newView, completionCallback);
                        } else {
                            ViewChangeHandler viewChangeHandler = DefaultStateChanger.this.getViewChangeHandlerStrategy.getViewChangeHandler(stateChange, DefaultStateChanger.this.container, previousKey, newKey, previousView, newView, direction);
                            viewChangeHandler.performViewChange(DefaultStateChanger.this.container, previousView, newView, direction, new ViewChangeHandler.ViewChangeCallback(){

                                @Override
                                public void onCompleted() {
                                    DefaultStateChanger.this.finishStateChange(stateChange, DefaultStateChanger.this.container, previousView, newView, completionCallback);
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public static class Configurer {
        StateChanger externalStateChanger = null;
        ViewChangeStartListener viewChangeStartListener = null;
        ViewChangeCompletionListener viewChangeCompletionListener = null;
        LayoutInflationStrategy layoutInflationStrategy = null;
        StatePersistenceStrategy statePersistenceStrategy = null;
        GetPreviousViewStrategy getPreviousViewStrategy = null;
        ContextCreationStrategy contextCreationStrategy = null;
        GetViewChangeHandlerStrategy getViewChangeHandlerStrategy = null;

        private Configurer() {
        }

        @Nonnull
        public Configurer setExternalStateChanger(@Nonnull StateChanger stateChanger) {
            if (stateChanger == null) {
                throw new NullPointerException("If set, external state changer cannot be null!");
            }
            this.externalStateChanger = stateChanger;
            return this;
        }

        @Nonnull
        public Configurer setViewChangeStartListener(@Nonnull ViewChangeStartListener viewChangeStartListener) {
            if (viewChangeStartListener == null) {
                throw new NullPointerException("If set, view change start listener cannot be null!");
            }
            this.viewChangeStartListener = viewChangeStartListener;
            return this;
        }

        @Nonnull
        public Configurer setViewChangeCompletionListener(@Nonnull ViewChangeCompletionListener viewChangeCompletionListener) {
            if (viewChangeCompletionListener == null) {
                throw new NullPointerException("If set, view change completion listener cannot be null!");
            }
            this.viewChangeCompletionListener = viewChangeCompletionListener;
            return this;
        }

        @Nonnull
        public Configurer setStatePersistenceStrategy(@Nonnull StatePersistenceStrategy statePersistenceStrategy) {
            if (statePersistenceStrategy == null) {
                throw new NullPointerException("If set, state persistence strategy cannot be null!");
            }
            this.statePersistenceStrategy = statePersistenceStrategy;
            return this;
        }

        @Nonnull
        public Configurer setLayoutInflationStrategy(@Nonnull LayoutInflationStrategy layoutInflationStrategy) {
            if (layoutInflationStrategy == null) {
                throw new NullPointerException("If set, layout inflation strategy cannot be null!");
            }
            this.layoutInflationStrategy = layoutInflationStrategy;
            return this;
        }

        @Nonnull
        public Configurer setGetPreviousViewStrategy(GetPreviousViewStrategy getPreviousViewStrategy) {
            if (getPreviousViewStrategy == null) {
                throw new NullPointerException("If set, get previous view strategy cannot be null!");
            }
            this.getPreviousViewStrategy = getPreviousViewStrategy;
            return this;
        }

        @Nonnull
        public Configurer setContextCreationStrategy(ContextCreationStrategy contextCreationStrategy) {
            if (contextCreationStrategy == null) {
                throw new NullPointerException("If set, create context strategy cannot be null!");
            }
            this.contextCreationStrategy = contextCreationStrategy;
            return this;
        }

        @Nonnull
        public Configurer setGetViewChangeHandlerStrategy(GetViewChangeHandlerStrategy getViewChangeHandlerStrategy) {
            if (getViewChangeHandlerStrategy == null) {
                throw new NullPointerException("If set, get view change handler strategy cannot be null!");
            }
            this.getViewChangeHandlerStrategy = getViewChangeHandlerStrategy;
            return this;
        }

        @Nonnull
        public DefaultStateChanger create(@Nonnull Context baseContext, @Nonnull ViewGroup container) {
            return new DefaultStateChanger(baseContext, container, this.externalStateChanger, this.viewChangeStartListener, this.viewChangeCompletionListener, this.layoutInflationStrategy, this.statePersistenceStrategy, this.getPreviousViewStrategy, this.contextCreationStrategy, this.getViewChangeHandlerStrategy);
        }
    }

    public static interface StatePersistenceStrategy {
        public void persistViewToState(@Nonnull Object var1, @Nonnull View var2);

        public void restoreViewFromState(@Nonnull Object var1, @Nonnull View var2);
    }

    public static interface LayoutInflationStrategy {
        public void inflateLayout(@Nonnull StateChange var1, @Nonnull Object var2, @Nonnull Context var3, @Nonnull ViewGroup var4, @Nonnull Callback var5);

        public static interface Callback {
            public void layoutInflationComplete(@Nonnull View var1);
        }
    }

    public static interface GetPreviousViewStrategy {
        @Nullable
        public View getPreviousView(@Nonnull ViewGroup var1, @Nonnull StateChange var2, @Nullable Object var3);
    }

    public static interface GetViewChangeHandlerStrategy {
        @Nonnull
        public ViewChangeHandler getViewChangeHandler(@Nonnull StateChange var1, @Nonnull ViewGroup var2, @Nonnull Object var3, @Nonnull Object var4, @Nonnull View var5, @Nonnull View var6, int var7);
    }

    public static interface ContextCreationStrategy {
        @Nonnull
        public Context createContext(@Nonnull Context var1, @Nonnull Object var2, @Nonnull ViewGroup var3, @Nonnull StateChange var4);
    }

    public static interface ViewChangeCompletionListener {
        public void handleViewChangeComplete(@Nonnull StateChange var1, @Nonnull ViewGroup var2, @Nullable View var3, @Nonnull View var4, @Nonnull Callback var5);

        public static interface Callback {
            public void viewChangeComplete();
        }
    }

    public static interface ViewChangeStartListener {
        public void handleViewChangeStart(@Nonnull StateChange var1, @Nonnull ViewGroup var2, @Nullable View var3, @Nonnull View var4, @Nonnull Callback var5);

        public static interface Callback {
            public void startViewChange();
        }
    }

    private static class DefaultGetViewChangeHandlerStrategy
    implements GetViewChangeHandlerStrategy {
        private DefaultGetViewChangeHandlerStrategy() {
        }

        @Override
        @Nonnull
        public ViewChangeHandler getViewChangeHandler(@Nonnull StateChange stateChange, @Nonnull ViewGroup container, @Nonnull Object previousKey, @Nonnull Object newKey, @Nonnull View previousView, @Nonnull View newView, int direction) {
            ViewChangeHandler viewChangeHandler = direction == 1 ? ((DefaultViewKey)newKey).viewChangeHandler() : (direction == -1 ? ((DefaultViewKey)previousKey).viewChangeHandler() : FADE_VIEW_CHANGE_HANDLER);
            return viewChangeHandler;
        }
    }

    private static class DefaultContextCreationStrategy
    implements ContextCreationStrategy {
        private DefaultContextCreationStrategy() {
        }

        @Override
        @Nonnull
        public Context createContext(@Nonnull Context baseContext, @Nonnull Object newKey, @Nonnull ViewGroup container, @Nonnull StateChange stateChange) {
            return stateChange.createContext(baseContext, newKey);
        }
    }

    private static class DefaultGetPreviousViewStrategy
    implements GetPreviousViewStrategy {
        private DefaultGetPreviousViewStrategy() {
        }

        @Override
        @Nullable
        public View getPreviousView(@Nonnull ViewGroup container, @Nonnull StateChange stateChange, @Nullable Object previousKey) {
            return container.getChildAt(0);
        }
    }

    private static class NavigatorStatePersistenceStrategy
    implements StatePersistenceStrategy {
        private NavigatorStatePersistenceStrategy() {
        }

        @Override
        public void persistViewToState(@Nonnull Object previousKey, @Nonnull View previousView) {
            Navigator.persistViewToState(previousView);
        }

        @Override
        public void restoreViewFromState(@Nonnull Object newKey, @Nonnull View newView) {
            Navigator.restoreViewFromState(newView);
        }
    }

    private static class DefaultLayoutInflationStrategy
    implements LayoutInflationStrategy {
        private DefaultLayoutInflationStrategy() {
        }

        @Override
        public void inflateLayout(@Nonnull StateChange stateChange, @Nonnull Object key, @Nonnull Context context, @Nonnull ViewGroup container, @Nonnull LayoutInflationStrategy.Callback callback) {
            View newView = LayoutInflater.from((Context)context).inflate(((DefaultViewKey)key).layout(), container, false);
            callback.layoutInflationComplete(newView);
        }
    }

    private static class NoOpViewChangeCompletionListener
    implements ViewChangeCompletionListener {
        private NoOpViewChangeCompletionListener() {
        }

        @Override
        public void handleViewChangeComplete(@Nonnull StateChange stateChange, @Nonnull ViewGroup container, @Nullable View previousView, @Nonnull View newView, @Nonnull ViewChangeCompletionListener.Callback completionCallback) {
            completionCallback.viewChangeComplete();
        }
    }

    private static class NoOpViewChangeStartListener
    implements ViewChangeStartListener {
        private NoOpViewChangeStartListener() {
        }

        @Override
        public void handleViewChangeStart(@Nonnull StateChange stateChange, @Nonnull ViewGroup container, @Nullable View previousView, @Nonnull View newView, @Nonnull ViewChangeStartListener.Callback startCallback) {
            startCallback.startViewChange();
        }
    }

    private static class NoOpStateChanger
    implements StateChanger {
        private NoOpStateChanger() {
        }

        @Override
        public void handleStateChange(@Nonnull StateChange stateChange, @Nonnull StateChanger.Callback completionCallback) {
            completionCallback.stateChangeComplete();
        }
    }
}

