/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.annotation.TargetApi;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.BackstackDelegate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class History<T>
extends AbstractList<T>
implements List<T> {
    private final List<T> elements;

    History() {
        this(Collections.emptyList());
    }

    History(List<T> elements) {
        this.elements = Collections.unmodifiableList(new ArrayList<T>(elements));
    }

    @Nullable
    public <K> K top() {
        if (this.isEmpty()) {
            return null;
        }
        return (K)this.get(this.size() - 1);
    }

    @Nonnull
    public <K> K fromTop(int offset) {
        int size = this.size();
        if (size <= 0) {
            throw new IllegalStateException("Cannot obtain elements from an uninitialized history.");
        }
        if (offset < -size || offset >= size) {
            throw new IllegalArgumentException("The provided offset value [" + offset + "] was out of range: [" + -size + "; " + size + ")");
        }
        while (offset < 0) {
            offset += size;
        }
        int target = (size - 1 - (offset %= size)) % size;
        return (K)this.get(target);
    }

    @Nullable
    public <K> K root() {
        if (this.isEmpty()) {
            return null;
        }
        return (K)this.get(0);
    }

    @Nonnull
    public Builder buildUpon() {
        return History.builderFrom(this);
    }

    @Nonnull
    public static <T> History<T> of(T ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Cannot provide `null` as a key!");
        }
        for (T key : keys) {
            if (key != null) continue;
            throw new IllegalArgumentException("Cannot provide `null` as a key!");
        }
        return History.builderFrom(Arrays.asList(keys)).build();
    }

    @Nonnull
    public static <T> History<T> from(@Nonnull List<? extends T> keys) {
        return History.builderFrom(keys).build();
    }

    @Nonnull
    public static Builder builderFrom(@Nonnull Backstack backstack) {
        if (backstack == null) {
            throw new IllegalArgumentException("Backstack cannot be null!");
        }
        return History.newBuilder().addAll(backstack.getHistory());
    }

    @Nonnull
    public static Builder builderFrom(@Nonnull BackstackDelegate backstackDelegate) {
        if (backstackDelegate == null) {
            throw new IllegalArgumentException("BackstackDelegate cannot be null!");
        }
        return History.builderFrom(backstackDelegate.getBackstack());
    }

    @Nonnull
    public static Builder builderOf(Object ... keys) {
        return History.builderFrom(Arrays.asList(keys));
    }

    @Nonnull
    public static Builder builderFrom(@Nonnull List<?> keys) {
        for (Object key : keys) {
            if (key != null) continue;
            throw new IllegalArgumentException("Cannot provide `null` as a key!");
        }
        return History.newBuilder().addAll(keys);
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public static <T> History<T> single(@Nonnull T key) {
        return History.newBuilder().add(key).build();
    }

    @Override
    public boolean add(T t) {
        return this.elements.add(t);
    }

    @Override
    public T set(int index, T element) {
        return this.elements.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.elements.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.elements.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.elements.addAll(index, c);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    @Override
    @Nonnull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.elements.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof History)) {
            return false;
        }
        return this.elements.equals(((History)o).elements);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.elements.hashCode();
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    @Nonnull
    public <T1> T1[] toArray(@Nonnull T1[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> c) {
        return this.elements.addAll(c);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public String toString() {
        return Arrays.toString(this.elements.toArray());
    }

    @Override
    public T get(int index) {
        return this.elements.get(index);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    @TargetApi(value=24)
    public boolean removeIf(Predicate<? super T> filter) {
        return this.elements.removeIf(filter);
    }

    @Override
    @TargetApi(value=24)
    public void replaceAll(UnaryOperator<T> operator) {
        this.elements.replaceAll(operator);
    }

    @Override
    @TargetApi(value=24)
    public void sort(Comparator<? super T> c) {
        this.elements.sort(c);
    }

    @Override
    @TargetApi(value=24)
    public Spliterator<T> spliterator() {
        return this.elements.spliterator();
    }

    @Override
    @TargetApi(value=24)
    public Stream<T> stream() {
        return this.elements.stream();
    }

    @Override
    @TargetApi(value=24)
    public Stream<T> parallelStream() {
        return this.elements.parallelStream();
    }

    @Override
    @TargetApi(value=24)
    public void forEach(Consumer<? super T> action) {
        this.elements.forEach(action);
    }

    public static class Builder
    implements Iterable<Object> {
        private ArrayList<Object> list = new ArrayList();

        Builder() {
        }

        @Nonnull
        public Builder addAll(@Nonnull List<?> keys) {
            if (keys == null) {
                throw new IllegalArgumentException("Provided collection cannot be null");
            }
            this.list.addAll(keys);
            return this;
        }

        @Nonnull
        public Builder addAllAt(@Nonnull List<?> keys, int index) {
            if (keys == null) {
                throw new IllegalArgumentException("Provided collection cannot be null");
            }
            this.list.addAll(index, keys);
            return this;
        }

        @Nonnull
        public Builder clear() {
            this.list.clear();
            return this;
        }

        public boolean contains(@Nonnull Object key) {
            this.checkKey(key);
            return this.list.contains(key);
        }

        public boolean containsAll(@Nonnull Collection<?> keys) {
            if (keys == null) {
                throw new IllegalArgumentException("Keys cannot be null!");
            }
            return this.list.containsAll(keys);
        }

        public int size() {
            return this.list.size();
        }

        @Nonnull
        public Builder remove(@Nonnull Object key) {
            this.checkKey(key);
            this.list.remove(key);
            return this;
        }

        @Nonnull
        public Builder removeAt(int index) {
            this.list.remove(index);
            return this;
        }

        @Nonnull
        public Builder retainAll(@Nonnull Collection<?> keys) {
            this.checkKeys(keys);
            this.list.retainAll(keys);
            return this;
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Nonnull
        public Builder removeLast() {
            if (this.list.isEmpty()) {
                throw new IllegalStateException("Cannot remove element from empty builder");
            }
            this.list.remove(this.list.size() - 1);
            return this;
        }

        @Nonnull
        public Builder removeUntil(@Nonnull Object key) {
            this.checkKey(key);
            while (!this.list.isEmpty() && !this.getLast().equals(key)) {
                this.removeLast();
            }
            if (this.list.isEmpty()) {
                throw new IllegalArgumentException("[" + key + "] was not found in history!");
            }
            return this;
        }

        public int indexOf(@Nonnull Object key) {
            this.checkKey(key);
            return this.list.indexOf(key);
        }

        @Nonnull
        public <T> T get(int index) {
            return (T)this.list.get(index);
        }

        @Nullable
        public <T> T getLast() {
            return (T)(this.list.isEmpty() ? null : this.list.get(this.list.size() - 1));
        }

        @Nonnull
        public Builder add(@Nonnull Object key) {
            this.checkKey(key);
            this.list.add(key);
            return this;
        }

        @Nonnull
        public Builder add(@Nonnull Object key, int index) {
            this.checkKey(key);
            this.list.add(index, key);
            return this;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            return this.list.iterator();
        }

        @Nonnull
        public <T> History<T> build() {
            LinkedList<Object> list = new LinkedList<Object>();
            for (Object obj : this.list) {
                list.add(obj);
            }
            return new History(list);
        }

        private void checkKey(Object key) {
            if (key == null) {
                throw new IllegalArgumentException("History key cannot be null!");
            }
        }

        private void checkKeys(Collection<?> keys) {
            if (keys == null) {
                throw new IllegalArgumentException("Keys cannot be null!");
            }
        }
    }
}

