/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack.navigator;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.simplestack.navigator.DefaultViewKey;
import com.zhuinden.simplestack.navigator.Navigator;
import com.zhuinden.simplestack.navigator.ViewChangeHandler;
import com.zhuinden.simplestack.navigator.changehandlers.FadeViewChangeHandler;

public final class DefaultStateChanger
implements StateChanger {
    private static final FadeViewChangeHandler FADE_VIEW_CHANGE_HANDLER = new FadeViewChangeHandler();
    private Context baseContext;
    private ViewGroup container;
    private StateChanger externalStateChanger;
    private ViewChangeStartListener viewChangeStartListener;
    private ViewChangeCompletionListener viewChangeCompletionListener;
    private LayoutInflationStrategy layoutInflationStrategy;
    private StatePersistenceStrategy statePersistenceStrategy;
    private GetViewChangeHandlerStrategy getViewChangeHandlerStrategy;
    private GetPreviousViewStrategy getPreviousViewStrategy;
    private ContextCreationStrategy contextCreationStrategy;

    public static Configurer configure() {
        return new Configurer();
    }

    @NonNull
    public static DefaultStateChanger create(Context baseContext, ViewGroup container) {
        return new DefaultStateChanger(baseContext, container, null, null, null, null, null, null, null, null);
    }

    DefaultStateChanger(@NonNull Context baseContext, @NonNull ViewGroup container, @Nullable StateChanger externalStateChanger, ViewChangeStartListener viewChangeStartListener, @Nullable ViewChangeCompletionListener viewChangeCompletionListener, @Nullable LayoutInflationStrategy layoutInflationStrategy, @Nullable StatePersistenceStrategy statePersistenceStrategy, @Nullable GetPreviousViewStrategy getPreviousViewStrategy, @Nullable ContextCreationStrategy contextCreationStrategy, GetViewChangeHandlerStrategy getViewChangeHandlerStrategy) {
        if (baseContext == null) {
            throw new NullPointerException("baseContext cannot be null");
        }
        if (container == null) {
            throw new NullPointerException("container cannot be null");
        }
        this.baseContext = baseContext;
        this.container = container;
        if (externalStateChanger == null) {
            externalStateChanger = new NoOpStateChanger();
        }
        this.externalStateChanger = externalStateChanger;
        if (viewChangeStartListener == null) {
            viewChangeStartListener = new NoOpViewChangeStartListener();
        }
        this.viewChangeStartListener = viewChangeStartListener;
        if (viewChangeCompletionListener == null) {
            viewChangeCompletionListener = new NoOpViewChangeCompletionListener();
        }
        this.viewChangeCompletionListener = viewChangeCompletionListener;
        if (layoutInflationStrategy == null) {
            layoutInflationStrategy = new DefaultLayoutInflationStrategy();
        }
        this.layoutInflationStrategy = layoutInflationStrategy;
        if (statePersistenceStrategy == null) {
            statePersistenceStrategy = new NavigatorStatePersistenceStrategy();
        }
        this.statePersistenceStrategy = statePersistenceStrategy;
        if (getPreviousViewStrategy == null) {
            getPreviousViewStrategy = new DefaultGetPreviousViewStrategy();
        }
        this.getPreviousViewStrategy = getPreviousViewStrategy;
        if (contextCreationStrategy == null) {
            contextCreationStrategy = new DefaultContextCreationStrategy();
        }
        this.contextCreationStrategy = contextCreationStrategy;
        if (getViewChangeHandlerStrategy == null) {
            getViewChangeHandlerStrategy = new DefaultGetViewChangeHandlerStrategy();
        }
        this.getViewChangeHandlerStrategy = getViewChangeHandlerStrategy;
    }

    private void finishStateChange(StateChange stateChange, ViewGroup container, View previousView, View newView, final StateChanger.Callback completionCallback) {
        this.viewChangeCompletionListener.handleViewChangeComplete(stateChange, container, previousView, newView, new ViewChangeCompletionListener.Callback(){

            @Override
            public void viewChangeComplete() {
                completionCallback.stateChangeComplete();
            }
        });
    }

    @Override
    public final void handleStateChange(final @NonNull StateChange stateChange, final @NonNull StateChanger.Callback completionCallback) {
        this.externalStateChanger.handleStateChange(stateChange, new StateChanger.Callback(){

            @Override
            public void stateChangeComplete() {
                if (stateChange.isTopNewKeyEqualToPrevious()) {
                    completionCallback.stateChangeComplete();
                    return;
                }
                DefaultStateChanger.this.performViewChange(stateChange.topPreviousKey(), stateChange.topNewKey(), stateChange, completionCallback);
            }
        });
    }

    public final void performViewChange(@Nullable Object previousKey, @NonNull Object newKey, @NonNull StateChange stateChange, @NonNull StateChanger.Callback completionCallback) {
        this.performViewChange(previousKey, newKey, stateChange, stateChange.getDirection(), completionCallback);
    }

    public void performViewChange(final @Nullable Object previousKey, final @NonNull Object newKey, final @NonNull StateChange stateChange, final int direction, final @NonNull StateChanger.Callback completionCallback) {
        final View previousView = this.getPreviousViewStrategy.getPreviousView(this.container, stateChange, previousKey);
        if (previousView != null && previousKey != null) {
            this.statePersistenceStrategy.persistViewToState(previousKey, previousView);
        }
        Context newContext = this.contextCreationStrategy.createContext(stateChange.createContext(this.baseContext, newKey), newKey, this.container, stateChange);
        this.layoutInflationStrategy.inflateLayout(stateChange, newKey, newContext, this.container, new LayoutInflationStrategy.Callback(){

            @Override
            public void layoutInflationComplete(final @NonNull View newView) {
                DefaultStateChanger.this.statePersistenceStrategy.restoreViewFromState(newKey, newView);
                DefaultStateChanger.this.viewChangeStartListener.handleViewChangeStart(stateChange, DefaultStateChanger.this.container, previousView, newView, new ViewChangeStartListener.Callback(){

                    @Override
                    public void startViewChange() {
                        if (previousView == null) {
                            DefaultStateChanger.this.container.addView(newView);
                            DefaultStateChanger.this.finishStateChange(stateChange, DefaultStateChanger.this.container, previousView, newView, completionCallback);
                        } else {
                            ViewChangeHandler viewChangeHandler = DefaultStateChanger.this.getViewChangeHandlerStrategy.getViewChangeHandler(stateChange, DefaultStateChanger.this.container, previousKey, newKey, previousView, newView, direction);
                            viewChangeHandler.performViewChange(DefaultStateChanger.this.container, previousView, newView, direction, new ViewChangeHandler.ViewChangeCallback(){

                                @Override
                                public void onCompleted() {
                                    DefaultStateChanger.this.finishStateChange(stateChange, DefaultStateChanger.this.container, previousView, newView, completionCallback);
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public static class Configurer {
        StateChanger externalStateChanger = null;
        ViewChangeStartListener viewChangeStartListener = null;
        ViewChangeCompletionListener viewChangeCompletionListener = null;
        LayoutInflationStrategy layoutInflationStrategy = null;
        StatePersistenceStrategy statePersistenceStrategy = null;
        GetPreviousViewStrategy getPreviousViewStrategy = null;
        ContextCreationStrategy contextCreationStrategy = null;
        GetViewChangeHandlerStrategy getViewChangeHandlerStrategy = null;

        private Configurer() {
        }

        @NonNull
        public Configurer setExternalStateChanger(@NonNull StateChanger stateChanger) {
            if (stateChanger == null) {
                throw new NullPointerException("If set, external state changer cannot be null!");
            }
            this.externalStateChanger = stateChanger;
            return this;
        }

        @NonNull
        public Configurer setViewChangeStartListener(@NonNull ViewChangeStartListener viewChangeStartListener) {
            if (viewChangeStartListener == null) {
                throw new NullPointerException("If set, view change start listener cannot be null!");
            }
            this.viewChangeStartListener = viewChangeStartListener;
            return this;
        }

        @NonNull
        public Configurer setViewChangeCompletionListener(@NonNull ViewChangeCompletionListener viewChangeCompletionListener) {
            if (viewChangeCompletionListener == null) {
                throw new NullPointerException("If set, view change completion listener cannot be null!");
            }
            this.viewChangeCompletionListener = viewChangeCompletionListener;
            return this;
        }

        @NonNull
        public Configurer setStatePersistenceStrategy(@NonNull StatePersistenceStrategy statePersistenceStrategy) {
            if (statePersistenceStrategy == null) {
                throw new NullPointerException("If set, state persistence strategy cannot be null!");
            }
            this.statePersistenceStrategy = statePersistenceStrategy;
            return this;
        }

        @NonNull
        public Configurer setLayoutInflationStrategy(@NonNull LayoutInflationStrategy layoutInflationStrategy) {
            if (layoutInflationStrategy == null) {
                throw new NullPointerException("If set, layout inflation strategy cannot be null!");
            }
            this.layoutInflationStrategy = layoutInflationStrategy;
            return this;
        }

        @NonNull
        public Configurer setGetPreviousViewStrategy(GetPreviousViewStrategy getPreviousViewStrategy) {
            if (getPreviousViewStrategy == null) {
                throw new NullPointerException("If set, get previous view strategy cannot be null!");
            }
            this.getPreviousViewStrategy = getPreviousViewStrategy;
            return this;
        }

        @NonNull
        public Configurer setContextCreationStrategy(ContextCreationStrategy contextCreationStrategy) {
            if (contextCreationStrategy == null) {
                throw new NullPointerException("If set, create context strategy cannot be null!");
            }
            this.contextCreationStrategy = contextCreationStrategy;
            return this;
        }

        @NonNull
        public Configurer setGetViewChangeHandlerStrategy(GetViewChangeHandlerStrategy getViewChangeHandlerStrategy) {
            if (getViewChangeHandlerStrategy == null) {
                throw new NullPointerException("If set, get view change handler strategy cannot be null!");
            }
            this.getViewChangeHandlerStrategy = getViewChangeHandlerStrategy;
            return this;
        }

        @NonNull
        public DefaultStateChanger create(@NonNull Context baseContext, @NonNull ViewGroup container) {
            return new DefaultStateChanger(baseContext, container, this.externalStateChanger, this.viewChangeStartListener, this.viewChangeCompletionListener, this.layoutInflationStrategy, this.statePersistenceStrategy, this.getPreviousViewStrategy, this.contextCreationStrategy, this.getViewChangeHandlerStrategy);
        }
    }

    public static interface StatePersistenceStrategy {
        public void persistViewToState(@NonNull Object var1, @NonNull View var2);

        public void restoreViewFromState(@NonNull Object var1, @NonNull View var2);
    }

    public static interface LayoutInflationStrategy {
        public void inflateLayout(@NonNull StateChange var1, @NonNull Object var2, @NonNull Context var3, @NonNull ViewGroup var4, @NonNull Callback var5);

        public static interface Callback {
            public void layoutInflationComplete(@NonNull View var1);
        }
    }

    public static interface GetPreviousViewStrategy {
        @Nullable
        public View getPreviousView(@NonNull ViewGroup var1, @NonNull StateChange var2, @Nullable Object var3);
    }

    public static interface GetViewChangeHandlerStrategy {
        @NonNull
        public ViewChangeHandler getViewChangeHandler(@NonNull StateChange var1, @NonNull ViewGroup var2, @NonNull Object var3, @NonNull Object var4, @NonNull View var5, @NonNull View var6, int var7);
    }

    public static interface ContextCreationStrategy {
        @NonNull
        public Context createContext(@NonNull Context var1, @NonNull Object var2, @NonNull ViewGroup var3, @NonNull StateChange var4);
    }

    public static interface ViewChangeCompletionListener {
        public void handleViewChangeComplete(@NonNull StateChange var1, @NonNull ViewGroup var2, @Nullable View var3, @NonNull View var4, @NonNull Callback var5);

        public static interface Callback {
            public void viewChangeComplete();
        }
    }

    public static interface ViewChangeStartListener {
        public void handleViewChangeStart(@NonNull StateChange var1, @NonNull ViewGroup var2, @Nullable View var3, @NonNull View var4, @NonNull Callback var5);

        public static interface Callback {
            public void startViewChange();
        }
    }

    private static class DefaultGetViewChangeHandlerStrategy
    implements GetViewChangeHandlerStrategy {
        private DefaultGetViewChangeHandlerStrategy() {
        }

        @Override
        @NonNull
        public ViewChangeHandler getViewChangeHandler(@NonNull StateChange stateChange, @NonNull ViewGroup container, @NonNull Object previousKey, @NonNull Object newKey, @NonNull View previousView, @NonNull View newView, int direction) {
            ViewChangeHandler viewChangeHandler = direction == 1 ? ((DefaultViewKey)newKey).viewChangeHandler() : (direction == -1 ? ((DefaultViewKey)previousKey).viewChangeHandler() : FADE_VIEW_CHANGE_HANDLER);
            return viewChangeHandler;
        }
    }

    private static class DefaultContextCreationStrategy
    implements ContextCreationStrategy {
        private DefaultContextCreationStrategy() {
        }

        @Override
        @NonNull
        public Context createContext(@NonNull Context baseContext, @NonNull Object newKey, @NonNull ViewGroup container, @NonNull StateChange stateChange) {
            return stateChange.createContext(baseContext, newKey);
        }
    }

    private static class DefaultGetPreviousViewStrategy
    implements GetPreviousViewStrategy {
        private DefaultGetPreviousViewStrategy() {
        }

        @Override
        @Nullable
        public View getPreviousView(@NonNull ViewGroup container, @NonNull StateChange stateChange, @Nullable Object previousKey) {
            return container.getChildAt(0);
        }
    }

    private static class NavigatorStatePersistenceStrategy
    implements StatePersistenceStrategy {
        private NavigatorStatePersistenceStrategy() {
        }

        @Override
        public void persistViewToState(@NonNull Object previousKey, @NonNull View previousView) {
            Navigator.persistViewToState(previousView);
        }

        @Override
        public void restoreViewFromState(@NonNull Object newKey, @NonNull View newView) {
            Navigator.restoreViewFromState(newView);
        }
    }

    private static class DefaultLayoutInflationStrategy
    implements LayoutInflationStrategy {
        private DefaultLayoutInflationStrategy() {
        }

        @Override
        public void inflateLayout(@NonNull StateChange stateChange, @NonNull Object key, @NonNull Context context, @NonNull ViewGroup container, @NonNull LayoutInflationStrategy.Callback callback) {
            View newView = LayoutInflater.from((Context)context).inflate(((DefaultViewKey)key).layout(), container, false);
            callback.layoutInflationComplete(newView);
        }
    }

    private static class NoOpViewChangeCompletionListener
    implements ViewChangeCompletionListener {
        private NoOpViewChangeCompletionListener() {
        }

        @Override
        public void handleViewChangeComplete(@NonNull StateChange stateChange, @NonNull ViewGroup container, @Nullable View previousView, @NonNull View newView, @NonNull ViewChangeCompletionListener.Callback completionCallback) {
            completionCallback.viewChangeComplete();
        }
    }

    private static class NoOpViewChangeStartListener
    implements ViewChangeStartListener {
        private NoOpViewChangeStartListener() {
        }

        @Override
        public void handleViewChangeStart(@NonNull StateChange stateChange, @NonNull ViewGroup container, @Nullable View previousView, @NonNull View newView, @NonNull ViewChangeStartListener.Callback startCallback) {
            startCallback.startViewChange();
        }
    }

    private static class NoOpStateChanger
    implements StateChanger {
        private NoOpStateChanger() {
        }

        @Override
        public void handleStateChange(@NonNull StateChange stateChange, @NonNull StateChanger.Callback completionCallback) {
            completionCallback.stateChangeComplete();
        }
    }
}

