/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.Bundleable;
import com.zhuinden.simplestack.GlobalServices;
import com.zhuinden.simplestack.ScopeKey;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopeNode;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.simplestack.ServiceBinder;
import com.zhuinden.statebundle.StateBundle;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ScopeManager {
    static final String GLOBAL_SCOPE_TAG = "__SIMPLE_STACK_INTERNAL_GLOBAL_SCOPE__";
    private final ScopeRegistration globalScopeRegistration = new ScopeRegistration(null, "__SIMPLE_STACK_INTERNAL_GLOBAL_SCOPE__", Collections.emptyList(), true, true);
    private static final GlobalServices EMPTY_GLOBAL_SERVICES = GlobalServices.builder().build();
    private final ScopeRegistrations scopes = new ScopeRegistrations();
    private final IdentityHashMap<ScopedServices.HandlesBack, Boolean> backDispatchedServices = new IdentityHashMap();
    private final LinkedHashSet<Object> trackedKeys = new LinkedHashSet();
    private final IdentityHashMap<Object, Set<String>> scopeEnteredServices = new IdentityHashMap();
    private final IdentityHashMap<Object, Set<String>> scopeActivatedServices = new IdentityHashMap();
    private final IdentityHashMap<Object, Integer> untrackEventInvocationTracker = new IdentityHashMap();
    private boolean isGlobalScopePendingActivation = true;
    private GlobalServices globalServices = EMPTY_GLOBAL_SERVICES;
    private GlobalServices.Factory globalServiceFactory = null;
    private ScopedServices scopedServices = new AssertingScopedServices();
    private Backstack backstack;
    private final StateBundle rootBundle = new StateBundle();
    private boolean isInitialized = false;
    private boolean isFinalized = false;

    void activateGlobalScope() {
        this.notifyScopeActivation(GLOBAL_SCOPE_TAG, this.globalServices.getScope());
    }

    void deactivateGlobalScope() {
        this.notifyScopeDeactivation(GLOBAL_SCOPE_TAG, this.globalServices.getScope());
    }

    ScopeManager() {
    }

    void setBackstack(Backstack backstack) {
        this.backstack = backstack;
    }

    Backstack getBackstack() {
        return this.backstack;
    }

    void setScopedServices(ScopedServices scopedServices) {
        this.scopedServices = scopedServices;
    }

    void setGlobalServices(GlobalServices globalServices) {
        this.globalServices = globalServices;
    }

    void setGlobalServices(GlobalServices.Factory globalServiceFactory) {
        this.globalServiceFactory = globalServiceFactory;
    }

    private void buildGlobalScope() {
        if (!this.scopes.containsKey(GLOBAL_SCOPE_TAG)) {
            if (this.globalServiceFactory != null) {
                this.globalServices = this.globalServiceFactory.create();
            }
            ScopeNode scope = this.globalServices.getScope();
            this.scopes.put(this.globalScopeRegistration, scope);
            this.restoreAndNotifyServices(GLOBAL_SCOPE_TAG, scope);
        }
    }

    private void buildScope(Object key, String scopeTag, boolean isExplicitParent) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag provided by scope key cannot be null!");
        }
        if (!this.scopes.containsKey(scopeTag)) {
            ScopeNode scope = new ScopeNode();
            this.scopes.putKey(key, scopeTag, scope, isExplicitParent, false);
            this.scopedServices.bindServices(new ServiceBinder(this, key, scopeTag, scope));
            this.restoreAndNotifyServices(scopeTag, scope);
        }
    }

    private void restoreAndNotifyServices(String scopeTag, ScopeNode scope) {
        for (Map.Entry<String, Object> serviceEntry : scope.services()) {
            String serviceTag = serviceEntry.getKey();
            Object service = serviceEntry.getValue();
            if (this.isServiceNotRegistered(service)) {
                StateBundle scopeBundle;
                if (this.rootBundle.containsKey(scopeTag) && service instanceof Bundleable && (scopeBundle = this.rootBundle.getBundle(scopeTag)) != null && scopeBundle.containsKey(serviceTag)) {
                    ((Bundleable)service).fromBundle(scopeBundle.getBundle(serviceTag));
                }
                if (service instanceof ScopedServices.Registered) {
                    ((ScopedServices.Registered)service).onServiceRegistered();
                }
            }
            if (!this.isServiceNotTrackedInScope(this.scopeEnteredServices, service, scopeTag)) continue;
            this.trackServiceInScope(this.scopeEnteredServices, service, scopeTag);
        }
    }

    public boolean dispatchBack(@NonNull Object currentTop) {
        this.backDispatchedServices.clear();
        ArrayList<String> scopeTags = new ArrayList<String>(this.scopes.findScopesForKey(currentTop, true));
        for (String scopeTag : scopeTags) {
            ScopeNode scopeNode = this.scopes.get(scopeTag);
            ArrayList<Map.Entry<String, Object>> services = new ArrayList<Map.Entry<String, Object>>(scopeNode.services());
            for (int i = services.size() - 1; i >= 0; --i) {
                ScopedServices.HandlesBack handlesBack;
                Object service = ((Map.Entry)services.get(i)).getValue();
                if (!(service instanceof ScopedServices.HandlesBack) || this.backDispatchedServices.containsKey(handlesBack = (ScopedServices.HandlesBack)service)) continue;
                this.backDispatchedServices.put(handlesBack, true);
                boolean handled = handlesBack.onBackEvent();
                if (!handled) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isServiceNotRegistered(Object service) {
        return !this.scopeEnteredServices.containsKey(service) || this.scopeEnteredServices.get(service).isEmpty();
    }

    private boolean isServiceNotActivated(Object service) {
        return !this.scopeActivatedServices.containsKey(service) || this.scopeActivatedServices.get(service).isEmpty();
    }

    private boolean isServiceNotTrackedInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        return !scopeEventTracker.containsKey(service) || !scopeEventTracker.get(service).contains(scopeTag);
    }

    private void trackServiceInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        Set<String> trackedScopes = scopeEventTracker.get(service);
        if (trackedScopes == null) {
            trackedScopes = new LinkedHashSet<String>();
            scopeEventTracker.put(service, trackedScopes);
        }
        trackedScopes.add(scopeTag);
    }

    private void untrackServiceInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        Set<String> trackedScopes = scopeEventTracker.get(service);
        trackedScopes.remove(scopeTag);
        if (trackedScopes.isEmpty()) {
            scopeEventTracker.remove(service);
        }
    }

    boolean isFinalized() {
        return this.isFinalized;
    }

    void finalizeScopes() {
        this.isFinalized = true;
        this.destroyScope(GLOBAL_SCOPE_TAG);
        this.isInitialized = false;
    }

    void buildScopes(List<Object> newKeys) {
        if (this.isFinalized) {
            this.isFinalized = false;
            this.isGlobalScopePendingActivation = true;
        }
        if (!this.isInitialized) {
            this.buildGlobalScope();
        }
        this.isInitialized = true;
        this.trackedKeys.addAll(newKeys);
        for (Object key : newKeys) {
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                for (String parent : child.getParentScopes()) {
                    this.buildScope(key, parent, true);
                }
            }
            if (!(key instanceof ScopeKey)) continue;
            ScopeKey scopeKey = (ScopeKey)key;
            String scopeTag = scopeKey.getScopeTag();
            this.buildScope(key, scopeTag, false);
        }
    }

    void cleanupScopesBy(List<Object> newKeys) {
        LinkedHashSet<String> currentScopes = new LinkedHashSet<String>();
        currentScopes.add(GLOBAL_SCOPE_TAG);
        for (Object key : newKeys) {
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                currentScopes.addAll(child.getParentScopes());
            }
            if (!(key instanceof ScopeKey)) continue;
            ScopeKey scopeKey = (ScopeKey)key;
            currentScopes.add(scopeKey.getScopeTag());
        }
        ArrayList<String> activeScopes = new ArrayList<String>(this.scopes.keySet());
        Collections.reverse(activeScopes);
        for (String activeScope : activeScopes) {
            if (currentScopes.contains(activeScope)) continue;
            this.destroyScope(activeScope);
        }
        this.trackedKeys.retainAll(newKeys);
        for (String currentScope : currentScopes) {
            if (!activeScopes.contains(currentScope)) continue;
            this.scopes.reorderToEnd(currentScope);
        }
    }

    void destroyScope(String scopeTag) {
        if (this.scopes.containsKey(scopeTag)) {
            ScopeNode scopeNode = this.scopes.remove(scopeTag);
            this.destroyServicesAndRemoveState(scopeTag, scopeNode);
        }
    }

    private void destroyServicesAndRemoveState(String scopeTag, ScopeNode scopeNode) {
        Set<Map.Entry<String, Object>> services = scopeNode.services();
        ArrayList<Object> previousServices = new ArrayList<Object>(services.size());
        for (Map.Entry<String, Object> entry : services) {
            previousServices.add(entry.getValue());
        }
        Collections.reverse(previousServices);
        this.untrackEventInvocationTracker.clear();
        for (Map.Entry<String, Object> entry : previousServices) {
            if (!this.isServiceNotTrackedInScope(this.scopeEnteredServices, entry, scopeTag)) {
                this.untrackServiceInScope(this.scopeEnteredServices, entry, scopeTag);
            }
            if (!this.isServiceNotRegistered(entry) || !(entry instanceof ScopedServices.Registered) || this.untrackEventInvocationTracker.containsKey(entry)) continue;
            this.untrackEventInvocationTracker.put(entry, 1);
            ((ScopedServices.Registered)((Object)entry)).onServiceUnregistered();
        }
        this.rootBundle.remove(scopeTag);
    }

    void dispatchActivation(@NonNull Set<String> scopesToDeactivate, @NonNull Set<String> scopesToActivate) {
        if (this.isGlobalScopePendingActivation) {
            this.isGlobalScopePendingActivation = false;
            this.activateGlobalScope();
        }
        for (String newScopeTag : scopesToActivate) {
            if (!this.scopes.containsKey(newScopeTag)) {
                throw new AssertionError((Object)"The new scope should exist, but it doesn't! This shouldn't happen. If you see this error, this functionality is broken.");
            }
            ScopeNode newScope = this.scopes.get(newScopeTag);
            this.notifyScopeActivation(newScopeTag, newScope);
        }
        for (String previousScopeTag : scopesToDeactivate) {
            if (!this.scopes.containsKey(previousScopeTag)) {
                throw new AssertionError((Object)"The previous scope should exist, but it doesn't! This shouldn't happen. If you see this error, this functionality is broken.");
            }
            ScopeNode previousScopeNode = this.scopes.get(previousScopeTag);
            this.notifyScopeDeactivation(previousScopeTag, previousScopeNode);
        }
    }

    private void notifyScopeActivation(String newScopeTag, ScopeNode newScope) {
        for (Map.Entry<String, Object> entry : newScope.services()) {
            Object service = entry.getValue();
            if (this.isServiceNotActivated(service) && service instanceof ScopedServices.Activated) {
                ((ScopedServices.Activated)service).onServiceActive();
            }
            if (!this.isServiceNotTrackedInScope(this.scopeActivatedServices, service, newScopeTag)) continue;
            this.trackServiceInScope(this.scopeActivatedServices, service, newScopeTag);
        }
    }

    private void notifyScopeDeactivation(String previousScopeTag, ScopeNode previousScope) {
        Set<Map.Entry<String, Object>> services = previousScope.services();
        ArrayList<Object> previousServices = new ArrayList<Object>(services.size());
        for (Map.Entry<String, Object> entry : services) {
            previousServices.add(entry.getValue());
        }
        Collections.reverse(previousServices);
        this.untrackEventInvocationTracker.clear();
        for (Map.Entry<String, Object> entry : previousServices) {
            if (!this.isServiceNotTrackedInScope(this.scopeActivatedServices, entry, previousScopeTag)) {
                this.untrackServiceInScope(this.scopeActivatedServices, entry, previousScopeTag);
            }
            if (!this.isServiceNotActivated(entry) || !(entry instanceof ScopedServices.Activated) || this.untrackEventInvocationTracker.containsKey(entry)) continue;
            this.untrackEventInvocationTracker.put(entry, 1);
            ((ScopedServices.Activated)((Object)entry)).onServiceInactive();
        }
    }

    StateBundle saveStates() {
        StateBundle rootBundle = new StateBundle();
        for (Map.Entry<String, ScopeNode> scopeSet : this.scopes.entrySet()) {
            String scopeKey = scopeSet.getKey();
            ScopeNode services = scopeSet.getValue();
            StateBundle scopeBundle = new StateBundle();
            for (Map.Entry<String, Object> serviceEntry : services.services()) {
                String serviceTag = serviceEntry.getKey();
                Object service = serviceEntry.getValue();
                if (!(service instanceof Bundleable)) continue;
                scopeBundle.putBundle(serviceTag, ((Bundleable)service).toBundle());
            }
            rootBundle.putBundle(scopeKey, scopeBundle);
        }
        return rootBundle;
    }

    void setRestoredStates(StateBundle rootBundle) {
        if (rootBundle != null) {
            this.rootBundle.putAll(rootBundle);
        }
    }

    boolean hasService(@NonNull String scopeTag, @NonNull String serviceTag) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        if (!this.scopes.containsKey(scopeTag)) {
            return false;
        }
        ScopeNode services = this.scopes.get(scopeTag);
        return services.hasService(serviceTag);
    }

    @NonNull
    <T> T getService(@NonNull String scopeTag, @NonNull String serviceTag) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        if (!this.scopes.containsKey(scopeTag)) {
            throw new IllegalArgumentException("The specified scope with tag [" + scopeTag + "] does not exist!");
        }
        ScopeNode services = this.scopes.get(scopeTag);
        if (!services.hasService(serviceTag)) {
            throw new IllegalArgumentException("The specified service with tag [" + serviceTag + "] does not exist in scope [" + scopeTag + "]! Did you accidentally try to use the same scope tag with different services?");
        }
        return services.getService(serviceTag);
    }

    boolean hasScope(@NonNull String scopeTag) {
        ScopeManager.checkScopeTag(scopeTag);
        return this.scopes.containsKey(scopeTag);
    }

    @NonNull
    Set<String> findScopesForKey(@NonNull Object key, @NonNull ScopeLookupMode lookupMode) {
        ScopeManager.checkKey(key);
        ScopeManager.checkScopeLookupMode(lookupMode);
        return lookupMode.executeFindScopesForKey(this, key);
    }

    @NonNull
    Set<String> findScopesForKeyAll(Object targetKey) {
        if (!this.isInitialized) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForKey(targetKey, false);
        if (!this.isFinalized && !this.globalServices.isEmpty()) {
            activeScopes.add(GLOBAL_SCOPE_TAG);
        }
        return Collections.unmodifiableSet(activeScopes);
    }

    @NonNull
    Set<String> findScopesForKeyExplicit(Object targetKey) {
        if (!this.isInitialized) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForKey(targetKey, true);
        if (!this.isFinalized && !this.globalServices.isEmpty()) {
            activeScopes.add(GLOBAL_SCOPE_TAG);
        }
        return Collections.unmodifiableSet(activeScopes);
    }

    boolean canFindFromScope(String scopeTag, String serviceTag, ScopeLookupMode lookupMode) {
        ScopeManager.checkServiceTag(serviceTag);
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkScopeLookupMode(lookupMode);
        return lookupMode.executeCanFindFromService(this, scopeTag, serviceTag);
    }

    boolean canFindFromScopeExplicit(String scopeTag, String identifier) {
        if (!this.isInitialized) {
            return false;
        }
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForScopeTag(scopeTag, true);
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return true;
        }
        return !this.isFinalized && this.globalServices.hasService(identifier);
    }

    boolean canFindFromScopeAll(String scopeTag, String identifier) {
        if (!this.isInitialized) {
            return false;
        }
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForScopeTag(scopeTag, false);
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return true;
        }
        return !this.isFinalized && this.globalServices.hasService(identifier);
    }

    <T> T lookupFromScope(String scopeTag, String serviceTag, ScopeLookupMode lookupMode) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        ScopeManager.checkScopeLookupMode(lookupMode);
        return lookupMode.executeLookupFromScope(this, scopeTag, serviceTag);
    }

    <T> T lookupFromScopeExplicit(String scopeTag, String identifier) {
        this.verifyStackIsInitialized();
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForScopeTag(scopeTag, true);
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return scopeNode.getService(identifier);
        }
        if (!this.isFinalized && this.globalServices.hasService(identifier)) {
            return this.globalServices.getService(identifier);
        }
        throw new IllegalStateException("The service [" + identifier + "] does not exist in any scope that is accessible from [" + scopeTag + "], scopes are [" + Arrays.toString(activeScopes.toArray()) + "]!");
    }

    <T> T lookupFromScopeAll(String scopeTag, String identifier) {
        this.verifyStackIsInitialized();
        LinkedHashSet<String> activeScopes = this.scopes.findScopesForScopeTag(scopeTag, false);
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return scopeNode.getService(identifier);
        }
        if (!this.isFinalized && this.globalServices.hasService(identifier)) {
            return this.globalServices.getService(identifier);
        }
        throw new IllegalStateException("The service [" + identifier + "] does not exist in any scope that is accessible from [" + scopeTag + "], scopes are [" + Arrays.toString(activeScopes.toArray()) + "]!");
    }

    boolean canFindService(@NonNull String identifier) {
        ScopeManager.checkServiceTag(identifier);
        List<String> activeScopes = this.getScopeTagsInTraversalOrder();
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return true;
        }
        return false;
    }

    private List<String> getScopeTagsInTraversalOrder() {
        return this.scopes.getScopeTagsInTraversalOrder();
    }

    @NonNull
    <T> T lookupService(@NonNull String identifier) {
        ScopeManager.checkServiceTag(identifier);
        this.verifyStackIsInitialized();
        List<String> activeScopes = this.getScopeTagsInTraversalOrder();
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return scopeNode.getService(identifier);
        }
        if (!this.isFinalized && this.globalServices.hasService(identifier)) {
            return this.globalServices.getService(identifier);
        }
        throw new IllegalStateException("The service [" + identifier + "] does not exist in any scopes, which are " + Arrays.toString(activeScopes.toArray()) + "! Is the scope tag registered via a ScopeKey? If yes, make sure the StateChanger has been set by this time, and that you've bound and are trying to lookup the service with the correct service tag. Otherwise, it is likely that the scope you intend to inherit the service from does not exist.");
    }

    private void verifyStackIsInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Cannot lookup from an empty stack.");
        }
    }

    private static void checkKey(@NonNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
    }

    private static void checkScopeTag(@NonNull String scopeTag) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag cannot be null!");
        }
    }

    private static void checkServiceTag(@NonNull String serviceTag) {
        if (serviceTag == null) {
            throw new IllegalArgumentException("Service tag cannot be null!");
        }
    }

    static void checkParentScopes(ScopeKey.Child child) {
        if (child.getParentScopes() == null) {
            throw new IllegalArgumentException("Parent scopes cannot be null!");
        }
    }

    private static void checkScopeLookupMode(ScopeLookupMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null!");
        }
    }

    static class AssertingScopedServices
    implements ScopedServices {
        AssertingScopedServices() {
        }

        @Override
        public void bindServices(@NonNull ServiceBinder serviceBinder) {
            throw new IllegalStateException("No scoped services are defined. To create scoped services, an instance of ScopedServices must be provided to configure the services that are available in a given scope.");
        }
    }

    private static class ScopeRegistration {
        private Object key;
        private String scopeTag;
        private List<String> explicitParentScopes;
        private boolean isExplicitParent;
        private boolean isGlobalScope;

        public ScopeRegistration(@Nullable Object key, @NonNull String scopeTag, @NonNull List<String> explicitParentScopes, boolean isExplicitParent, boolean isGlobalScope) {
            if (scopeTag == null) {
                throw new NullPointerException("scopeTag must not be null!");
            }
            if (explicitParentScopes == null) {
                throw new NullPointerException("explicitParentScopes must not be null!");
            }
            this.key = key;
            this.scopeTag = scopeTag;
            this.explicitParentScopes = explicitParentScopes;
            this.isExplicitParent = isExplicitParent;
            this.isGlobalScope = isGlobalScope;
        }

        public int hashCode() {
            return this.scopeTag.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof ScopeRegistration && ((ScopeRegistration)obj).scopeTag.equals(this.scopeTag);
        }

        @NonNull
        public String toString() {
            return "ScopeRegistration[scopeTag=[" + this.scopeTag + "], explicitParents=[" + Arrays.toString(this.explicitParentScopes.toArray()) + "]]";
        }
    }

    private class ScopeRegistrations {
        private final Map<ScopeRegistration, ScopeNode> scopes = new LinkedHashMap<ScopeRegistration, ScopeNode>();

        private ScopeRegistrations() {
        }

        public boolean containsKey(String scopeTag) {
            for (ScopeRegistration registration : this.scopes.keySet()) {
                if (!registration.scopeTag.equals(scopeTag)) continue;
                return true;
            }
            return false;
        }

        public Set<String> keySet() {
            LinkedHashSet<String> scopes = new LinkedHashSet<String>();
            for (ScopeRegistration registration : this.scopes.keySet()) {
                scopes.add(registration.scopeTag);
                scopes.addAll(registration.explicitParentScopes);
            }
            return Collections.unmodifiableSet(scopes);
        }

        public Set<Map.Entry<String, ScopeNode>> entrySet() {
            LinkedHashSet<AbstractMap.SimpleEntry<String, ScopeNode>> set = new LinkedHashSet<AbstractMap.SimpleEntry<String, ScopeNode>>();
            for (Map.Entry<ScopeRegistration, ScopeNode> entry : this.scopes.entrySet()) {
                AbstractMap.SimpleEntry<String, ScopeNode> mappedEntry = new AbstractMap.SimpleEntry<String, ScopeNode>(entry.getKey().scopeTag, entry.getValue());
                set.add(mappedEntry);
            }
            return Collections.unmodifiableSet(set);
        }

        public void putKey(Object key, String scopeTag, ScopeNode scopeNode, boolean isExplicitParent, boolean isGlobalScope) {
            List<String> explicitParentScopes = key instanceof ScopeKey.Child ? ((ScopeKey.Child)key).getParentScopes() : Collections.emptyList();
            ScopeRegistration scopeRegistration = new ScopeRegistration(key, scopeTag, explicitParentScopes, isExplicitParent, isGlobalScope);
            this.put(scopeRegistration, scopeNode);
        }

        @Nullable
        public ScopeNode get(String scopeTag) {
            for (ScopeRegistration registration : this.scopes.keySet()) {
                if (!registration.scopeTag.equals(scopeTag)) continue;
                return this.scopes.get(registration);
            }
            return null;
        }

        public void put(ScopeRegistration scopeRegistration, ScopeNode scopeNode) {
            this.scopes.put(scopeRegistration, scopeNode);
        }

        @Nullable
        public ScopeNode remove(String scopeTag) {
            Iterator<Map.Entry<ScopeRegistration, ScopeNode>> iterator = this.scopes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ScopeRegistration, ScopeNode> entry = iterator.next();
                String currentScopeTag = entry.getKey().scopeTag;
                if (!currentScopeTag.equals(scopeTag)) continue;
                ScopeNode scopeNode = entry.getValue();
                iterator.remove();
                return scopeNode;
            }
            return null;
        }

        public List<String> getScopeTagsInTraversalOrder() {
            LinkedHashSet<String> scopeTags = new LinkedHashSet<String>();
            ArrayList<ScopeRegistration> registrations = new ArrayList<ScopeRegistration>(this.scopes.keySet());
            for (int i = registrations.size() - 1; i >= 0; --i) {
                ScopeRegistration registration = (ScopeRegistration)registrations.get(i);
                scopeTags.add(registration.scopeTag);
                for (int j = registration.explicitParentScopes.size() - 1; j >= 0; --j) {
                    scopeTags.add((String)registration.explicitParentScopes.get(j));
                }
            }
            ArrayList scopeTagList = new ArrayList(scopeTags);
            return Collections.unmodifiableList(scopeTagList);
        }

        public LinkedHashSet<String> findScopesForKey(@NonNull Object targetKey, boolean explicitOnly) {
            LinkedHashSet<String> scopeTags = new LinkedHashSet<String>();
            int indexInRegistrations = -1;
            ArrayList<ScopeRegistration> registrations = new ArrayList<ScopeRegistration>(this.scopes.keySet());
            for (int i = registrations.size() - 1; i >= 0; --i) {
                ScopeRegistration registration = (ScopeRegistration)registrations.get(i);
                if (registration.key == null || !registration.key.equals(targetKey)) continue;
                indexInRegistrations = i;
                break;
            }
            if (!explicitOnly && indexInRegistrations < 0 && ScopeManager.this.trackedKeys.contains(targetKey)) {
                ArrayList trackedKeyList = new ArrayList(ScopeManager.this.trackedKeys);
                int indexOfTarget = trackedKeyList.indexOf(targetKey);
                for (int i = indexOfTarget - 1; i >= 0; --i) {
                    boolean foundCandidate = false;
                    Object firstCandidate = trackedKeyList.get(i);
                    int indexOfCandidate = -1;
                    for (int j = registrations.size() - 1; j >= 0; --j) {
                        ScopeRegistration registration = (ScopeRegistration)registrations.get(j);
                        if (!firstCandidate.equals(registration.key)) continue;
                        foundCandidate = true;
                        indexOfCandidate = j;
                        break;
                    }
                    if (!foundCandidate) continue;
                    indexInRegistrations = indexOfCandidate;
                    break;
                }
            }
            if (indexInRegistrations >= 0) {
                int initialIndex = explicitOnly ? indexInRegistrations : 0;
                for (int i = indexInRegistrations; i >= initialIndex; --i) {
                    ScopeRegistration currentRegistration = (ScopeRegistration)registrations.get(i);
                    if (currentRegistration.isGlobalScope) continue;
                    scopeTags.add(currentRegistration.scopeTag);
                    ArrayList explicitParents = new ArrayList(currentRegistration.explicitParentScopes);
                    Collections.reverse(explicitParents);
                    scopeTags.addAll(explicitParents);
                }
            }
            return scopeTags;
        }

        public LinkedHashSet<String> findScopesForScopeTag(@NonNull String scopeTag, boolean explicitOnly) {
            LinkedHashSet<String> scopeTags = new LinkedHashSet<String>();
            int indexInRegistrations = -1;
            ArrayList<ScopeRegistration> registrations = new ArrayList<ScopeRegistration>(this.scopes.keySet());
            for (int i = registrations.size() - 1; i >= 0; --i) {
                ScopeRegistration registration = (ScopeRegistration)registrations.get(i);
                if (!scopeTag.equals(registration.scopeTag)) continue;
                indexInRegistrations = i;
                break;
            }
            if (indexInRegistrations >= 0) {
                int initialIndex = explicitOnly ? indexInRegistrations : 0;
                for (int x = indexInRegistrations; x >= initialIndex; --x) {
                    ScopeRegistration registration = (ScopeRegistration)registrations.get(x);
                    int indexOfParentScope = registration.explicitParentScopes.indexOf(scopeTag);
                    if (indexOfParentScope != -1) {
                        for (int i = indexOfParentScope; i >= 0; --i) {
                            scopeTags.add((String)registration.explicitParentScopes.get(i));
                        }
                        continue;
                    }
                    scopeTags.add(registration.scopeTag);
                    ArrayList explicitParents = new ArrayList(registration.explicitParentScopes);
                    Collections.reverse(explicitParents);
                    scopeTags.addAll(explicitParents);
                }
            }
            return scopeTags;
        }

        public ScopeRegistration findScopeRegistrationForScopeTag(@NonNull String scopeTag) {
            for (ScopeRegistration scopeRegistration : this.scopes.keySet()) {
                if (!scopeTag.equals(scopeRegistration.scopeTag)) continue;
                return scopeRegistration;
            }
            return null;
        }

        void reorderToEnd(@NonNull String scopeTag) {
            ScopeRegistration scopeRegistration = this.findScopeRegistrationForScopeTag(scopeTag);
            if (scopeRegistration != null) {
                ScopeNode scopeNode = this.scopes.remove(scopeRegistration);
                this.scopes.put(scopeRegistration, scopeNode);
            }
        }
    }
}

