/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ScopeNode {
    private final Map<String, Object> services = new LinkedHashMap<String, Object>();
    private final Map<String, Object> aliases = new LinkedHashMap<String, Object>();
    private final IdentityHashMap<Object, Integer> serviceTracker = new IdentityHashMap();

    ScopeNode() {
    }

    ScopeNode(@NonNull ScopeNode services) {
        if (services == null) {
            throw new IllegalArgumentException("services cannot be null!");
        }
        this.services.putAll(services.services);
        this.aliases.putAll(services.aliases);
    }

    public boolean isEmpty() {
        return this.services.isEmpty();
    }

    public void addService(@NonNull String serviceTag, @NonNull Object service) {
        ScopeNode.checkServiceTag(serviceTag);
        ScopeNode.checkService(service);
        this.services.put(serviceTag, service);
        if (!this.serviceTracker.containsKey(service)) {
            this.serviceTracker.put(service, 1);
        }
    }

    public boolean hasService(@NonNull String serviceTag) {
        ScopeNode.checkServiceTag(serviceTag);
        if (this.services.containsKey(serviceTag)) {
            return true;
        }
        ScopeNode.checkAlias(serviceTag);
        return this.aliases.containsKey(serviceTag);
    }

    public void addAlias(@NonNull String alias, @NonNull Object service) {
        ScopeNode.checkAlias(alias);
        ScopeNode.checkService(service);
        if (!this.serviceTracker.containsKey(service)) {
            throw new IllegalStateException("A service should be added to the scope before it is bound to aliases.");
        }
        this.aliases.put(alias, service);
    }

    public Set<Map.Entry<String, Object>> services() {
        return Collections.unmodifiableSet(this.services.entrySet());
    }

    public <T> T getService(@NonNull String serviceTag) {
        ScopeNode.checkServiceTag(serviceTag);
        ScopeNode.checkAlias(serviceTag);
        if (this.services.containsKey(serviceTag)) {
            return (T)this.services.get(serviceTag);
        }
        if (this.aliases.containsKey(serviceTag)) {
            return (T)this.aliases.get(serviceTag);
        }
        throw new IllegalArgumentException("Scope does not contain [" + serviceTag + "]");
    }

    private static void checkServiceTag(@NonNull String serviceTag) {
        if (serviceTag == null) {
            throw new IllegalArgumentException("serviceTag cannot be null!");
        }
    }

    private static void checkService(@NonNull Object service) {
        if (service == null) {
            throw new IllegalArgumentException("service cannot be null!");
        }
    }

    private static void checkAlias(@NonNull String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("alias cannot be null!");
        }
    }
}

