/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.NonNull;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopeManager;
import com.zhuinden.simplestack.ScopeNode;

public class ServiceBinder {
    private final ScopeManager scopeManager;
    private final Object key;
    private final String scopeTag;
    private final ScopeNode scope;

    ServiceBinder(ScopeManager scopeManager, Object key, String scopeTag, ScopeNode scope) {
        this.scopeManager = scopeManager;
        this.key = key;
        this.scopeTag = scopeTag;
        this.scope = scope;
    }

    @NonNull
    public <T> T getKey() {
        return (T)this.key;
    }

    @NonNull
    public final String getScopeTag() {
        return this.scopeTag;
    }

    public void addService(@NonNull String serviceTag, @NonNull Object service) {
        this.scope.addService(serviceTag, service);
    }

    public boolean hasService(@NonNull String serviceTag) {
        return this.scope.hasService(serviceTag);
    }

    @NonNull
    public <T> T getService(@NonNull String serviceTag) {
        return this.scope.getService(serviceTag);
    }

    public void addAlias(@NonNull String alias, @NonNull Object service) {
        this.scope.addAlias(alias, service);
    }

    public boolean hasAlias(@NonNull String alias) {
        return this.scope.hasAlias(alias);
    }

    public boolean canFindService(@NonNull String serviceTag) {
        return this.scopeManager.canFindService(serviceTag);
    }

    @NonNull
    public <T> T lookupService(@NonNull String serviceTag) {
        return this.scopeManager.lookupService(serviceTag);
    }

    public boolean canFindFromScope(String scopeTag, String serviceTag) {
        return this.scopeManager.canFindFromScope(scopeTag, serviceTag, ScopeLookupMode.ALL);
    }

    @NonNull
    public <T> T lookupFromScope(String scopeTag, String serviceTag) {
        return this.scopeManager.lookupFromScope(scopeTag, serviceTag, ScopeLookupMode.ALL);
    }

    @NonNull
    public Backstack getBackstack() {
        return this.scopeManager.getBackstack();
    }
}

