/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.content.Context;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.view.View;
import com.zhuinden.simplestack.Bundleable;
import com.zhuinden.simplestack.DefaultKeyFilter;
import com.zhuinden.simplestack.DefaultKeyParceler;
import com.zhuinden.simplestack.DefaultStateClearStrategy;
import com.zhuinden.simplestack.GlobalServices;
import com.zhuinden.simplestack.History;
import com.zhuinden.simplestack.KeyContextWrapper;
import com.zhuinden.simplestack.KeyFilter;
import com.zhuinden.simplestack.KeyParceler;
import com.zhuinden.simplestack.NavigationCore;
import com.zhuinden.simplestack.ParcelledState;
import com.zhuinden.simplestack.SavedState;
import com.zhuinden.simplestack.ScopeKey;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopeManager;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.statebundle.StateBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Backstack
implements Bundleable {
    private static final String HISTORY_TAG = "HISTORY";
    private static final String STATES_TAG = "STATES";
    private static final String SCOPES_TAG = "SCOPES";
    private Object previousTopKeyWithAssociatedScope = null;
    private final StateChanger managedStateChanger = new StateChanger(){

        @Override
        public void handleStateChange(final @NonNull StateChange stateChange, final @NonNull StateChanger.Callback completionCallback) {
            Backstack.this.scopeManager.buildScopes(stateChange.getNewKeys());
            Backstack.this.stateChanger.handleStateChange(stateChange, new StateChanger.Callback(){

                @Override
                public void stateChangeComplete() {
                    completionCallback.stateChangeComplete();
                    if (!Backstack.this.isStateChangePending()) {
                        ScopeKey.Child child;
                        ScopeKey scopeKey;
                        Backstack.this.stateClearStrategy.clearStatesNotIn(Backstack.this.keyStateMap, stateChange);
                        History<Object> newState = stateChange.getNewKeys();
                        Object newTopKeyWithAssociatedScope = null;
                        int size = newState.size();
                        for (int i = 0; i < size; ++i) {
                            Object key = newState.fromTop(i);
                            if (!(key instanceof ScopeKey) && !(key instanceof ScopeKey.Child)) continue;
                            newTopKeyWithAssociatedScope = key;
                            break;
                        }
                        LinkedHashSet<String> scopesToDeactivate = new LinkedHashSet<String>();
                        LinkedHashSet<String> scopesToActivate = new LinkedHashSet<String>();
                        if (Backstack.this.previousTopKeyWithAssociatedScope != null) {
                            if (Backstack.this.previousTopKeyWithAssociatedScope instanceof ScopeKey) {
                                scopeKey = (ScopeKey)Backstack.this.previousTopKeyWithAssociatedScope;
                                scopesToDeactivate.add(scopeKey.getScopeTag());
                            }
                            if (Backstack.this.previousTopKeyWithAssociatedScope instanceof ScopeKey.Child) {
                                child = (ScopeKey.Child)Backstack.this.previousTopKeyWithAssociatedScope;
                                ScopeManager.checkParentScopes(child);
                                List<String> parentScopes = child.getParentScopes();
                                for (int i = parentScopes.size() - 1; i >= 0; --i) {
                                    scopesToDeactivate.add(parentScopes.get(i));
                                }
                            }
                        }
                        if (newTopKeyWithAssociatedScope != null) {
                            if (newTopKeyWithAssociatedScope instanceof ScopeKey.Child) {
                                child = newTopKeyWithAssociatedScope;
                                ScopeManager.checkParentScopes(child);
                                scopesToActivate.addAll(child.getParentScopes());
                            }
                            if (newTopKeyWithAssociatedScope instanceof ScopeKey) {
                                scopeKey = newTopKeyWithAssociatedScope;
                                scopesToActivate.add(scopeKey.getScopeTag());
                            }
                        }
                        Backstack.this.previousTopKeyWithAssociatedScope = newTopKeyWithAssociatedScope;
                        Iterator scopeToActivate = scopesToActivate.iterator();
                        while (scopeToActivate.hasNext()) {
                            String activeScope = (String)scopeToActivate.next();
                            if (!scopesToDeactivate.contains(activeScope)) continue;
                            scopesToDeactivate.remove(activeScope);
                            scopeToActivate.remove();
                        }
                        if (!scopesToActivate.isEmpty() || !scopesToDeactivate.isEmpty()) {
                            Backstack.this.scopeManager.dispatchActivation(scopesToDeactivate, scopesToActivate);
                        }
                        Backstack.this.scopeManager.clearScopesNotIn(newState);
                    }
                }
            });
        }
    };
    private KeyFilter keyFilter = new DefaultKeyFilter();
    private KeyParceler keyParceler = new DefaultKeyParceler();
    private StateClearStrategy stateClearStrategy = new DefaultStateClearStrategy();
    NavigationCore core;
    Map<Object, SavedState> keyStateMap = new HashMap<Object, SavedState>();
    ScopeManager scopeManager = new ScopeManager();
    StateChanger stateChanger;

    public Backstack() {
        this.scopeManager.setBackstack(this);
    }

    @NonNull
    public static <K> K getKey(@NonNull Context context) {
        return (K)KeyContextWrapper.getKey(context);
    }

    static String getHistoryTag() {
        return HISTORY_TAG;
    }

    static String getStatesTag() {
        return STATES_TAG;
    }

    static String getScopesTag() {
        return SCOPES_TAG;
    }

    public void setKeyFilter(@NonNull KeyFilter keyFilter) {
        if (this.core != null) {
            throw new IllegalStateException("Custom key filter should be set before calling `setup()`");
        }
        if (keyFilter == null) {
            throw new IllegalArgumentException("The key filter cannot be null!");
        }
        this.keyFilter = keyFilter;
    }

    public void setKeyParceler(@NonNull KeyParceler keyParceler) {
        if (this.core != null) {
            throw new IllegalStateException("Custom key parceler should be set before calling `setup()`");
        }
        if (keyParceler == null) {
            throw new IllegalArgumentException("The key parceler cannot be null!");
        }
        this.keyParceler = keyParceler;
    }

    public void setStateClearStrategy(@NonNull StateClearStrategy stateClearStrategy) {
        if (this.core != null) {
            throw new IllegalStateException("Custom state clear strategy should be set before calling `setup()`");
        }
        if (stateClearStrategy == null) {
            throw new IllegalArgumentException("The state clear strategy cannot be null!");
        }
        this.stateClearStrategy = stateClearStrategy;
    }

    public void setScopedServices(@NonNull ScopedServices scopedServices) {
        if (this.core != null) {
            throw new IllegalStateException("Scope provider should be set before calling `setup()`");
        }
        if (scopedServices == null) {
            throw new IllegalArgumentException("The scope provider cannot be null!");
        }
        this.scopeManager.setScopedServices(scopedServices);
    }

    public void setGlobalServices(@NonNull GlobalServices globalServices) {
        if (this.core != null) {
            throw new IllegalStateException("Global scope should be set before calling `setup()`");
        }
        if (globalServices == null) {
            throw new IllegalArgumentException("The global services cannot be null!");
        }
        this.scopeManager.setGlobalServices(globalServices);
    }

    public void setup(@NonNull List<?> initialKeys) {
        this.core = new NavigationCore(initialKeys);
        this.core.setBackstack(this);
    }

    public boolean isInitialized() {
        return this.core != null;
    }

    private void initializeBackstack(StateChanger stateChanger) {
        if (stateChanger != null) {
            this.core.setStateChanger(this.managedStateChanger);
        }
    }

    public void setStateChanger(@Nullable StateChanger stateChanger) {
        this.checkBackstack("You must call `setup()` before calling `setStateChanger().");
        if (this.core.hasStateChanger()) {
            this.core.removeStateChanger();
        }
        this.stateChanger = stateChanger;
        this.initializeBackstack(stateChanger);
    }

    public void detachStateChanger() {
        this.checkBackstack("You must call `setup()` before calling `detachStateChanger().`");
        if (this.core.hasStateChanger()) {
            this.core.removeStateChanger();
        }
    }

    public void reattachStateChanger() {
        this.checkBackstack("You must call `setup()` before calling `reattachStateChanger().`");
        if (!this.core.hasStateChanger()) {
            this.core.setStateChanger(this.managedStateChanger, 1);
        }
    }

    public void finalizeScopes() {
        if (this.scopeManager.isFinalized()) {
            return;
        }
        if (this.previousTopKeyWithAssociatedScope != null) {
            LinkedHashSet<String> scopesToDeactivate = new LinkedHashSet<String>();
            if (this.previousTopKeyWithAssociatedScope instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)this.previousTopKeyWithAssociatedScope;
                ScopeManager.checkParentScopes(child);
                ArrayList<String> parentScopes = new ArrayList<String>(child.getParentScopes());
                scopesToDeactivate.addAll(parentScopes);
            }
            if (this.previousTopKeyWithAssociatedScope instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)this.previousTopKeyWithAssociatedScope;
                scopesToDeactivate.add(scopeKey.getScopeTag());
            }
            ArrayList scopesToDeactivateList = new ArrayList(scopesToDeactivate);
            Collections.reverse(scopesToDeactivateList);
            this.scopeManager.dispatchActivation(new LinkedHashSet<String>(scopesToDeactivateList), Collections.emptySet());
        }
        this.scopeManager.deactivateGlobalScope();
        History history = this.getHistory();
        LinkedHashSet<String> scopeSet = new LinkedHashSet<String>();
        int size = history.size();
        for (int i = 0; i < size; ++i) {
            Object key = history.fromTop(i);
            if (key instanceof ScopeKey) {
                scopeSet.add(((ScopeKey)key).getScopeTag());
            }
            if (!(key instanceof ScopeKey.Child)) continue;
            ScopeKey.Child child = (ScopeKey.Child)key;
            ArrayList<String> parentScopes = new ArrayList<String>(child.getParentScopes());
            Collections.reverse(parentScopes);
            for (String parent : parentScopes) {
                if (scopeSet.contains(parent)) {
                    scopeSet.remove(parent);
                }
                scopeSet.add(parent);
            }
        }
        ArrayList scopes = new ArrayList(scopeSet);
        for (String scope : scopes) {
            this.scopeManager.destroyScope(scope);
        }
        this.scopeManager.finalizeScopes();
        this.previousTopKeyWithAssociatedScope = null;
    }

    public boolean hasService(@NonNull ScopeKey scopeKey, @NonNull String serviceTag) {
        return this.hasService(scopeKey.getScopeTag(), serviceTag);
    }

    @NonNull
    public <T> T getService(@NonNull ScopeKey scopeKey, @NonNull String serviceTag) {
        return this.getService(scopeKey.getScopeTag(), serviceTag);
    }

    public boolean hasService(@NonNull String scopeTag, @NonNull String serviceTag) {
        return this.scopeManager.hasService(scopeTag, serviceTag);
    }

    @NonNull
    public <T> T getService(@NonNull String scopeTag, @NonNull String serviceTag) {
        return this.scopeManager.getService(scopeTag, serviceTag);
    }

    public boolean hasScope(@NonNull String scopeTag) {
        return this.scopeManager.hasScope(scopeTag);
    }

    public boolean hasAlias(String scopeTag, String alias) {
        return this.scopeManager.hasAlias(scopeTag, alias);
    }

    public boolean canFindService(@NonNull String serviceTag) {
        return this.scopeManager.canFindService(serviceTag);
    }

    public boolean canFindFromScope(@NonNull String scopeTag, @NonNull String serviceTag) {
        return this.scopeManager.canFindFromScope(scopeTag, serviceTag, ScopeLookupMode.ALL);
    }

    public boolean canFindFromScope(@NonNull String scopeTag, @NonNull String serviceTag, @NonNull ScopeLookupMode lookupMode) {
        return this.scopeManager.canFindFromScope(scopeTag, serviceTag, lookupMode);
    }

    @NonNull
    public <T> T lookupService(@NonNull String serviceTag) {
        return this.scopeManager.lookupService(serviceTag);
    }

    @NonNull
    public List<String> findScopesForKey(@NonNull Object key, @NonNull ScopeLookupMode lookupMode) {
        Set<String> scopes = this.scopeManager.findScopesForKey(key, lookupMode);
        return Collections.unmodifiableList(new ArrayList<String>(scopes));
    }

    @NonNull
    public <T> T lookupFromScope(String scopeTag, String serviceTag) {
        return this.scopeManager.lookupFromScope(scopeTag, serviceTag, ScopeLookupMode.ALL);
    }

    @NonNull
    public <T> T lookupFromScope(String scopeTag, String serviceTag, ScopeLookupMode lookupMode) {
        return this.scopeManager.lookupFromScope(scopeTag, serviceTag, lookupMode);
    }

    @NonNull
    public SavedState getSavedState(@NonNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        if (!this.keyStateMap.containsKey(key)) {
            this.keyStateMap.put(key, SavedState.builder().setKey(key).build());
        }
        return this.keyStateMap.get(key);
    }

    public void persistViewToState(@Nullable View view) {
        if (view != null) {
            Object key = KeyContextWrapper.getKey(view.getContext());
            if (key == null) {
                throw new IllegalArgumentException("The view [" + view + "] contained no key in its context hierarchy. The view or its parent hierarchy should be inflated by a layout inflater from `stateChange.createContext(baseContext, key)`, or a KeyContextWrapper.");
            }
            SparseArray viewHierarchyState = new SparseArray();
            view.saveHierarchyState(viewHierarchyState);
            StateBundle bundle = null;
            if (view instanceof Bundleable) {
                bundle = ((Bundleable)view).toBundle();
            }
            SavedState previousSavedState = SavedState.builder().setKey(key).setViewHierarchyState((SparseArray<Parcelable>)viewHierarchyState).setViewBundle(bundle).build();
            this.keyStateMap.put(key, previousSavedState);
        }
    }

    public void restoreViewFromState(@NonNull View view) {
        if (view == null) {
            throw new IllegalArgumentException("You cannot restore state into null view!");
        }
        Object newKey = KeyContextWrapper.getKey(view.getContext());
        SavedState savedState = this.getSavedState(newKey);
        view.restoreHierarchyState(savedState.getViewHierarchyState());
        if (view instanceof Bundleable) {
            ((Bundleable)view).fromBundle(savedState.getViewBundle());
        }
    }

    public void addStateChangeCompletionListener(@NonNull CompletionListener stateChangeCompletionListener) {
        this.checkBackstack("A backstack must be set up before a state change completion listener is added to it.");
        if (stateChangeCompletionListener == null) {
            throw new IllegalArgumentException("StateChangeCompletionListener cannot be null!");
        }
        this.core.addCompletionListener(stateChangeCompletionListener);
    }

    public void removeStateChangeCompletionListener(@NonNull CompletionListener stateChangeCompletionListener) {
        this.checkBackstack("A backstack must be set up before a state change completion listener is removed from it.");
        if (stateChangeCompletionListener == null) {
            throw new IllegalArgumentException("StateChangeCompletionListener cannot be null!");
        }
        this.core.removeCompletionListener(stateChangeCompletionListener);
    }

    public void removeAllStateChangeCompletionListeners() {
        this.checkBackstack("A backstack must be set up before state change completion listeners are removed from it.");
        this.core.removeCompletionListeners();
    }

    @Override
    public void fromBundle(@Nullable StateBundle stateBundle) {
        this.checkBackstack("A backstack must be set up before it is restored!");
        if (stateBundle != null) {
            ArrayList savedStates;
            List<Object> keys = new ArrayList();
            ArrayList parcelledKeys = stateBundle.getParcelableArrayList(Backstack.getHistoryTag());
            if (parcelledKeys != null) {
                for (Parcelable parcelledKey : parcelledKeys) {
                    keys.add(this.keyParceler.fromParcelable(parcelledKey));
                }
            }
            if ((keys = this.keyFilter.filterHistory(new ArrayList<Object>(keys))) == null) {
                keys = Collections.emptyList();
            }
            if (!keys.isEmpty()) {
                this.core.setInitialParameters(keys);
            }
            if ((savedStates = stateBundle.getParcelableArrayList(Backstack.getStatesTag())) != null) {
                for (ParcelledState parcelledState : savedStates) {
                    Object key = this.keyParceler.fromParcelable(parcelledState.parcelableKey);
                    if (!keys.contains(key)) continue;
                    SavedState savedState = SavedState.builder().setKey(key).setViewHierarchyState(parcelledState.viewHierarchyState).setBundle(parcelledState.bundle).setViewBundle(parcelledState.viewBundle).build();
                    this.keyStateMap.put(savedState.getKey(), savedState);
                }
            }
            this.scopeManager.setRestoredStates(stateBundle.getBundle(SCOPES_TAG));
        }
    }

    private void checkBackstack(String message) {
        if (this.core == null) {
            throw new IllegalStateException(message);
        }
    }

    @Override
    @NonNull
    public StateBundle toBundle() {
        StateBundle stateBundle = new StateBundle();
        ArrayList<Parcelable> history = new ArrayList<Parcelable>();
        for (Object key : this.getHistory()) {
            history.add(this.keyParceler.toParcelable(key));
        }
        stateBundle.putParcelableArrayList(Backstack.getHistoryTag(), history);
        ArrayList<ParcelledState> states = new ArrayList<ParcelledState>();
        for (SavedState savedState : this.keyStateMap.values()) {
            ParcelledState parcelledState = new ParcelledState();
            parcelledState.parcelableKey = this.keyParceler.toParcelable(savedState.getKey());
            parcelledState.viewHierarchyState = savedState.getViewHierarchyState();
            parcelledState.bundle = savedState.getBundle();
            parcelledState.viewBundle = savedState.getViewBundle();
            states.add(parcelledState);
        }
        stateBundle.putParcelableArrayList(Backstack.getStatesTag(), states);
        stateBundle.putParcelable(Backstack.getScopesTag(), (Parcelable)this.scopeManager.saveStates());
        return stateBundle;
    }

    @MainThread
    public boolean hasStateChanger() {
        return this.core.hasStateChanger();
    }

    @MainThread
    public void removeStateChanger() {
        this.core.removeStateChanger();
    }

    @MainThread
    public void goTo(@NonNull Object newKey) {
        this.core.goTo(newKey);
    }

    @MainThread
    public void replaceTop(@NonNull Object newTop, int direction) {
        this.core.replaceTop(newTop, direction);
    }

    @MainThread
    public void goUp(@NonNull Object newKey) {
        this.core.goUp(newKey);
    }

    @MainThread
    public void goUp(@NonNull Object newKey, boolean fallbackToBack) {
        this.core.goUp(newKey, fallbackToBack);
    }

    @MainThread
    public void moveToTop(@NonNull Object newKey) {
        this.core.moveToTop(newKey);
    }

    @MainThread
    public void moveToTop(@NonNull Object newKey, boolean asReplace) {
        this.core.moveToTop(newKey, asReplace);
    }

    @MainThread
    public void jumpToRoot() {
        this.core.jumpToRoot();
    }

    @MainThread
    public void jumpToRoot(int direction) {
        this.core.jumpToRoot(direction);
    }

    @MainThread
    public void goUpChain(@NonNull List<?> parentChain) {
        this.core.goUpChain(parentChain);
    }

    @MainThread
    public void goUpChain(@NonNull List<?> parentChain, boolean fallbackToBack) {
        this.core.goUpChain(parentChain, fallbackToBack);
    }

    @MainThread
    public boolean goBack() {
        return this.core.goBack();
    }

    @MainThread
    public void forceClear() {
        this.core.forceClear();
    }

    @MainThread
    public void setHistory(@NonNull List<?> newHistory, int direction) {
        this.core.setHistory(newHistory, direction);
    }

    @NonNull
    public <K> K root() {
        return this.core.root();
    }

    @NonNull
    public <K> K top() {
        return this.core.top();
    }

    @NonNull
    public <K> K fromTop(int offset) {
        return this.core.fromTop(offset);
    }

    @NonNull
    public <K> History<K> getHistory() {
        return this.core.getHistory();
    }

    @NonNull
    public <K> History<K> getInitialKeys() {
        return this.core.getInitialKeys();
    }

    public boolean isStateChangePending() {
        return this.core.isStateChangePending();
    }

    public void addCompletionListener(@NonNull CompletionListener completionListener) {
        this.core.addCompletionListener(completionListener);
    }

    public void removeCompletionListener(@NonNull CompletionListener completionListener) {
        this.core.removeCompletionListener(completionListener);
    }

    public void removeCompletionListeners() {
        this.core.removeCompletionListeners();
    }

    @MainThread
    public void executePendingStateChange() {
        this.core.executePendingStateChange();
    }

    public static interface CompletionListener {
        public void stateChangeCompleted(@NonNull StateChange var1);
    }

    public static interface StateClearStrategy {
        public void clearStatesNotIn(@NonNull Map<Object, SavedState> var1, @NonNull StateChange var2);
    }
}

