/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.NonNull;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.Bundleable;
import com.zhuinden.simplestack.GlobalServices;
import com.zhuinden.simplestack.ScopeKey;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.simplestack.ServiceBinder;
import com.zhuinden.statebundle.StateBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ScopeManager {
    static final String GLOBAL_SCOPE_TAG = "__SIMPLE_STACK_INTERNAL_GLOBAL_SCOPE__";
    private static final GlobalServices EMPTY_GLOBAL_SERVICES = GlobalServices.builder().build();
    private final IdentityHashMap<Object, Set<String>> scopeEnteredServices = new IdentityHashMap();
    private final IdentityHashMap<Object, Set<String>> scopeActivatedServices = new IdentityHashMap();
    private final IdentityHashMap<Object, Integer> untrackEventInvocationTracker = new IdentityHashMap();
    private boolean isGlobalScopePendingActivation = true;
    private GlobalServices globalServices = EMPTY_GLOBAL_SERVICES;
    private ScopedServices scopedServices = new AssertingScopedServices();
    private Backstack backstack;
    private final Map<String, Map<String, Object>> scopes = new LinkedHashMap<String, Map<String, Object>>();
    private final StateBundle rootBundle = new StateBundle();
    private List<Object> latestState = null;
    private boolean isFinalized = false;

    void activateGlobalScope() {
        this.notifyScopeActivation(GLOBAL_SCOPE_TAG, this.globalServices.getServices());
    }

    void deactivateGlobalScope() {
        this.notifyScopeDeactivation(GLOBAL_SCOPE_TAG, this.globalServices.getServices());
    }

    ScopeManager() {
    }

    void setBackstack(Backstack backstack) {
        this.backstack = backstack;
    }

    Backstack getBackstack() {
        return this.backstack;
    }

    private List<String> getActiveScopesReverse() {
        ArrayList<String> activeScopes = new ArrayList<String>(this.scopes.keySet());
        Collections.reverse(activeScopes);
        return activeScopes;
    }

    void setScopedServices(ScopedServices scopedServices) {
        this.scopedServices = scopedServices;
    }

    void setGlobalServices(GlobalServices globalServices) {
        this.globalServices = globalServices;
    }

    private void buildGlobalScope() {
        if (!this.scopes.containsKey(GLOBAL_SCOPE_TAG)) {
            Map<String, Object> scope = this.globalServices.getServices();
            this.scopes.put(GLOBAL_SCOPE_TAG, scope);
            this.restoreAndNotifyServices(GLOBAL_SCOPE_TAG, scope);
        }
    }

    private void buildScope(Object key, String scopeTag) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag provided by scope key cannot be null!");
        }
        if (!this.scopes.containsKey(scopeTag)) {
            LinkedHashMap<String, Object> scope = new LinkedHashMap<String, Object>();
            this.scopes.put(scopeTag, scope);
            this.scopedServices.bindServices(new ServiceBinder(this, key, scopeTag, scope));
            this.restoreAndNotifyServices(scopeTag, scope);
        }
    }

    private void restoreAndNotifyServices(String scopeTag, Map<String, Object> scope) {
        for (Map.Entry<String, Object> serviceEntry : scope.entrySet()) {
            String serviceTag = serviceEntry.getKey();
            Object service = serviceEntry.getValue();
            if (this.isServiceNotRegistered(service)) {
                StateBundle scopeBundle;
                if (this.rootBundle.containsKey(scopeTag) && service instanceof Bundleable && (scopeBundle = this.rootBundle.getBundle(scopeTag)) != null && scopeBundle.containsKey(serviceTag)) {
                    ((Bundleable)service).fromBundle(scopeBundle.getBundle(serviceTag));
                }
                if (service instanceof ScopedServices.Registered) {
                    ((ScopedServices.Registered)service).onServiceRegistered();
                }
            }
            if (!this.isServiceNotTrackedInScope(this.scopeEnteredServices, service, scopeTag)) continue;
            this.trackServiceInScope(this.scopeEnteredServices, service, scopeTag);
        }
    }

    private boolean isServiceNotRegistered(Object service) {
        return !this.scopeEnteredServices.containsKey(service) || this.scopeEnteredServices.get(service).isEmpty();
    }

    private boolean isServiceNotActivated(Object service) {
        return !this.scopeActivatedServices.containsKey(service) || this.scopeActivatedServices.get(service).isEmpty();
    }

    private boolean isServiceNotTrackedInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        return !scopeEventTracker.containsKey(service) || !scopeEventTracker.get(service).contains(scopeTag);
    }

    private void trackServiceInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        Set<String> trackedScopes = scopeEventTracker.get(service);
        if (trackedScopes == null) {
            trackedScopes = new LinkedHashSet<String>();
            scopeEventTracker.put(service, trackedScopes);
        }
        trackedScopes.add(scopeTag);
    }

    private void untrackServiceInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        Set<String> trackedScopes = scopeEventTracker.get(service);
        trackedScopes.remove(scopeTag);
        if (trackedScopes.isEmpty()) {
            scopeEventTracker.remove(service);
        }
    }

    boolean isFinalized() {
        return this.isFinalized;
    }

    void finalizeScopes() {
        this.isFinalized = true;
        this.destroyScope(GLOBAL_SCOPE_TAG);
        this.latestState = null;
    }

    void buildScopes(List<Object> newState) {
        if (this.isFinalized) {
            this.isFinalized = false;
            this.isGlobalScopePendingActivation = true;
        }
        if (this.latestState == null) {
            this.buildGlobalScope();
        }
        this.latestState = newState;
        for (Object key : newState) {
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                for (String parent : child.getParentScopes()) {
                    this.buildScope(key, parent);
                }
            }
            if (!(key instanceof ScopeKey)) continue;
            ScopeKey scopeKey = (ScopeKey)key;
            String scopeTag = scopeKey.getScopeTag();
            this.buildScope(key, scopeTag);
        }
    }

    void clearScopesNotIn(List<Object> newState) {
        LinkedHashSet<String> currentScopes = new LinkedHashSet<String>();
        currentScopes.add(GLOBAL_SCOPE_TAG);
        for (Object key : newState) {
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                currentScopes.addAll(child.getParentScopes());
            }
            if (!(key instanceof ScopeKey)) continue;
            ScopeKey scopeKey = (ScopeKey)key;
            currentScopes.add(scopeKey.getScopeTag());
        }
        List<String> scopeSet = this.getActiveScopesReverse();
        for (String activeScope : scopeSet) {
            if (currentScopes.contains(activeScope)) continue;
            this.destroyScope(activeScope);
        }
    }

    void destroyScope(String scopeTag) {
        if (this.scopes.containsKey(scopeTag)) {
            Map<String, Object> serviceMap = this.scopes.remove(scopeTag);
            this.destroyServicesAndRemoveState(scopeTag, serviceMap);
        }
    }

    private void destroyServicesAndRemoveState(String scopeTag, Map<String, Object> serviceMap) {
        ArrayList<Object> services = new ArrayList<Object>(serviceMap.values());
        Collections.reverse(services);
        this.untrackEventInvocationTracker.clear();
        for (Object e : services) {
            if (!this.isServiceNotTrackedInScope(this.scopeEnteredServices, e, scopeTag)) {
                this.untrackServiceInScope(this.scopeEnteredServices, e, scopeTag);
            }
            if (!this.isServiceNotRegistered(e) || !(e instanceof ScopedServices.Registered) || this.untrackEventInvocationTracker.containsKey(e)) continue;
            this.untrackEventInvocationTracker.put(e, 1);
            ((ScopedServices.Registered)e).onServiceUnregistered();
        }
        this.rootBundle.remove(scopeTag);
    }

    void dispatchActivation(@NonNull Set<String> scopesToDeactivate, @NonNull Set<String> scopesToActivate) {
        if (this.isGlobalScopePendingActivation) {
            this.isGlobalScopePendingActivation = false;
            this.activateGlobalScope();
        }
        for (String newScopeTag : scopesToActivate) {
            if (!this.scopes.containsKey(newScopeTag)) {
                throw new AssertionError((Object)"The new scope should exist, but it doesn't! This shouldn't happen. If you see this error, this functionality is broken.");
            }
            Map<String, Object> newServiceMap = this.scopes.get(newScopeTag);
            this.notifyScopeActivation(newScopeTag, newServiceMap);
        }
        for (String previousScopeTag : scopesToDeactivate) {
            if (!this.scopes.containsKey(previousScopeTag)) {
                throw new AssertionError((Object)"The previous scope should exist, but it doesn't! This shouldn't happen. If you see this error, this functionality is broken.");
            }
            Map<String, Object> previousServiceMap = this.scopes.get(previousScopeTag);
            this.notifyScopeDeactivation(previousScopeTag, previousServiceMap);
        }
    }

    private void notifyScopeActivation(String newScopeTag, Map<String, Object> newServiceMap) {
        for (Object service : newServiceMap.values()) {
            if (this.isServiceNotActivated(service) && service instanceof ScopedServices.Activated) {
                ((ScopedServices.Activated)service).onServiceActive();
            }
            if (!this.isServiceNotTrackedInScope(this.scopeActivatedServices, service, newScopeTag)) continue;
            this.trackServiceInScope(this.scopeActivatedServices, service, newScopeTag);
        }
    }

    private void notifyScopeDeactivation(String previousScopeTag, Map<String, Object> previousServiceMap) {
        ArrayList<Object> previousServices = new ArrayList<Object>(previousServiceMap.values());
        Collections.reverse(previousServices);
        this.untrackEventInvocationTracker.clear();
        for (Object e : previousServices) {
            if (!this.isServiceNotTrackedInScope(this.scopeActivatedServices, e, previousScopeTag)) {
                this.untrackServiceInScope(this.scopeActivatedServices, e, previousScopeTag);
            }
            if (!this.isServiceNotActivated(e) || !(e instanceof ScopedServices.Activated) || this.untrackEventInvocationTracker.containsKey(e)) continue;
            this.untrackEventInvocationTracker.put(e, 1);
            ((ScopedServices.Activated)e).onServiceInactive();
        }
    }

    StateBundle saveStates() {
        StateBundle rootBundle = new StateBundle();
        for (Map.Entry<String, Map<String, Object>> scopeSet : this.scopes.entrySet()) {
            String scopeKey = scopeSet.getKey();
            Map<String, Object> services = scopeSet.getValue();
            StateBundle scopeBundle = new StateBundle();
            for (Map.Entry<String, Object> serviceEntry : services.entrySet()) {
                String serviceTag = serviceEntry.getKey();
                Object service = serviceEntry.getValue();
                if (!(service instanceof Bundleable)) continue;
                scopeBundle.putBundle(serviceTag, ((Bundleable)service).toBundle());
            }
            rootBundle.putBundle(scopeKey, scopeBundle);
        }
        return rootBundle;
    }

    void setRestoredStates(StateBundle rootBundle) {
        if (rootBundle != null) {
            this.rootBundle.putAll(rootBundle);
        }
    }

    boolean hasService(@NonNull String scopeTag, @NonNull String serviceTag) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        if (!this.scopes.containsKey(scopeTag)) {
            return false;
        }
        Map<String, Object> services = this.scopes.get(scopeTag);
        return services.containsKey(serviceTag);
    }

    @NonNull
    <T> T getService(@NonNull String scopeTag, @NonNull String serviceTag) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        if (!this.scopes.containsKey(scopeTag)) {
            throw new IllegalArgumentException("The specified scope with tag [" + scopeTag + "] does not exist!");
        }
        Map<String, Object> services = this.scopes.get(scopeTag);
        if (!services.containsKey(serviceTag)) {
            throw new IllegalArgumentException("The specified service with tag [" + serviceTag + "] does not exist in scope [" + scopeTag + "]! Did you accidentally try to use the same scope tag with different services?");
        }
        return (T)services.get(serviceTag);
    }

    boolean hasScope(@NonNull String scopeTag) {
        ScopeManager.checkScopeTag(scopeTag);
        return this.scopes.containsKey(scopeTag);
    }

    @NonNull
    Set<String> findScopesForKey(@NonNull Object key, @NonNull ScopeLookupMode lookupMode) {
        ScopeManager.checkKey(key);
        ScopeManager.checkScopeLookupMode(lookupMode);
        if (lookupMode == ScopeLookupMode.ALL) {
            return this.findScopesForKeyAll(key);
        }
        if (lookupMode == ScopeLookupMode.EXPLICIT) {
            return this.findScopesForKeyExplicit(key);
        }
        throw new AssertionError((Object)"Mode was not handled.");
    }

    @NonNull
    private Set<String> findScopesForKeyAll(Object targetKey) {
        if (this.latestState == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> activeScopes = new LinkedHashSet<String>();
        boolean isScopeFound = false;
        for (int i = this.latestState.size() - 1; i >= 0; --i) {
            Object key = this.latestState.get(i);
            if (targetKey.equals(key)) {
                isScopeFound = true;
            }
            if (!isScopeFound) continue;
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                String currentScope = scopeKey.getScopeTag();
                activeScopes.add(currentScope);
            }
            if (!(key instanceof ScopeKey.Child)) continue;
            ScopeKey.Child child = (ScopeKey.Child)key;
            ScopeManager.checkParentScopes(child);
            List<String> parentScopes = child.getParentScopes();
            for (int j = parentScopes.size() - 1; j >= 0; --j) {
                String currentScope = parentScopes.get(j);
                activeScopes.add(currentScope);
            }
        }
        if (!this.isFinalized && !this.globalServices.getServices().isEmpty()) {
            activeScopes.add(GLOBAL_SCOPE_TAG);
        }
        return Collections.unmodifiableSet(activeScopes);
    }

    @NonNull
    private Set<String> findScopesForKeyExplicit(Object targetKey) {
        if (this.latestState == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> activeScopes = new LinkedHashSet<String>();
        boolean isScopeFound = false;
        for (int i = this.latestState.size() - 1; i >= 0; --i) {
            Object key = this.latestState.get(i);
            if (targetKey.equals(key)) {
                isScopeFound = true;
            }
            if (!isScopeFound) continue;
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                String currentScope = scopeKey.getScopeTag();
                activeScopes.add(currentScope);
            }
            if (!(key instanceof ScopeKey.Child)) break;
            ScopeKey.Child child = (ScopeKey.Child)key;
            ScopeManager.checkParentScopes(child);
            List<String> parentScopes = child.getParentScopes();
            for (int j = parentScopes.size() - 1; j >= 0; --j) {
                String currentScope = parentScopes.get(j);
                activeScopes.add(currentScope);
            }
            break;
        }
        if (!this.isFinalized && !this.globalServices.getServices().isEmpty()) {
            activeScopes.add(GLOBAL_SCOPE_TAG);
        }
        return Collections.unmodifiableSet(activeScopes);
    }

    boolean canFindFromScope(String scopeTag, String serviceTag, ScopeLookupMode lookupMode) {
        ScopeManager.checkServiceTag(serviceTag);
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkScopeLookupMode(lookupMode);
        if (lookupMode == ScopeLookupMode.ALL) {
            return this.canFindFromScopeAll(scopeTag, serviceTag);
        }
        if (lookupMode == ScopeLookupMode.EXPLICIT) {
            return this.canFindFromScopeExplicit(scopeTag, serviceTag);
        }
        throw new AssertionError((Object)"Mode was not handled.");
    }

    private boolean canFindFromScopeExplicit(String scopeTag, String serviceTag) {
        if (this.latestState == null) {
            return false;
        }
        LinkedHashSet<String> activeScopes = new LinkedHashSet<String>();
        List<Object> latestState = this.latestState;
        boolean isScopeFound = false;
        for (int i = latestState.size() - 1; i >= 0; --i) {
            Object key = latestState.get(i);
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                String currentScope = scopeKey.getScopeTag();
                if (currentScope.equals(scopeTag)) {
                    isScopeFound = true;
                }
                if (isScopeFound) {
                    activeScopes.add(currentScope);
                }
            }
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                List<String> parentScopes = child.getParentScopes();
                for (int j = parentScopes.size() - 1; j >= 0; --j) {
                    String currentScope = parentScopes.get(j);
                    if (currentScope.equals(scopeTag)) {
                        isScopeFound = true;
                    }
                    if (!isScopeFound) continue;
                    activeScopes.add(currentScope);
                }
            }
            if (isScopeFound) break;
        }
        for (String scope : activeScopes) {
            if (!this.hasService(scope, serviceTag)) continue;
            return true;
        }
        return !this.isFinalized && this.globalServices.hasService(serviceTag);
    }

    private boolean canFindFromScopeAll(String scopeTag, String serviceTag) {
        if (this.latestState == null) {
            return false;
        }
        LinkedHashSet<String> activeScopes = new LinkedHashSet<String>();
        List<Object> latestState = this.latestState;
        boolean isScopeFound = false;
        for (int i = latestState.size() - 1; i >= 0; --i) {
            Object key = latestState.get(i);
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                String currentScope = scopeKey.getScopeTag();
                if (currentScope.equals(scopeTag)) {
                    isScopeFound = true;
                }
                if (isScopeFound) {
                    activeScopes.add(currentScope);
                }
            }
            if (!(key instanceof ScopeKey.Child)) continue;
            ScopeKey.Child child = (ScopeKey.Child)key;
            ScopeManager.checkParentScopes(child);
            List<String> parentScopes = child.getParentScopes();
            for (int j = parentScopes.size() - 1; j >= 0; --j) {
                String currentScope = parentScopes.get(j);
                if (currentScope.equals(scopeTag)) {
                    isScopeFound = true;
                }
                if (!isScopeFound) continue;
                activeScopes.add(currentScope);
            }
        }
        for (String scope : activeScopes) {
            if (!this.hasService(scope, serviceTag)) continue;
            return true;
        }
        return !this.isFinalized && this.globalServices.hasService(serviceTag);
    }

    <T> T lookupFromScope(String scopeTag, String serviceTag, ScopeLookupMode lookupMode) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        ScopeManager.checkScopeLookupMode(lookupMode);
        if (lookupMode == ScopeLookupMode.ALL) {
            return this.lookupFromScopeAll(scopeTag, serviceTag);
        }
        if (lookupMode == ScopeLookupMode.EXPLICIT) {
            return this.lookupFromScopeExplicit(scopeTag, serviceTag);
        }
        throw new AssertionError((Object)"Mode was not handled.");
    }

    private <T> T lookupFromScopeExplicit(String scopeTag, String serviceTag) {
        this.verifyStackIsInitialized();
        LinkedHashSet<String> activeScopes = new LinkedHashSet<String>();
        List<Object> latestState = this.latestState;
        boolean isScopeFound = false;
        for (int i = latestState.size() - 1; i >= 0; --i) {
            Object key = latestState.get(i);
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                String currentScope = scopeKey.getScopeTag();
                if (currentScope.equals(scopeTag)) {
                    isScopeFound = true;
                }
                if (isScopeFound) {
                    activeScopes.add(currentScope);
                }
            }
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                List<String> parentScopes = child.getParentScopes();
                for (int j = parentScopes.size() - 1; j >= 0; --j) {
                    String currentScope = parentScopes.get(j);
                    if (currentScope.equals(scopeTag)) {
                        isScopeFound = true;
                    }
                    if (!isScopeFound) continue;
                    activeScopes.add(currentScope);
                }
            }
            if (isScopeFound) break;
        }
        for (String scope : activeScopes) {
            if (!this.hasService(scope, serviceTag)) continue;
            return this.getService(scope, serviceTag);
        }
        if (!this.isFinalized && this.globalServices.hasService(serviceTag)) {
            return this.globalServices.getService(serviceTag);
        }
        throw new IllegalStateException("The service [" + serviceTag + "] does not exist in any scope that is accessible from [" + scopeTag + "], scopes are [" + Arrays.toString(activeScopes.toArray()) + "]!");
    }

    private <T> T lookupFromScopeAll(String scopeTag, String serviceTag) {
        this.verifyStackIsInitialized();
        LinkedHashSet<String> activeScopes = new LinkedHashSet<String>();
        List<Object> latestState = this.latestState;
        boolean isScopeFound = false;
        for (int i = latestState.size() - 1; i >= 0; --i) {
            Object key = latestState.get(i);
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                String currentScope = scopeKey.getScopeTag();
                if (currentScope.equals(scopeTag)) {
                    isScopeFound = true;
                }
                if (isScopeFound) {
                    activeScopes.add(currentScope);
                }
            }
            if (!(key instanceof ScopeKey.Child)) continue;
            ScopeKey.Child child = (ScopeKey.Child)key;
            ScopeManager.checkParentScopes(child);
            List<String> parentScopes = child.getParentScopes();
            for (int j = parentScopes.size() - 1; j >= 0; --j) {
                String currentScope = parentScopes.get(j);
                if (currentScope.equals(scopeTag)) {
                    isScopeFound = true;
                }
                if (!isScopeFound) continue;
                activeScopes.add(currentScope);
            }
        }
        for (String scope : activeScopes) {
            if (!this.hasService(scope, serviceTag)) continue;
            return this.getService(scope, serviceTag);
        }
        if (!this.isFinalized && this.globalServices.hasService(serviceTag)) {
            return this.globalServices.getService(serviceTag);
        }
        throw new IllegalStateException("The service [" + serviceTag + "] does not exist in any scope that is accessible from [" + scopeTag + "], scopes are [" + Arrays.toString(activeScopes.toArray()) + "]!");
    }

    boolean canFindService(@NonNull String serviceTag) {
        ScopeManager.checkServiceTag(serviceTag);
        List<String> activeScopes = this.getActiveScopesReverse();
        for (String scopeTag : activeScopes) {
            if (!this.hasService(scopeTag, serviceTag)) continue;
            return true;
        }
        return !this.isFinalized && this.globalServices.hasService(serviceTag);
    }

    @NonNull
    <T> T lookupService(@NonNull String serviceTag) {
        ScopeManager.checkServiceTag(serviceTag);
        this.verifyStackIsInitialized();
        LinkedHashSet<String> activeScopes = new LinkedHashSet<String>();
        List<Object> latestState = this.latestState;
        for (int i = latestState.size() - 1; i >= 0; --i) {
            Object key = latestState.get(i);
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                activeScopes.add(scopeKey.getScopeTag());
            }
            if (!(key instanceof ScopeKey.Child)) continue;
            ScopeKey.Child child = (ScopeKey.Child)key;
            ScopeManager.checkParentScopes(child);
            List<String> parentScopes = child.getParentScopes();
            for (int j = parentScopes.size() - 1; j >= 0; --j) {
                activeScopes.add(parentScopes.get(j));
            }
        }
        for (String scopeTag : activeScopes) {
            if (!this.hasService(scopeTag, serviceTag)) continue;
            return this.getService(scopeTag, serviceTag);
        }
        if (!this.isFinalized && this.globalServices.hasService(serviceTag)) {
            return this.globalServices.getService(serviceTag);
        }
        throw new IllegalStateException("The service [" + serviceTag + "] does not exist in any scopes, which are " + Arrays.toString(activeScopes.toArray()) + "! Is the scope tag registered via a ScopeKey? If yes, make sure the StateChanger has been set by this time, and that you've bound and are trying to lookup the service with the correct service tag. Otherwise, it is likely that the scope you intend to inherit the service from does not exist.");
    }

    private void verifyStackIsInitialized() {
        if (this.latestState == null) {
            throw new IllegalStateException("Cannot lookup from an empty stack.");
        }
    }

    private static void checkKey(@NonNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
    }

    private static void checkScopeTag(@NonNull String scopeTag) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag cannot be null!");
        }
    }

    private static void checkServiceTag(@NonNull String serviceTag) {
        if (serviceTag == null) {
            throw new IllegalArgumentException("Service tag cannot be null!");
        }
    }

    static void checkParentScopes(ScopeKey.Child child) {
        if (child.getParentScopes() == null) {
            throw new IllegalArgumentException("Parent scopes cannot be null!");
        }
    }

    private static void checkScopeLookupMode(ScopeLookupMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null!");
        }
    }

    static class AssertingScopedServices
    implements ScopedServices {
        AssertingScopedServices() {
        }

        @Override
        public void bindServices(@NonNull ServiceBinder serviceBinder) {
            throw new IllegalStateException("No scoped services are defined. To create scoped services, an instance of ScopedServices must be provided to configure the services that are available in a given scope.");
        }
    }
}

