/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.zhuinden.statebundle.StateBundle;

public class SavedState {
    private Object key;
    private SparseArray<Parcelable> viewHierarchyState;
    private StateBundle bundle;

    private SavedState() {
    }

    @NonNull
    public Object getKey() {
        return this.key;
    }

    @NonNull
    public SparseArray<Parcelable> getViewHierarchyState() {
        return this.viewHierarchyState;
    }

    public void setViewHierarchyState(SparseArray<Parcelable> viewHierarchyState) {
        this.viewHierarchyState = viewHierarchyState;
    }

    @Nullable
    public StateBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(@Nullable StateBundle bundle) {
        this.bundle = bundle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavedState)) {
            return false;
        }
        return ((SavedState)obj).getKey().equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public static class Builder {
        private Object key;
        private SparseArray<Parcelable> viewHierarchyState = new SparseArray();
        private StateBundle bundle;

        Builder() {
        }

        public Builder setKey(@NonNull Object key) {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            this.key = key;
            return this;
        }

        public Builder setViewHierarchyState(@NonNull SparseArray<Parcelable> viewHierarchyState) {
            if (viewHierarchyState == null) {
                throw new IllegalArgumentException("Provided sparse array for view hierarchy state cannot be null");
            }
            this.viewHierarchyState = viewHierarchyState;
            return this;
        }

        public Builder setBundle(@Nullable StateBundle bundle) {
            this.bundle = bundle;
            return this;
        }

        public SavedState build() {
            if (this.key == null) {
                throw new IllegalStateException("You cannot create a SavedState without associating a Key with it.");
            }
            SavedState savedState = new SavedState();
            savedState.key = this.key;
            savedState.viewHierarchyState = this.viewHierarchyState;
            savedState.bundle = this.bundle;
            return savedState;
        }
    }
}

