/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack.navigator.changehandlers;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.zhuinden.simplestack.navigator.ViewChangeHandler;
import com.zhuinden.simplestack.navigator.changehandlers.ViewUtils;

@TargetApi(value=11)
public abstract class AnimatorViewChangeHandler
implements ViewChangeHandler {
    @Override
    public void performViewChange(final @NonNull ViewGroup container, final @NonNull View previousView, final @NonNull View newView, final int direction, final @NonNull ViewChangeHandler.CompletionCallback completionCallback) {
        container.addView(newView);
        ViewUtils.waitForMeasure(newView, new ViewUtils.OnMeasuredCallback(){

            @Override
            public void onMeasured(View view, int width, int height) {
                AnimatorViewChangeHandler.this.runAnimation(previousView, newView, direction, new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        container.removeView(previousView);
                        completionCallback.onCompleted();
                    }
                });
            }
        });
    }

    private void runAnimation(View previousView, View newView, int direction, AnimatorListenerAdapter animatorListenerAdapter) {
        Animator animator = this.createAnimator(previousView, newView, direction);
        animator.addListener((Animator.AnimatorListener)animatorListenerAdapter);
        animator.start();
    }

    protected abstract Animator createAnimator(@NonNull View var1, @NonNull View var2, int var3);
}

