/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack.navigator;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.BackstackManager;
import com.zhuinden.simplestack.DefaultKeyParceler;
import com.zhuinden.simplestack.DefaultStateClearStrategy;
import com.zhuinden.simplestack.KeyParceler;
import com.zhuinden.simplestack.SavedState;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.simplestack.navigator.BackstackHost;
import com.zhuinden.simplestack.navigator.DefaultStateChanger;
import java.util.List;

@TargetApi(value=11)
public class Navigator {
    private Navigator() {
    }

    public static Installer configure() {
        return new Installer();
    }

    public static void install(@NonNull Activity activity, @NonNull ViewGroup container, @NonNull List<Object> initialKeys) {
        Navigator.configure().install(activity, container, initialKeys);
    }

    private static Backstack install(Installer installer, @NonNull Activity activity, @NonNull ViewGroup container, @NonNull List<Object> initialKeys) {
        if (activity == null) {
            throw new IllegalArgumentException("Activity cannot be null!");
        }
        if (container == null) {
            throw new IllegalArgumentException("State changer cannot be null!");
        }
        if (initialKeys == null || initialKeys.isEmpty()) {
            throw new IllegalArgumentException("Initial keys cannot be null!");
        }
        BackstackHost backstackHost = Navigator.findBackstackHost(activity);
        if (backstackHost == null) {
            backstackHost = new BackstackHost();
            activity.getFragmentManager().beginTransaction().add((Fragment)backstackHost, "NAVIGATOR_BACKSTACK_HOST").commit();
            activity.getFragmentManager().executePendingTransactions();
        }
        backstackHost.stateChanger = installer.stateChanger;
        backstackHost.keyParceler = installer.keyParceler;
        backstackHost.stateClearStrategy = installer.stateClearStrategy;
        backstackHost.shouldPersistContainerChild = installer.shouldPersistContainerChild;
        backstackHost.container = container;
        backstackHost.initialKeys = initialKeys;
        return backstackHost.initialize(installer.isInitializeDeferred);
    }

    public static void executeDeferredInitialization(Context context) {
        Activity activity = Navigator.findActivity(context);
        BackstackHost backstackHost = Navigator.findBackstackHost(activity);
        backstackHost.initialize(false);
    }

    public static Backstack getBackstack(Context context) {
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        return backstackHost.getBackstack();
    }

    public static boolean onBackPressed(Context context) {
        return Navigator.getBackstack(context).goBack();
    }

    public static BackstackManager getManager(Context context) {
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        return backstackHost.getBackstackManager();
    }

    public static void persistViewToState(@Nullable View view) {
        if (view != null) {
            Context context = view.getContext();
            BackstackHost backstackHost = Navigator.getBackstackHost(context);
            backstackHost.getBackstackManager().persistViewToState(view);
        }
    }

    public static void restoreViewFromState(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("You cannot restore state into null view!");
        }
        Context context = view.getContext();
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        backstackHost.getBackstackManager().restoreViewFromState(view);
    }

    public static SavedState getSavedState(@NonNull Context context, @NonNull Object key) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        return backstackHost.getBackstackManager().getSavedState(key);
    }

    private static BackstackHost findBackstackHost(Activity activity) {
        return (BackstackHost)activity.getFragmentManager().findFragmentByTag("NAVIGATOR_BACKSTACK_HOST");
    }

    private static Activity findActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        ContextWrapper contextWrapper = (ContextWrapper)context;
        Context baseContext = contextWrapper.getBaseContext();
        if (baseContext == null) {
            throw new IllegalStateException("Activity was not found as base context of view!");
        }
        return Navigator.findActivity(baseContext);
    }

    private static BackstackHost getBackstackHost(Context context) {
        Activity activity = Navigator.findActivity(context);
        return Navigator.findBackstackHost(activity);
    }

    @TargetApi(value=11)
    public static class Installer {
        StateChanger stateChanger;
        BackstackManager.StateClearStrategy stateClearStrategy = new DefaultStateClearStrategy();
        KeyParceler keyParceler = new DefaultKeyParceler();
        boolean isInitializeDeferred = false;
        boolean shouldPersistContainerChild = true;

        public Installer setStateChanger(@NonNull StateChanger stateChanger) {
            if (stateChanger == null) {
                throw new IllegalArgumentException("If set, StateChanger cannot be null!");
            }
            this.stateChanger = stateChanger;
            return this;
        }

        public Installer setKeyParceler(@NonNull KeyParceler keyParceler) {
            if (keyParceler == null) {
                throw new IllegalArgumentException("If set, KeyParceler cannot be null!");
            }
            this.keyParceler = keyParceler;
            return this;
        }

        public Installer setStateClearStrategy(@NonNull BackstackManager.StateClearStrategy stateClearStrategy) {
            if (stateClearStrategy == null) {
                throw new IllegalArgumentException("If set, StateClearStrategy cannot be null!");
            }
            this.stateClearStrategy = stateClearStrategy;
            return this;
        }

        public Installer setDeferredInitialization(boolean isInitializeDeferred) {
            this.isInitializeDeferred = isInitializeDeferred;
            return this;
        }

        public Installer setShouldPersistContainerChild(boolean shouldPersistContainerChild) {
            this.shouldPersistContainerChild = shouldPersistContainerChild;
            return this;
        }

        public Backstack install(@NonNull Activity activity, @NonNull ViewGroup container, @NonNull List<Object> initialKeys) {
            if (this.stateChanger == null) {
                this.stateChanger = DefaultStateChanger.create((Context)activity, container);
            }
            return Navigator.install(this, activity, container, initialKeys);
        }
    }
}

