/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack.navigator;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.simplestack.navigator.Navigator;
import com.zhuinden.simplestack.navigator.StateKey;
import com.zhuinden.simplestack.navigator.ViewChangeHandler;
import com.zhuinden.simplestack.navigator.changehandlers.NoOpViewChangeHandler;

@TargetApi(value=11)
public final class DefaultStateChanger
implements StateChanger {
    private static final NoOpViewChangeHandler NO_OP_VIEW_CHANGE_HANDLER = new NoOpViewChangeHandler();
    private Context baseContext;
    private ViewGroup container;
    private StateChanger externalStateChanger;
    private ViewChangeCompletionListener viewChangeCompletionListener;
    private StatePersistenceStrategy statePersistenceStrategy;

    public static Configurer configure() {
        return new Configurer();
    }

    public static DefaultStateChanger create(Context baseContext, ViewGroup container) {
        return new DefaultStateChanger(baseContext, container, null, null, null);
    }

    DefaultStateChanger(@NonNull Context baseContext, @NonNull ViewGroup container, @Nullable StateChanger externalStateChanger, @Nullable ViewChangeCompletionListener viewChangeCompletionListener, @Nullable StatePersistenceStrategy statePersistenceStrategy) {
        if (baseContext == null) {
            throw new NullPointerException("baseContext cannot be null");
        }
        if (container == null) {
            throw new NullPointerException("container cannot be null");
        }
        this.baseContext = baseContext;
        this.container = container;
        if (externalStateChanger == null) {
            externalStateChanger = new NoOpStateChanger();
        }
        this.externalStateChanger = externalStateChanger;
        if (viewChangeCompletionListener == null) {
            viewChangeCompletionListener = new NoOpViewChangeCompletionListener();
        }
        this.viewChangeCompletionListener = viewChangeCompletionListener;
        if (statePersistenceStrategy == null) {
            statePersistenceStrategy = new NavigatorStatePersistenceStrategy();
        }
        this.statePersistenceStrategy = statePersistenceStrategy;
    }

    private void finishStateChange(StateChange stateChange, ViewGroup container, View previousView, View newView, final StateChanger.Callback completionCallback) {
        this.viewChangeCompletionListener.handleViewChangeComplete(stateChange, container, previousView, newView, new ViewChangeCompletionListener.Callback(){

            @Override
            public void viewChangeComplete() {
                completionCallback.stateChangeComplete();
            }
        });
    }

    @Override
    public final void handleStateChange(final StateChange stateChange, final StateChanger.Callback completionCallback) {
        this.externalStateChanger.handleStateChange(stateChange, new StateChanger.Callback(){

            @Override
            public void stateChangeComplete() {
                if (stateChange.topNewState().equals(stateChange.topPreviousState())) {
                    completionCallback.stateChangeComplete();
                    return;
                }
                StateKey previousKey = (StateKey)stateChange.topPreviousState();
                StateKey newKey = (StateKey)stateChange.topNewState();
                DefaultStateChanger.this.performViewChange(previousKey, newKey, stateChange, completionCallback);
            }
        });
    }

    public final <T extends StateKey, U extends StateKey> void performViewChange(T previousKey, U newKey, StateChange stateChange, StateChanger.Callback completionCallback) {
        this.performViewChange(previousKey, newKey, stateChange, stateChange.getDirection(), completionCallback);
    }

    public final <T extends StateKey, U extends StateKey> void performViewChange(T previousKey, U newKey, final StateChange stateChange, int direction, final StateChanger.Callback completionCallback) {
        final View previousView = this.container.getChildAt(0);
        if (previousView != null && previousKey != null) {
            this.statePersistenceStrategy.persistViewToState(previousKey, previousView);
        }
        Context newContext = stateChange.createContext(this.baseContext, newKey);
        final View newView = LayoutInflater.from((Context)newContext).inflate(newKey.layout(), this.container, false);
        this.statePersistenceStrategy.restoreViewFromState(newKey, newView);
        if (previousView == null) {
            this.container.addView(newView);
            this.finishStateChange(stateChange, this.container, previousView, newView, completionCallback);
        } else {
            ViewChangeHandler viewChangeHandler = direction == 1 ? newKey.viewChangeHandler() : (previousKey != null && direction == -1 ? previousKey.viewChangeHandler() : NO_OP_VIEW_CHANGE_HANDLER);
            viewChangeHandler.performViewChange(this.container, previousView, newView, direction, new ViewChangeHandler.CompletionCallback(){

                @Override
                public void onCompleted() {
                    DefaultStateChanger.this.finishStateChange(stateChange, DefaultStateChanger.this.container, previousView, newView, completionCallback);
                }
            });
        }
    }

    public static class Configurer {
        StateChanger externalStateChanger = null;
        ViewChangeCompletionListener viewChangeCompletionListener = null;
        StatePersistenceStrategy statePersistenceStrategy = null;

        private Configurer() {
        }

        public Configurer setExternalStateChanger(@NonNull StateChanger stateChanger) {
            if (stateChanger == null) {
                throw new NullPointerException("If set, external state changer cannot be null!");
            }
            this.externalStateChanger = stateChanger;
            return this;
        }

        public Configurer setViewChangeCompletionListener(@NonNull ViewChangeCompletionListener viewChangeCompletionListener) {
            if (viewChangeCompletionListener == null) {
                throw new NullPointerException("If set, view change completion listener cannot be null!");
            }
            this.viewChangeCompletionListener = viewChangeCompletionListener;
            return this;
        }

        public Configurer setStatePersistenceStrategy(@NonNull StatePersistenceStrategy statePersistenceStrategy) {
            if (statePersistenceStrategy == null) {
                throw new NullPointerException("If set, state persistence strategy cannot be null!");
            }
            this.statePersistenceStrategy = statePersistenceStrategy;
            return this;
        }

        public DefaultStateChanger create(Context baseContext, ViewGroup container) {
            return new DefaultStateChanger(baseContext, container, this.externalStateChanger, this.viewChangeCompletionListener, this.statePersistenceStrategy);
        }
    }

    private static class NavigatorStatePersistenceStrategy
    implements StatePersistenceStrategy {
        private NavigatorStatePersistenceStrategy() {
        }

        @Override
        public void persistViewToState(@NonNull Object previousKey, @NonNull View previousView) {
            Navigator.persistViewToState(previousView);
        }

        @Override
        public void restoreViewFromState(@NonNull Object newKey, @NonNull View newView) {
            Navigator.restoreViewFromState(newView);
        }
    }

    public static interface StatePersistenceStrategy {
        public void persistViewToState(@NonNull Object var1, @NonNull View var2);

        public void restoreViewFromState(@NonNull Object var1, @NonNull View var2);
    }

    public static interface ViewChangeCompletionListener {
        public void handleViewChangeComplete(@NonNull StateChange var1, @NonNull ViewGroup var2, @Nullable View var3, @NonNull View var4, @NonNull Callback var5);

        public static interface Callback {
            public void viewChangeComplete();
        }
    }

    private static class NoOpViewChangeCompletionListener
    implements ViewChangeCompletionListener {
        private NoOpViewChangeCompletionListener() {
        }

        @Override
        public void handleViewChangeComplete(@NonNull StateChange stateChange, @NonNull ViewGroup container, @Nullable View previousView, @NonNull View newView, @NonNull ViewChangeCompletionListener.Callback completionCallback) {
            completionCallback.viewChangeComplete();
        }
    }

    private static class NoOpStateChanger
    implements StateChanger {
        private NoOpStateChanger() {
        }

        @Override
        public void handleStateChange(StateChange stateChange, StateChanger.Callback completionCallback) {
            completionCallback.stateChangeComplete();
        }
    }
}

