/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack.navigator;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.ViewGroup;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.BackstackManager;
import com.zhuinden.simplestack.KeyParceler;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.simplestack.navigator.Navigator;
import com.zhuinden.statebundle.StateBundle;
import java.util.Collections;
import java.util.List;

@TargetApi(value=11)
public final class BackstackHost
extends Fragment {
    StateChanger stateChanger;
    KeyParceler keyParceler;
    BackstackManager.StateClearStrategy stateClearStrategy;
    boolean shouldPersistContainerChild;
    BackstackManager backstackManager;
    List<Object> initialKeys = Collections.emptyList();
    ViewGroup container;
    Bundle savedInstanceState;

    public BackstackHost() {
        this.setRetainInstance(true);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.savedInstanceState = savedInstanceState;
    }

    Backstack initialize(boolean isInitializeDeferred) {
        if (this.backstackManager == null) {
            this.backstackManager = new BackstackManager();
            this.backstackManager.setKeyParceler(this.keyParceler);
            this.backstackManager.setStateClearStrategy(this.stateClearStrategy);
            this.backstackManager.setup(this.initialKeys);
            if (this.savedInstanceState != null) {
                this.backstackManager.fromBundle((StateBundle)this.savedInstanceState.getParcelable("NAVIGATOR_STATE_BUNDLE"));
            }
        }
        if (!isInitializeDeferred) {
            this.backstackManager.setStateChanger(this.stateChanger);
        }
        return this.backstackManager.getBackstack();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.shouldPersistContainerChild) {
            Navigator.persistViewToState(this.container.getChildAt(0));
        }
        outState.putParcelable("NAVIGATOR_STATE_BUNDLE", (Parcelable)this.backstackManager.toBundle());
    }

    public void onResume() {
        super.onResume();
        this.backstackManager.reattachStateChanger();
    }

    public void onPause() {
        this.backstackManager.detachStateChanger();
        super.onPause();
    }

    public void onDestroyView() {
        this.backstackManager.getBackstack().executePendingStateChange();
        this.stateChanger = null;
        this.container = null;
        super.onDestroyView();
    }

    public Backstack getBackstack() {
        return this.backstackManager.getBackstack();
    }

    public BackstackManager getBackstackManager() {
        return this.backstackManager;
    }
}

