/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.view.View;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.Bundleable;
import com.zhuinden.simplestack.DefaultKeyParceler;
import com.zhuinden.simplestack.DefaultStateClearStrategy;
import com.zhuinden.simplestack.KeyContextWrapper;
import com.zhuinden.simplestack.KeyParceler;
import com.zhuinden.simplestack.ParcelledState;
import com.zhuinden.simplestack.SavedState;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.statebundle.StateBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BackstackManager
implements Bundleable {
    private static final String HISTORY_TAG = "HISTORY";
    private static final String STATES_TAG = "STATES";
    private final StateChanger managedStateChanger = new StateChanger(){

        @Override
        public void handleStateChange(final StateChange stateChange, final StateChanger.Callback completionCallback) {
            BackstackManager.this.stateChanger.handleStateChange(stateChange, new StateChanger.Callback(){

                @Override
                public void stateChangeComplete() {
                    completionCallback.stateChangeComplete();
                    if (!BackstackManager.this.backstack.isStateChangePending()) {
                        BackstackManager.this.stateClearStrategy.clearStatesNotIn(BackstackManager.this.keyStateMap, stateChange);
                    }
                }
            });
        }
    };
    private KeyParceler keyParceler = new DefaultKeyParceler();
    private StateClearStrategy stateClearStrategy = new DefaultStateClearStrategy();
    Backstack backstack;
    Map<Object, SavedState> keyStateMap = new HashMap<Object, SavedState>();
    StateChanger stateChanger;

    static String getHistoryTag() {
        return HISTORY_TAG;
    }

    static String getStatesTag() {
        return STATES_TAG;
    }

    public void setKeyParceler(KeyParceler keyParceler) {
        if (this.backstack != null) {
            throw new IllegalStateException("Custom key parceler should be set before calling `setup()`");
        }
        if (keyParceler == null) {
            throw new IllegalArgumentException("The key parceler cannot be null!");
        }
        this.keyParceler = keyParceler;
    }

    public void setStateClearStrategy(StateClearStrategy stateClearStrategy) {
        if (this.backstack != null) {
            throw new IllegalStateException("Custom state clear strategy should be set before calling `setup()`");
        }
        if (stateClearStrategy == null) {
            throw new IllegalArgumentException("The state clear strategy cannot be null!");
        }
        this.stateClearStrategy = stateClearStrategy;
    }

    public void setup(@NonNull List<?> initialKeys) {
        this.backstack = new Backstack(initialKeys);
    }

    public Backstack getBackstack() {
        this.checkBackstack("You must call `setup()` before calling `getBackstack()`");
        return this.backstack;
    }

    private void initializeBackstack(StateChanger stateChanger) {
        if (stateChanger != null) {
            this.backstack.setStateChanger(this.managedStateChanger, 0);
        }
    }

    public void setStateChanger(@Nullable StateChanger stateChanger) {
        this.checkBackstack("You must call `setup()` before calling `setStateChanger().");
        if (this.backstack.hasStateChanger()) {
            this.backstack.removeStateChanger();
        }
        this.stateChanger = stateChanger;
        this.initializeBackstack(stateChanger);
    }

    public void detachStateChanger() {
        this.checkBackstack("You must call `setup()` before calling `detachStateChanger().`");
        if (this.backstack.hasStateChanger()) {
            this.backstack.removeStateChanger();
        }
    }

    public void reattachStateChanger() {
        this.checkBackstack("You must call `setup()` before calling `reattachStateChanger().`");
        if (!this.backstack.hasStateChanger()) {
            this.backstack.setStateChanger(this.managedStateChanger, 1);
        }
    }

    @NonNull
    public SavedState getSavedState(@NonNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        if (!this.keyStateMap.containsKey(key)) {
            this.keyStateMap.put(key, SavedState.builder().setKey(key).build());
        }
        return this.keyStateMap.get(key);
    }

    public void persistViewToState(@Nullable View view) {
        if (view != null) {
            Object key = KeyContextWrapper.getKey(view.getContext());
            if (key == null) {
                throw new IllegalArgumentException("The view [" + view + "] contained no key!");
            }
            SparseArray viewHierarchyState = new SparseArray();
            view.saveHierarchyState(viewHierarchyState);
            StateBundle bundle = null;
            if (view instanceof Bundleable) {
                bundle = ((Bundleable)view).toBundle();
            }
            SavedState previousSavedState = SavedState.builder().setKey(key).setViewHierarchyState((SparseArray<Parcelable>)viewHierarchyState).setBundle(bundle).build();
            this.keyStateMap.put(key, previousSavedState);
        }
    }

    public void restoreViewFromState(@NonNull View view) {
        if (view == null) {
            throw new IllegalArgumentException("You cannot restore state into null view!");
        }
        Object newKey = KeyContextWrapper.getKey(view.getContext());
        SavedState savedState = this.getSavedState(newKey);
        view.restoreHierarchyState(savedState.getViewHierarchyState());
        if (view instanceof Bundleable) {
            ((Bundleable)view).fromBundle(savedState.getBundle());
        }
    }

    @Override
    public void fromBundle(@Nullable StateBundle stateBundle) {
        this.checkBackstack("A backstack must be set up before it is restored!");
        if (stateBundle != null) {
            ArrayList savedStates;
            ArrayList<Object> keys = new ArrayList<Object>();
            ArrayList parcelledKeys = stateBundle.getParcelableArrayList(BackstackManager.getHistoryTag());
            if (parcelledKeys != null) {
                for (Parcelable parcelledKey : parcelledKeys) {
                    keys.add(this.keyParceler.fromParcelable(parcelledKey));
                }
            }
            if (!keys.isEmpty()) {
                this.backstack.setInitialParameters(keys);
            }
            if ((savedStates = stateBundle.getParcelableArrayList(BackstackManager.getStatesTag())) != null) {
                for (ParcelledState parcelledState : savedStates) {
                    SavedState savedState = SavedState.builder().setKey(this.keyParceler.fromParcelable(parcelledState.parcelableKey)).setViewHierarchyState(parcelledState.viewHierarchyState).setBundle(parcelledState.bundle).build();
                    this.keyStateMap.put(savedState.getKey(), savedState);
                }
            }
        }
    }

    private void checkBackstack(String message) {
        if (this.backstack == null) {
            throw new IllegalStateException(message);
        }
    }

    @Override
    @NonNull
    public StateBundle toBundle() {
        StateBundle stateBundle = new StateBundle();
        ArrayList<Parcelable> history = new ArrayList<Parcelable>();
        for (Object key : this.backstack.getHistory()) {
            history.add(this.keyParceler.toParcelable(key));
        }
        stateBundle.putParcelableArrayList(BackstackManager.getHistoryTag(), history);
        ArrayList<ParcelledState> states = new ArrayList<ParcelledState>();
        for (SavedState savedState : this.keyStateMap.values()) {
            ParcelledState parcelledState = new ParcelledState();
            parcelledState.parcelableKey = this.keyParceler.toParcelable(savedState.getKey());
            parcelledState.viewHierarchyState = savedState.getViewHierarchyState();
            parcelledState.bundle = savedState.getBundle();
            states.add(parcelledState);
        }
        stateBundle.putParcelableArrayList(BackstackManager.getStatesTag(), states);
        return stateBundle;
    }

    public static interface StateClearStrategy {
        public void clearStatesNotIn(@NonNull Map<Object, SavedState> var1, @NonNull StateChange var2);
    }
}

