/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class StateBundle
implements Parcelable {
    static final int type_boolean = 0;
    static final int type_byte = 1;
    static final int type_char = 2;
    static final int type_short = 3;
    static final int type_int = 4;
    static final int type_long = 5;
    static final int type_float = 6;
    static final int type_double = 7;
    static final int type_String = 8;
    static final int type_CharSequence = 9;
    static final int type_Serializable = 10;
    static final int type_IntegerArrayList = 11;
    static final int type_StringArrayList = 12;
    static final int type_CharSequenceArrayList = 13;
    static final int type_BooleanArray = 14;
    static final int type_ByteArray = 15;
    static final int type_ShortArray = 16;
    static final int type_CharArray = 17;
    static final int type_IntArray = 18;
    static final int type_LongArray = 19;
    static final int type_FloatArray = 20;
    static final int type_DoubleArray = 21;
    static final int type_StateBundle = 26;
    static final int type_Parcelable = 27;
    static final int type_ParcelableArrayList = 29;
    static final int type_SparseParcelableArray = 30;
    private static final String TAG = "StateBundle";
    Map<String, Object> map = new LinkedHashMap<String, Object>();
    Map<String, Integer> typeMap = new LinkedHashMap<String, Integer>();
    public static final Parcelable.Creator<StateBundle> CREATOR = new Parcelable.Creator<StateBundle>(){

        public StateBundle createFromParcel(Parcel in) {
            return new StateBundle(in);
        }

        public StateBundle[] newArray(int size) {
            return new StateBundle[size];
        }
    };

    public StateBundle() {
    }

    public StateBundle(StateBundle bundle) {
        this.putAll(bundle);
    }

    protected StateBundle(Parcel in) {
        int size = in.readInt();
        block28: for (int i = 0; i < size; ++i) {
            TypeElement typeElement = (TypeElement)in.readParcelable(TypeElement.class.getClassLoader());
            Object object = in.readValue(this.getClass().getClassLoader());
            switch (typeElement.type) {
                case 0: {
                    this.putBoolean(typeElement.key, (Boolean)object);
                    continue block28;
                }
                case 1: {
                    this.putByte(typeElement.key, (Byte)object);
                    continue block28;
                }
                case 2: {
                    this.putChar(typeElement.key, ((Character)object).charValue());
                    continue block28;
                }
                case 3: {
                    this.putShort(typeElement.key, (Short)object);
                    continue block28;
                }
                case 4: {
                    this.putInt(typeElement.key, (Integer)object);
                    continue block28;
                }
                case 5: {
                    this.putLong(typeElement.key, (Long)object);
                    continue block28;
                }
                case 6: {
                    this.putFloat(typeElement.key, ((Float)object).floatValue());
                    continue block28;
                }
                case 7: {
                    this.putDouble(typeElement.key, (Double)object);
                    continue block28;
                }
                case 8: {
                    this.putString(typeElement.key, (String)object);
                    continue block28;
                }
                case 9: {
                    this.putCharSequence(typeElement.key, (CharSequence)object);
                    continue block28;
                }
                case 10: {
                    this.putSerializable(typeElement.key, (Serializable)object);
                    continue block28;
                }
                case 11: {
                    this.putIntegerArrayList(typeElement.key, (ArrayList)object);
                    continue block28;
                }
                case 12: {
                    this.putStringArrayList(typeElement.key, (ArrayList)object);
                    continue block28;
                }
                case 13: {
                    this.putCharSequenceArrayList(typeElement.key, (ArrayList)object);
                    continue block28;
                }
                case 14: {
                    this.putBooleanArray(typeElement.key, (boolean[])object);
                    continue block28;
                }
                case 15: {
                    this.putByteArray(typeElement.key, (byte[])object);
                    continue block28;
                }
                case 16: {
                    this.putShortArray(typeElement.key, (short[])object);
                    continue block28;
                }
                case 17: {
                    this.putCharArray(typeElement.key, (char[])object);
                    continue block28;
                }
                case 18: {
                    this.putIntArray(typeElement.key, (int[])object);
                    continue block28;
                }
                case 19: {
                    this.putLongArray(typeElement.key, (long[])object);
                    continue block28;
                }
                case 20: {
                    this.putFloatArray(typeElement.key, (float[])object);
                    continue block28;
                }
                case 21: {
                    this.putDoubleArray(typeElement.key, (double[])object);
                    continue block28;
                }
                case 26: {
                    this.putBundle(typeElement.key, (StateBundle)object);
                    continue block28;
                }
                case 27: {
                    this.putParcelable(typeElement.key, (Parcelable)object);
                    continue block28;
                }
                case 29: {
                    this.putParcelableArrayList(typeElement.key, (ArrayList)object);
                    continue block28;
                }
                case 30: {
                    this.putSparseParcelableArray(typeElement.key, (SparseArray<? extends Parcelable>)((SparseArray)object));
                }
            }
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
        this.typeMap.clear();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Nullable
    public Object get(String key) {
        return this.map.get(key);
    }

    public void remove(String key) {
        this.map.remove(key);
        this.typeMap.remove(key);
    }

    public void putAll(StateBundle bundle) {
        if (bundle.map != null) {
            this.map.putAll(bundle.map);
            this.typeMap.putAll(bundle.typeMap);
        }
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public void putBoolean(@Nullable String key, boolean value) {
        this.map.put(key, value);
        this.typeMap.put(key, 0);
    }

    public void putByte(@Nullable String key, byte value) {
        this.map.put(key, value);
        this.typeMap.put(key, 1);
    }

    public void putChar(@Nullable String key, char value) {
        this.map.put(key, Character.valueOf(value));
        this.typeMap.put(key, 2);
    }

    public void putShort(@Nullable String key, short value) {
        this.map.put(key, value);
        this.typeMap.put(key, 3);
    }

    public void putInt(@Nullable String key, int value) {
        this.map.put(key, value);
        this.typeMap.put(key, 4);
    }

    public void putLong(@Nullable String key, long value) {
        this.map.put(key, value);
        this.typeMap.put(key, 5);
    }

    public void putFloat(@Nullable String key, float value) {
        this.map.put(key, Float.valueOf(value));
        this.typeMap.put(key, 6);
    }

    public void putDouble(@Nullable String key, double value) {
        this.map.put(key, value);
        this.typeMap.put(key, 7);
    }

    public void putString(@Nullable String key, @Nullable String value) {
        this.map.put(key, value);
        this.typeMap.put(key, 8);
    }

    public void putCharSequence(@Nullable String key, @Nullable CharSequence value) {
        this.map.put(key, value);
        this.typeMap.put(key, 9);
    }

    public void putIntegerArrayList(@Nullable String key, @Nullable ArrayList<Integer> value) {
        this.map.put(key, value);
        this.typeMap.put(key, 11);
    }

    public void putStringArrayList(@Nullable String key, @Nullable ArrayList<String> value) {
        this.map.put(key, value);
        this.typeMap.put(key, 12);
    }

    public void putCharSequenceArrayList(@Nullable String key, @Nullable ArrayList<CharSequence> value) {
        this.map.put(key, value);
        this.typeMap.put(key, 13);
    }

    public void putSerializable(@Nullable String key, @Nullable Serializable value) {
        this.map.put(key, value);
        this.typeMap.put(key, 10);
    }

    public void putBooleanArray(@Nullable String key, @Nullable boolean[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 14);
    }

    public void putByteArray(@Nullable String key, @Nullable byte[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 15);
    }

    public void putShortArray(@Nullable String key, @Nullable short[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 16);
    }

    public void putCharArray(@Nullable String key, @Nullable char[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 17);
    }

    public void putIntArray(@Nullable String key, @Nullable int[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 18);
    }

    public void putLongArray(@Nullable String key, @Nullable long[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 19);
    }

    public void putFloatArray(@Nullable String key, @Nullable float[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 20);
    }

    public void putDoubleArray(@Nullable String key, @Nullable double[] value) {
        this.map.put(key, value);
        this.typeMap.put(key, 21);
    }

    public void putParcelable(@Nullable String key, @Nullable Parcelable value) {
        this.map.put(key, value);
        this.typeMap.put(key, 27);
    }

    public void putParcelableArrayList(@Nullable String key, @Nullable ArrayList<? extends Parcelable> value) {
        this.map.put(key, value);
        this.typeMap.put(key, 29);
    }

    public void putSparseParcelableArray(@Nullable String key, @Nullable SparseArray<? extends Parcelable> value) {
        this.map.put(key, value);
        this.typeMap.put(key, 30);
    }

    public void putBundle(@Nullable String key, @Nullable StateBundle value) {
        this.map.put(key, value);
        this.typeMap.put(key, 26);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Boolean)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Boolean", defaultValue, e);
            return defaultValue;
        }
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public Byte getByte(String key, byte defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Byte)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Byte", defaultValue, e);
            return defaultValue;
        }
    }

    public char getChar(String key) {
        return this.getChar(key, '\u0000');
    }

    public char getChar(String key, char defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Character)o).charValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Character", Character.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Short)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Short", defaultValue, e);
            return defaultValue;
        }
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Integer)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Integer", defaultValue, e);
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Long)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Long", defaultValue, e);
            return defaultValue;
        }
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Float)o).floatValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Float", Float.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Object o = this.map.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Double)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Double", defaultValue, e);
            return defaultValue;
        }
    }

    @Nullable
    public String getString(@Nullable String key) {
        Object o = this.map.get(key);
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "String", e);
            return null;
        }
    }

    public String getString(@Nullable String key, String defaultValue) {
        String s = this.getString(key);
        return s == null ? defaultValue : s;
    }

    @Nullable
    public CharSequence getCharSequence(@Nullable String key) {
        Object o = this.map.get(key);
        try {
            return (CharSequence)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "CharSequence", e);
            return null;
        }
    }

    public CharSequence getCharSequence(@Nullable String key, CharSequence defaultValue) {
        CharSequence cs = this.getCharSequence(key);
        return cs == null ? defaultValue : cs;
    }

    @Nullable
    public Serializable getSerializable(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Serializable)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Serializable", e);
            return null;
        }
    }

    @Nullable
    public ArrayList<Integer> getIntegerArrayList(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<Integer>", e);
            return null;
        }
    }

    @Nullable
    public ArrayList<String> getStringArrayList(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<String>", e);
            return null;
        }
    }

    @Nullable
    public ArrayList<CharSequence> getCharSequenceArrayList(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<CharSequence>", e);
            return null;
        }
    }

    @Nullable
    public boolean[] getBooleanArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (boolean[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    @Nullable
    public byte[] getByteArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (byte[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    @Nullable
    public short[] getShortArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (short[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "short[]", e);
            return null;
        }
    }

    @Nullable
    public char[] getCharArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (char[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "char[]", e);
            return null;
        }
    }

    @Nullable
    public int[] getIntArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (int[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "int[]", e);
            return null;
        }
    }

    @Nullable
    public long[] getLongArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (long[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "long[]", e);
            return null;
        }
    }

    @Nullable
    public float[] getFloatArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (float[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "float[]", e);
            return null;
        }
    }

    @Nullable
    public double[] getDoubleArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (double[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "double[]", e);
            return null;
        }
    }

    @Nullable
    public StateBundle getBundle(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (StateBundle)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Bundle", e);
            return null;
        }
    }

    @Nullable
    public <T extends Parcelable> T getParcelable(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (T)((Parcelable)o);
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Parcelable", e);
            return null;
        }
    }

    @Nullable
    public <T extends Parcelable> ArrayList<T> getParcelableArrayList(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList", e);
            return null;
        }
    }

    @Nullable
    public <T extends Parcelable> SparseArray<T> getSparseParcelableArray(@Nullable String key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (SparseArray)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "SparseArray", e);
            return null;
        }
    }

    void typeWarning(String key, Object value, String className, Object defaultValue, ClassCastException e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key ");
        sb.append(key);
        sb.append(" expected ");
        sb.append(className);
        sb.append(" but value was a ");
        sb.append(value.getClass().getName());
        sb.append(".  The default value ");
        sb.append(defaultValue);
        sb.append(" was returned.");
        System.out.println(sb.toString());
    }

    void typeWarning(String key, Object value, String className, ClassCastException e) {
        this.typeWarning(key, value, className, "<null>", e);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.map.keySet().size());
        for (String key : this.map.keySet()) {
            TypeElement typeElement = new TypeElement(key, this.typeMap.get(key));
            dest.writeParcelable((Parcelable)typeElement, 0);
            dest.writeValue(this.get(key));
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            stringBuilder.append("[[");
            stringBuilder.append(entry.getKey());
            stringBuilder.append("] :: [");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("]]\n");
        }
        return stringBuilder.toString();
    }

    static class TypeElement
    implements Parcelable {
        String key;
        int type;
        public static final Parcelable.Creator<TypeElement> CREATOR = new Parcelable.Creator<TypeElement>(){

            public TypeElement createFromParcel(Parcel in) {
                return new TypeElement(in);
            }

            public TypeElement[] newArray(int size) {
                return new TypeElement[size];
            }
        };

        TypeElement() {
        }

        TypeElement(String key, int type) {
            this.key = key;
            this.type = type;
        }

        protected TypeElement(Parcel in) {
            this.key = in.readString();
            this.type = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.key);
            dest.writeInt(this.type);
        }
    }
}

