/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;

public class SavedState
implements Parcelable {
    private Parcelable key;
    private SparseArray<Parcelable> viewHierarchyState;
    private Bundle bundle;
    public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

        public SavedState createFromParcel(Parcel in) {
            return new SavedState(in);
        }

        public SavedState[] newArray(int size) {
            return new SavedState[size];
        }
    };

    private SavedState() {
    }

    public Parcelable getKey() {
        return this.key;
    }

    public SparseArray<Parcelable> getViewHierarchyState() {
        return this.viewHierarchyState;
    }

    public void setViewHierarchyState(SparseArray<Parcelable> viewHierarchyState) {
        this.viewHierarchyState = viewHierarchyState;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected SavedState(Parcel in) {
        boolean hasBundle;
        this.key = in.readParcelable(this.getClass().getClassLoader());
        this.viewHierarchyState = in.readSparseArray(this.getClass().getClassLoader());
        boolean bl = hasBundle = in.readByte() > 0;
        if (hasBundle) {
            this.bundle = in.readBundle(this.getClass().getClassLoader());
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.key, flags);
        SparseArray<Parcelable> sparseArray = this.viewHierarchyState;
        dest.writeSparseArray(sparseArray);
        dest.writeByte(this.bundle != null ? (byte)1 : 0);
        if (this.bundle != null) {
            dest.writeBundle(this.bundle);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavedState)) {
            return false;
        }
        return ((SavedState)obj).getKey().equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public static class Builder {
        private Parcelable key;
        private SparseArray<Parcelable> viewHierarchyState = new SparseArray();
        private Bundle bundle;

        Builder() {
        }

        public Builder setKey(@NonNull Parcelable key) {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            this.key = key;
            return this;
        }

        public Builder setViewHierarchyState(@NonNull SparseArray<Parcelable> viewHierarchyState) {
            if (viewHierarchyState == null) {
                throw new IllegalArgumentException("Provided sparse array for view hierarchy state cannot be null");
            }
            this.viewHierarchyState = viewHierarchyState;
            return this;
        }

        public Builder setBundle(@Nullable Bundle bundle) {
            this.bundle = bundle;
            return this;
        }

        public SavedState build() {
            if (this.key == null) {
                throw new IllegalStateException("You cannot create a SavedState without associating a Key with it.");
            }
            SavedState savedState = new SavedState();
            savedState.key = this.key;
            savedState.viewHierarchyState = this.viewHierarchyState;
            savedState.bundle = this.bundle;
            return savedState;
        }
    }
}

