/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.content.Context;
import android.content.ContextWrapper;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;

public class KeyContextWrapper
extends ContextWrapper {
    public static final String TAG = "Backstack.KEY";
    LayoutInflater layoutInflater;
    final Parcelable key;

    public KeyContextWrapper(Context base, @NonNull Parcelable key) {
        super(base);
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        this.key = key;
    }

    public Object getSystemService(String name) {
        if ("layout_inflater".equals(name)) {
            if (this.layoutInflater == null) {
                this.layoutInflater = LayoutInflater.from((Context)this.getBaseContext()).cloneInContext((Context)this);
            }
            return this.layoutInflater;
        }
        if (TAG.equals(name)) {
            return this.key;
        }
        return super.getSystemService(name);
    }

    public static <T extends Parcelable> T getKey(Context context) {
        Object key = context.getSystemService(TAG);
        return (T)((Parcelable)key);
    }
}

