/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.content.Context;
import android.os.Parcelable;
import com.zhuinden.simplestack.KeyContextWrapper;
import com.zhuinden.simplestack.PendingStateChange;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Backstack {
    public static final int INITIALIZE = 0;
    public static final int REATTACH = 1;
    private final List<Parcelable> originalStack = new ArrayList<Parcelable>();
    private final List<Parcelable> initialParameters;
    private List<Parcelable> stack = this.originalStack;
    private LinkedList<PendingStateChange> queuedStateChanges = new LinkedList();
    private StateChanger stateChanger;

    public static <T extends Parcelable> T getKey(Context context) {
        return KeyContextWrapper.getKey(context);
    }

    public Backstack(Parcelable ... initialKeys) {
        if (initialKeys == null || initialKeys.length <= 0) {
            throw new IllegalArgumentException("At least one initial key must be defined");
        }
        this.initialParameters = Collections.unmodifiableList(new ArrayList<Parcelable>(Arrays.asList(initialKeys)));
    }

    public Backstack(List<Parcelable> initialKeys) {
        if (initialKeys == null) {
            throw new NullPointerException("Initial key list should not be null");
        }
        if (initialKeys.size() <= 0) {
            throw new IllegalArgumentException("Initial key list should contain at least one element");
        }
        this.initialParameters = Collections.unmodifiableList(new ArrayList<Parcelable>(initialKeys));
    }

    public boolean hasStateChanger() {
        return this.stateChanger != null;
    }

    public void setStateChanger(StateChanger stateChanger, int registerMode) {
        if (stateChanger == null) {
            throw new NullPointerException("New state changer cannot be null");
        }
        this.stateChanger = stateChanger;
        if (registerMode == 0 && (this.queuedStateChanges.size() <= 1 || this.stack.isEmpty())) {
            if (!this.beginStateChangeIfPossible()) {
                ArrayList<Parcelable> newHistory = new ArrayList<Parcelable>();
                newHistory.addAll(this.selectActiveHistory());
                this.stack = this.initialParameters;
                this.enqueueStateChange(newHistory, 0, true);
            }
            return;
        }
        this.beginStateChangeIfPossible();
    }

    public void removeStateChanger() {
        this.stateChanger = null;
    }

    public void goTo(Parcelable newKey) {
        int direction;
        this.checkNewKey(newKey);
        ArrayList<Parcelable> newHistory = new ArrayList<Parcelable>();
        boolean isNewKey = true;
        for (Parcelable key : this.selectActiveHistory()) {
            newHistory.add(key);
            if (!key.equals(newKey)) continue;
            isNewKey = false;
            break;
        }
        if (isNewKey) {
            newHistory.add(newKey);
            direction = 1;
        } else {
            direction = -1;
        }
        this.enqueueStateChange(newHistory, direction, false);
    }

    public boolean goBack() {
        if (!this.queuedStateChanges.isEmpty() && this.queuedStateChanges.get(0).getStatus() != PendingStateChange.Status.COMPLETED) {
            return true;
        }
        if (this.stack.size() <= 1) {
            this.stack.clear();
            return false;
        }
        ArrayList<Parcelable> newHistory = new ArrayList<Parcelable>();
        List<Parcelable> activeHistory = this.selectActiveHistory();
        for (int i = 0; i < activeHistory.size() - 1; ++i) {
            newHistory.add(activeHistory.get(i));
        }
        this.enqueueStateChange(newHistory, -1, false);
        return true;
    }

    public void setHistory(List<Parcelable> newHistory, int direction) {
        this.checkNewHistory(newHistory);
        this.enqueueStateChange(newHistory, direction, false);
    }

    public List<Parcelable> getHistory() {
        ArrayList<Parcelable> copy = new ArrayList<Parcelable>();
        copy.addAll(this.stack);
        return Collections.unmodifiableList(copy);
    }

    private void enqueueStateChange(List<Parcelable> newHistory, int direction, boolean initialization) {
        PendingStateChange pendingStateChange = new PendingStateChange(newHistory, direction, initialization);
        this.queuedStateChanges.add(pendingStateChange);
        this.beginStateChangeIfPossible();
    }

    private List<Parcelable> selectActiveHistory() {
        if (this.stack.isEmpty() && this.queuedStateChanges.size() <= 0) {
            return this.initialParameters;
        }
        if (this.queuedStateChanges.size() <= 0) {
            return this.stack;
        }
        return this.queuedStateChanges.getLast().newHistory;
    }

    private boolean beginStateChangeIfPossible() {
        PendingStateChange pendingStateChange;
        if (this.hasStateChanger() && !this.queuedStateChanges.isEmpty() && (pendingStateChange = this.queuedStateChanges.get(0)).getStatus() == PendingStateChange.Status.ENQUEUED) {
            pendingStateChange.setStatus(PendingStateChange.Status.IN_PROGRESS);
            this.changeState(pendingStateChange);
            return true;
        }
        return false;
    }

    private void changeState(final PendingStateChange pendingStateChange) {
        List previousState;
        boolean initialization = pendingStateChange.initialization;
        List<Parcelable> newHistory = pendingStateChange.newHistory;
        int direction = pendingStateChange.direction;
        if (initialization) {
            previousState = Collections.emptyList();
        } else {
            previousState = new ArrayList();
            previousState.addAll(this.stack);
        }
        final StateChange stateChange = new StateChange(Collections.unmodifiableList(previousState), Collections.unmodifiableList(newHistory), direction);
        this.stateChanger.handleStateChange(stateChange, new StateChanger.Callback(){

            @Override
            public void stateChangeComplete() {
                if (pendingStateChange.getStatus() == PendingStateChange.Status.COMPLETED) {
                    throw new IllegalStateException("State change completion cannot be called multiple times!");
                }
                Backstack.this.completeStateChange(stateChange);
            }
        });
    }

    private void completeStateChange(StateChange stateChange) {
        if (this.initialParameters == this.stack) {
            this.stack = this.originalStack;
        }
        this.stack.clear();
        this.stack.addAll(stateChange.newState);
        PendingStateChange pendingStateChange = this.queuedStateChanges.remove(0);
        pendingStateChange.setStatus(PendingStateChange.Status.COMPLETED);
        this.beginStateChangeIfPossible();
    }

    private void checkNewHistory(List<Parcelable> newHistory) {
        if (newHistory == null || newHistory.isEmpty()) {
            throw new IllegalArgumentException("New history cannot be null or empty");
        }
    }

    private void checkNewKey(Parcelable newKey) {
        if (newKey == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
    }
}

