/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class HistoryBuilder {
    private ArrayList<Parcelable> list = new ArrayList();

    private HistoryBuilder() {
    }

    public static HistoryBuilder from(List<? extends Parcelable> collection) {
        return HistoryBuilder.newBuilder().addAll(collection);
    }

    public static HistoryBuilder newBuilder() {
        return new HistoryBuilder();
    }

    public static ArrayList<Parcelable> single(Parcelable key) {
        return HistoryBuilder.newBuilder().add(key).build();
    }

    public HistoryBuilder addAll(List<? extends Parcelable> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Provided collection cannot be null");
        }
        this.list.addAll(collection);
        return this;
    }

    public HistoryBuilder removeLast() {
        if (this.list.isEmpty()) {
            throw new IllegalStateException("Cannot remove element from empty list");
        }
        this.list.remove(this.list.size() - 1);
        return this;
    }

    public HistoryBuilder removeUntil(Parcelable key) {
        if (key == null) {
            throw new IllegalArgumentException("History key cannot be null");
        }
        while (!this.list.isEmpty() && !this.peek().equals(key)) {
            this.removeLast();
        }
        if (this.list.isEmpty()) {
            throw new IllegalArgumentException("[" + key + "] was not found in history!");
        }
        return this;
    }

    public <T extends Parcelable> T peek() {
        return (T)(this.list.isEmpty() ? null : this.list.get(this.list.size() - 1));
    }

    public HistoryBuilder add(Parcelable key) {
        if (key == null) {
            throw new IllegalArgumentException("History key cannot be null");
        }
        this.list.add(key);
        return this;
    }

    public ArrayList<Parcelable> build() {
        ArrayList<Parcelable> list = new ArrayList<Parcelable>(this.list);
        return list;
    }
}

