/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.content.Context;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zhuinden.simplestack.KeyContextWrapper;
import java.util.List;

public class StateChange {
    List<Parcelable> previousState;
    List<Parcelable> newState;
    Direction direction;

    StateChange(List<Parcelable> previousState, List<Parcelable> newState, Direction direction) {
        this.previousState = previousState;
        this.newState = newState;
        this.direction = direction;
    }

    public List<Parcelable> getPreviousState() {
        return this.previousState;
    }

    public List<Parcelable> getNewState() {
        return this.newState;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Nullable
    public <T extends Parcelable> T topPreviousState() {
        if (this.previousState.size() > 0) {
            return (T)this.previousState.get(this.previousState.size() - 1);
        }
        return null;
    }

    @NonNull
    public <T extends Parcelable> T topNewState() {
        return (T)this.newState.get(this.newState.size() - 1);
    }

    @NonNull
    public KeyContextWrapper createContext(Context base, Parcelable key) {
        return new KeyContextWrapper(base, key);
    }

    public static enum Direction {
        FORWARD,
        BACKWARD,
        REPLACE;

    }
}

