/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import android.view.View;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.Bundleable;
import com.zhuinden.simplestack.HistoryBuilder;
import com.zhuinden.simplestack.KeyContextWrapper;
import com.zhuinden.simplestack.SavedState;
import com.zhuinden.simplestack.StateChanger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BackstackDelegate {
    private static final String STATES = "simplestack.BACKSTACK_STATES";
    Backstack backstack;
    StateChanger stateChanger;
    Map<Parcelable, SavedState> keyStateMap = new HashMap<Parcelable, SavedState>();

    public BackstackDelegate(StateChanger stateChanger) {
        if (stateChanger == null) {
            throw new IllegalArgumentException("State changer cannot be null!");
        }
        this.stateChanger = stateChanger;
    }

    public void onCreate(Bundle savedInstanceState, Object nonConfigurationInstance, ArrayList<Parcelable> initialKeys) {
        NonConfigurationInstance nonConfig;
        ArrayList keys;
        if (nonConfigurationInstance != null && !(nonConfigurationInstance instanceof NonConfigurationInstance)) {
            throw new IllegalArgumentException("The provided non configuration instance must be of type BackstackDelegate.NonConfigurationInstance!");
        }
        if (savedInstanceState != null) {
            keys = savedInstanceState.getParcelableArrayList("simplestack.BACKSTACK");
            ArrayList savedStates = savedInstanceState.getParcelableArrayList(STATES);
            if (savedStates != null) {
                for (SavedState savedState : savedStates) {
                    this.keyStateMap.put(savedState.getKey(), savedState);
                }
            }
        } else {
            keys = initialKeys;
        }
        this.backstack = (nonConfig = (NonConfigurationInstance)nonConfigurationInstance) != null ? nonConfig.getBackstack() : new Backstack(keys);
        this.backstack.setStateChanger(this.stateChanger, 0);
    }

    public NonConfigurationInstance onRetainCustomNonConfigurationInstance() {
        return new NonConfigurationInstance(this.backstack);
    }

    public boolean onBackPressed() {
        return this.backstack.goBack();
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putParcelableArrayList("simplestack.BACKSTACK", HistoryBuilder.from(this.backstack.getHistory()).build());
        outState.putParcelableArrayList(STATES, new ArrayList<SavedState>(this.keyStateMap.values()));
    }

    public void onPostResume() {
        if (!this.backstack.hasStateChanger()) {
            this.backstack.setStateChanger(this.stateChanger, 1);
        }
    }

    public void onPause() {
        if (this.backstack.hasStateChanger()) {
            this.backstack.removeStateChanger();
        }
    }

    public boolean isSystemService(String name) {
        return "simplestack.BACKSTACK".equals(name);
    }

    public Backstack getSystemService(String name) {
        if (this.isSystemService(name)) {
            return this.backstack;
        }
        return null;
    }

    public Backstack getBackstack() {
        if (this.backstack == null) {
            throw new IllegalStateException("The backstack within the delegate must be initialized by `onCreate()`");
        }
        return this.backstack;
    }

    public void persistViewToState(View view) {
        if (view != null) {
            Object key = KeyContextWrapper.getKey(view.getContext());
            if (key == null) {
                throw new IllegalArgumentException("The view [" + view + "] contained no key!");
            }
            SparseArray viewHierarchyState = new SparseArray();
            view.saveHierarchyState(viewHierarchyState);
            Bundle bundle = null;
            if (view instanceof Bundleable) {
                bundle = ((Bundleable)view).toBundle();
            }
            SavedState previousSavedState = SavedState.builder().setKey((Parcelable)key).setViewHierarchyState((SparseArray<Parcelable>)viewHierarchyState).setBundle(bundle).build();
            this.keyStateMap.put((Parcelable)key, previousSavedState);
        }
    }

    public void restoreViewFromState(View view) {
        Object newKey = KeyContextWrapper.getKey(view.getContext());
        SavedState savedState = this.getSavedState((Parcelable)newKey);
        view.restoreHierarchyState(savedState.getViewHierarchyState());
        if (view instanceof Bundleable) {
            ((Bundleable)view).fromBundle(savedState.getBundle());
        }
    }

    @NonNull
    public SavedState getSavedState(Parcelable key) {
        if (!this.keyStateMap.containsKey(key)) {
            this.keyStateMap.put(key, SavedState.builder().setKey(key).build());
        }
        return this.keyStateMap.get(key);
    }

    public void clearStatesNotIn(List<Parcelable> keys) {
        this.keyStateMap.keySet().retainAll(keys);
    }

    public static class NonConfigurationInstance {
        private Backstack backstack;

        private NonConfigurationInstance(Backstack backstack) {
            this.backstack = backstack;
        }

        Backstack getBackstack() {
            return this.backstack;
        }
    }
}

