/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.monarchy;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import com.zhuinden.monarchy.CopiedLiveResults;
import com.zhuinden.monarchy.FrozenLiveResults;
import com.zhuinden.monarchy.LiveResults;
import com.zhuinden.monarchy.ManagedLiveResults;
import com.zhuinden.monarchy.MappedLiveResults;
import io.realm.OrderedCollectionChangeSet;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Monarchy {
    private final Object LOCK = new Object();
    private final Executor writeScheduler;
    private static volatile RealmConfiguration invalidDefaultConfig;
    private volatile RealmConfiguration realmConfiguration = null;
    private AtomicReference<HandlerThread> handlerThread = new AtomicReference();
    private AtomicReference<Handler> handler = new AtomicReference();
    private AtomicInteger refCount = new AtomicInteger(0);
    private ThreadLocal<Realm> realmThreadLocal = new ThreadLocal();
    private ThreadLocal<Map<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>>> resultsRefs = new ThreadLocal<Map<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>>>(){

        @Override
        protected Map<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>> initialValue() {
            return new IdentityHashMap<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>>();
        }
    };
    private final AtomicBoolean isForcedOpen = new AtomicBoolean(false);

    public static void init(@Nonnull Context context) {
        Realm.init((Context)context);
        invalidDefaultConfig = new RealmConfiguration.Builder().build();
        Realm.setDefaultConfiguration((RealmConfiguration)invalidDefaultConfig);
    }

    public static void setDefaultConfiguration(@Nonnull RealmConfiguration realmConfiguration) {
        Realm.setDefaultConfiguration((RealmConfiguration)realmConfiguration);
    }

    @Nonnull
    public static RealmConfiguration getDefaultConfiguration() {
        RealmConfiguration config = Realm.getDefaultConfiguration();
        if (config == invalidDefaultConfig || config == null) {
            throw new IllegalStateException("No default configuration is set!");
        }
        return config;
    }

    Monarchy(@Nonnull RealmConfiguration configuration, @Nonnull Executor writeScheduler) {
        this.realmConfiguration = configuration;
        this.writeScheduler = writeScheduler;
    }

    @Nonnull
    public final RealmConfiguration getRealmConfiguration() {
        return this.realmConfiguration == null ? Monarchy.getDefaultConfiguration() : this.realmConfiguration;
    }

    public final void runTransactionSync(final @Nonnull Realm.Transaction transaction) {
        this.doWithRealm(new RealmBlock(){

            @Override
            public void doWithRealm(@NonNull Realm realm) {
                realm.executeTransaction(transaction);
            }
        });
    }

    private void assertMainThread() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("This method can only be called on the main thread!");
        }
    }

    <T extends RealmModel> void createAndObserveRealmQuery(final @Nullable LiveResults<T> liveResults) {
        Realm realm = this.realmThreadLocal.get();
        this.checkRealmValid(realm);
        if (liveResults == null) {
            return;
        }
        RealmResults<T> results = liveResults.createQuery(realm);
        this.resultsRefs.get().put(liveResults, results);
        results.addChangeListener(new RealmChangeListener<RealmResults<T>>(){

            public void onChange(@Nonnull RealmResults<T> realmResults) {
                liveResults.updateResults(realmResults);
            }
        });
    }

    <T extends RealmModel> void destroyRealmQuery(@Nullable LiveResults<T> liveResults) {
        Realm realm = this.realmThreadLocal.get();
        this.checkRealmValid(realm);
        if (liveResults == null) {
            return;
        }
        RealmResults<? extends RealmModel> realmResults = this.resultsRefs.get().remove(liveResults);
        if (realmResults != null) {
            realmResults.removeAllChangeListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends RealmModel> void startListening(final @Nullable LiveResults<T> liveResults) {
        if (this.refCount.getAndIncrement() == 0) {
            Object object = this.LOCK;
            synchronized (object) {
                HandlerThread handlerThread = new HandlerThread("MONARCHY_REALM-#" + this.hashCode());
                handlerThread.start();
                Handler handler = new Handler(handlerThread.getLooper());
                this.handlerThread.set(handlerThread);
                this.handler.set(handler);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Realm realm = Realm.getInstance((RealmConfiguration)Monarchy.this.getRealmConfiguration());
                        if (Monarchy.this.realmThreadLocal.get() == null) {
                            Monarchy.this.realmThreadLocal.set(realm);
                        }
                    }
                });
            }
        }
        this.handler.get().post(new Runnable(){

            @Override
            public void run() {
                Monarchy.this.createAndObserveRealmQuery(liveResults);
            }
        });
    }

    <T extends RealmModel> void stopListening(final @Nullable LiveResults<T> liveResults) {
        Handler handler = this.handler.get();
        if (handler == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                Monarchy.this.destroyRealmQuery(liveResults);
            }
        });
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Monarchy.this.LOCK;
                synchronized (object) {
                    if (Monarchy.this.refCount.decrementAndGet() == 0) {
                        Realm realm = (Realm)Monarchy.this.realmThreadLocal.get();
                        Monarchy.this.checkRealmValid(realm);
                        realm.close();
                        if (Realm.getLocalInstanceCount((RealmConfiguration)Monarchy.this.getRealmConfiguration()) <= 0) {
                            Monarchy.this.realmThreadLocal.set(null);
                        }
                        HandlerThread handlerThread = Monarchy.this.handlerThread.getAndSet(null);
                        Monarchy.this.handler.set(null);
                        handlerThread.quit();
                    }
                }
            }
        });
    }

    private void checkRealmValid(@Nullable Realm realm) {
        if (realm == null || realm.isClosed()) {
            throw new IllegalStateException("Unexpected state: Realm is not open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWithRealm(@Nonnull RealmBlock realmBlock) {
        RealmConfiguration configuration = this.getRealmConfiguration();
        try (Realm realm = null;){
            realm = Realm.getInstance((RealmConfiguration)configuration);
            realmBlock.doWithRealm(realm);
        }
    }

    public final void writeAsync(final @Nonnull Realm.Transaction transaction) {
        this.writeScheduler.execute(new Runnable(){

            @Override
            public void run() {
                Monarchy.this.runTransactionSync(transaction);
            }
        });
    }

    @Nonnull
    public <T extends RealmModel> List<T> fetchAllManagedSync(@Nonnull Realm realm, @Nonnull Query<T> query) {
        return query.createQuery(realm).findAll().createSnapshot();
    }

    @Nonnull
    public <T extends RealmModel> List<T> fetchAllCopiedSync(final @Nonnull Query<T> query) {
        final AtomicReference ref = new AtomicReference();
        this.doWithRealm(new RealmBlock(){

            @Override
            public void doWithRealm(@NonNull Realm realm) {
                ref.set(realm.copyFromRealm((Iterable)query.createQuery(realm).findAll()));
            }
        });
        return Collections.unmodifiableList((List)ref.get());
    }

    @Nonnull
    public <T extends RealmModel, U> List<U> fetchAllMappedSync(final @Nonnull Query<T> query, final @Nonnull Mapper<U, T> mapper) {
        final AtomicReference ref = new AtomicReference();
        this.doWithRealm(new RealmBlock(){

            @Override
            public void doWithRealm(@NonNull Realm realm) {
                RealmResults results = query.createQuery(realm).findAll();
                ArrayList list = new ArrayList(results.size());
                for (RealmModel t : results) {
                    list.add(mapper.map(t));
                }
                ref.set(list);
            }
        });
        return Collections.unmodifiableList((List)ref.get());
    }

    @Nonnull
    public <T extends RealmModel> LiveData<List<T>> findAllCopiedWithChanges(@Nonnull Query<T> query) {
        this.assertMainThread();
        return new CopiedLiveResults<T>(this, query, Integer.MAX_VALUE);
    }

    @Nonnull
    public <T extends RealmModel> LiveData<List<T>> findAllCopiedWithChanges(int maxDepth, @Nonnull Query<T> query) {
        this.assertMainThread();
        return new CopiedLiveResults<T>(this, query, maxDepth);
    }

    @Nonnull
    public <T extends RealmModel> LiveData<List<T>> findAllFrozenWithChanges(@Nonnull Query<T> query) {
        this.assertMainThread();
        return new FrozenLiveResults<T>(this, query);
    }

    @Nonnull
    public <T extends RealmModel, U> LiveData<List<U>> findAllMappedWithChanges(@Nonnull Query<T> query, @Nonnull Mapper<U, T> mapper) {
        this.assertMainThread();
        return new MappedLiveResults<T, U>(this, query, mapper);
    }

    @Nonnull
    private <T extends RealmModel> LiveData<ManagedChangeSet<T>> findAllManagedWithChanges(@Nonnull Query<T> query, boolean asAsync) {
        this.assertMainThread();
        return new ManagedLiveResults<T>(this, query, asAsync);
    }

    @Nonnull
    public <T extends RealmModel> LiveData<ManagedChangeSet<T>> findAllManagedWithChanges(@Nonnull Query<T> query) {
        return this.findAllManagedWithChanges(query, true);
    }

    @Nonnull
    public <T extends RealmModel> LiveData<ManagedChangeSet<T>> findAllManagedWithChangesSync(@Nonnull Query<T> query) {
        return this.findAllManagedWithChanges(query, false);
    }

    public void openManually() {
        if (!this.isForcedOpen.compareAndSet(false, true)) {
            throw new IllegalStateException("The Monarchy thread is already forced open.");
        }
        this.startListening(null);
    }

    public void closeManually() {
        if (!this.isForcedOpen.compareAndSet(true, false)) {
            throw new IllegalStateException("Cannot close Monarchy thread manually if it was not opened manually.");
        }
        this.stopListening(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMonarchyThreadOpen() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.handler.get() != null;
        }
    }

    public void postToMonarchyThread(final @Nonnull RealmBlock realmBlock) {
        Handler _handler = this.handler.get();
        if (_handler == null) {
            throw new IllegalStateException("Cannot post to Monarchy thread when the Monarchy thread is not open.");
        }
        _handler.post(new Runnable(){

            @Override
            public void run() {
                Realm realm = (Realm)Monarchy.this.realmThreadLocal.get();
                Monarchy.this.checkRealmValid(realm);
                realmBlock.doWithRealm(realm);
            }
        });
    }

    public static interface RealmBlock {
        public void doWithRealm(@Nonnull Realm var1);
    }

    public static interface Mapper<R, T> {
        public R map(@Nonnull T var1);
    }

    public static interface Query<T extends RealmModel> {
        @Nonnull
        public RealmQuery<T> createQuery(@Nonnull Realm var1);
    }

    public static class Builder {
        private RealmConfiguration realmConfiguration;
        private Executor writeScheduler = Executors.newSingleThreadExecutor();

        public Builder() {
            this.realmConfiguration = Realm.getDefaultConfiguration();
        }

        @Nonnull
        public Builder setRealmConfiguration(@Nullable RealmConfiguration realmConfiguration) {
            this.realmConfiguration = realmConfiguration;
            return this;
        }

        @Nonnull
        public Builder setWriteAsyncExecutor(@Nonnull Executor executor) {
            if (executor == null) {
                throw new IllegalArgumentException("executor should not be null!");
            }
            this.writeScheduler = executor;
            return this;
        }

        @Nonnull
        public Monarchy build() {
            return new Monarchy(this.realmConfiguration, this.writeScheduler);
        }
    }

    public static class ManagedChangeSet<T extends RealmModel> {
        private final RealmResults<T> realmResults;
        private final OrderedCollectionChangeSet orderedCollectionChangeSet;

        ManagedChangeSet(@Nonnull RealmResults<T> realmResults, @Nonnull OrderedCollectionChangeSet orderedCollectionChangeSet) {
            this.realmResults = realmResults;
            this.orderedCollectionChangeSet = orderedCollectionChangeSet;
        }

        @Nonnull
        public RealmResults<T> getRealmResults() {
            return this.realmResults;
        }

        @Nonnull
        public OrderedCollectionChangeSet getOrderedCollectionChangeSet() {
            return this.orderedCollectionChangeSet;
        }
    }
}

