/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.monarchy;

import androidx.lifecycle.MutableLiveData;
import com.zhuinden.monarchy.LiveResults;
import com.zhuinden.monarchy.Monarchy;
import io.realm.OrderedRealmCollection;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.RealmResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class MappedLiveResults<T extends RealmModel, U>
extends MutableLiveData<List<U>>
implements LiveResults<T> {
    private final Monarchy monarchy;
    private final Monarchy.Query<T> query;
    private final Monarchy.Mapper<U, T> mapper;
    private boolean isActive;

    MappedLiveResults(Monarchy monarchy, Monarchy.Query<T> query, Monarchy.Mapper<U, T> mapper) {
        this.monarchy = monarchy;
        this.query = query;
        this.mapper = mapper;
    }

    public void onActive() {
        this.monarchy.startListening(this);
        this.isActive = true;
    }

    public void onInactive() {
        this.monarchy.stopListening(this);
        this.isActive = false;
    }

    @Override
    public RealmResults<T> createQuery(Realm realm) {
        return this.query.createQuery(realm).findAllAsync();
    }

    @Override
    public void updateResults(final OrderedRealmCollection<T> realmResults) {
        this.monarchy.doWithRealm(new Monarchy.RealmBlock(){

            @Override
            public void doWithRealm(Realm realm) {
                ArrayList list = new ArrayList(realmResults.size());
                for (RealmModel t : realmResults) {
                    list.add(MappedLiveResults.this.mapper.map(t));
                }
                MappedLiveResults.this.postValue(Collections.unmodifiableList(list));
            }
        });
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.isActive) {
            this.monarchy.stopListening(this);
            this.isActive = false;
        }
    }
}

