/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.monarchy;

import androidx.lifecycle.MutableLiveData;
import com.zhuinden.monarchy.LiveResults;
import com.zhuinden.monarchy.Monarchy;
import io.realm.OrderedRealmCollection;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.RealmResults;
import java.util.List;

class CopiedLiveResults<T extends RealmModel>
extends MutableLiveData<List<T>>
implements LiveResults<T> {
    private final Monarchy monarchy;
    private final Monarchy.Query<T> query;
    private boolean isActive;

    CopiedLiveResults(Monarchy monarchy, Monarchy.Query<T> query) {
        this.monarchy = monarchy;
        this.query = query;
    }

    public void onActive() {
        this.monarchy.startListening(this);
        this.isActive = true;
    }

    public void onInactive() {
        this.isActive = false;
        this.monarchy.stopListening(this);
    }

    @Override
    public RealmResults<T> createQuery(Realm realm) {
        return this.query.createQuery(realm).findAllAsync();
    }

    @Override
    public void updateResults(final OrderedRealmCollection<T> realmCollection) {
        this.monarchy.doWithRealm(new Monarchy.RealmBlock(){

            @Override
            public void doWithRealm(Realm realm) {
                CopiedLiveResults.this.postValue(realm.copyFromRealm((Iterable)realmCollection));
            }
        });
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.isActive) {
            this.monarchy.stopListening(this);
            this.isActive = false;
        }
    }
}

