/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.monarchy;

import androidx.lifecycle.MutableLiveData;
import com.zhuinden.monarchy.Monarchy;
import io.realm.OrderedCollectionChangeSet;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ManagedLiveResults<T extends RealmModel>
extends MutableLiveData<Monarchy.ManagedChangeSet<T>> {
    private final Monarchy monarchy;
    private final Monarchy.Query<T> query;
    private final boolean asAsync;
    private final RealmConfiguration realmConfiguration;
    private OrderedRealmCollectionChangeListener<RealmResults<T>> realmChangeListener = new OrderedRealmCollectionChangeListener<RealmResults<T>>(){

        public void onChange(@Nonnull RealmResults<T> realmResults, @Nonnull OrderedCollectionChangeSet changeSet) {
            Monarchy.ManagedChangeSet managedChangeSet = new Monarchy.ManagedChangeSet(realmResults, changeSet);
            if (!ManagedLiveResults.this.asAsync && changeSet.getState() == OrderedCollectionChangeSet.State.INITIAL) {
                ManagedLiveResults.this.setValue(managedChangeSet);
            } else {
                ManagedLiveResults.this.postValue(managedChangeSet);
            }
        }
    };
    private Realm realm;
    private RealmResults<T> realmResults;

    public ManagedLiveResults(Monarchy monarchy, Monarchy.Query<T> query, boolean asAsync) {
        this.monarchy = monarchy;
        this.query = query;
        this.asAsync = asAsync;
        this.realmConfiguration = this.monarchy.getRealmConfiguration();
    }

    protected void onActive() {
        this.realm = Realm.getInstance((RealmConfiguration)this.realmConfiguration);
        RealmQuery<T> realmQuery = this.query.createQuery(this.realm);
        this.realmResults = this.asAsync ? realmQuery.findAllAsync() : realmQuery.findAll();
        this.realmResults.addChangeListener(this.realmChangeListener);
        if (!this.asAsync) {
            this.setValue(new Monarchy.ManagedChangeSet<T>(this.realmResults, new EmptyChangeSet()));
        }
    }

    protected void onInactive() {
        if (this.realmResults.isValid()) {
            this.realmResults.removeChangeListener(this.realmChangeListener);
        }
        this.realmResults = null;
        this.realm.close();
        this.realm = null;
    }

    private static class EmptyChangeSet
    implements OrderedCollectionChangeSet {
        private static final int[] NO_INDEX_CHANGES = new int[0];
        private static final OrderedCollectionChangeSet.Range[] NO_RANGE_CHANGES = new OrderedCollectionChangeSet.Range[0];

        private EmptyChangeSet() {
        }

        public OrderedCollectionChangeSet.State getState() {
            return OrderedCollectionChangeSet.State.INITIAL;
        }

        public int[] getDeletions() {
            return NO_INDEX_CHANGES;
        }

        public int[] getInsertions() {
            return NO_INDEX_CHANGES;
        }

        public int[] getChanges() {
            return NO_INDEX_CHANGES;
        }

        public OrderedCollectionChangeSet.Range[] getDeletionRanges() {
            return NO_RANGE_CHANGES;
        }

        public OrderedCollectionChangeSet.Range[] getInsertionRanges() {
            return NO_RANGE_CHANGES;
        }

        public OrderedCollectionChangeSet.Range[] getChangeRanges() {
            return NO_RANGE_CHANGES;
        }

        @Nullable
        public Throwable getError() {
            return null;
        }

        public boolean isCompleteResult() {
            return true;
        }
    }
}

