/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.monarchy;

import android.arch.lifecycle.MutableLiveData;
import android.arch.paging.PagedList;
import com.zhuinden.monarchy.LiveResults;
import com.zhuinden.monarchy.Monarchy;
import io.realm.OrderedRealmCollection;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.RealmResults;
import java.util.concurrent.atomic.AtomicReference;

class PagedLiveResults<T extends RealmModel>
extends MutableLiveData<PagedList<T>>
implements LiveResults<T> {
    private final Monarchy monarchy;
    private AtomicReference<Monarchy.Query<T>> query;
    private Monarchy.RealmTiledDataSource<T> dataSource;
    private final boolean asAsync;
    private boolean isActive;

    PagedLiveResults(Monarchy monarchy, Monarchy.Query<T> query, boolean asAsync) {
        this.monarchy = monarchy;
        this.query = new AtomicReference<Monarchy.Query<T>>(query);
        this.asAsync = asAsync;
    }

    public void onActive() {
        this.monarchy.startListening(this);
        this.isActive = true;
    }

    public void onInactive() {
        this.isActive = false;
        this.monarchy.stopListening(this);
    }

    @Override
    public RealmResults<T> createQuery(Realm realm) {
        if (this.asAsync) {
            return this.query.get().createQuery(realm).findAllAsync();
        }
        return this.query.get().createQuery(realm).findAll();
    }

    @Override
    public void updateResults(OrderedRealmCollection<T> realmCollection) {
        this.monarchy.doWithRealm(new Monarchy.RealmBlock(){

            @Override
            public void doWithRealm(Realm realm) {
                Monarchy.RealmTiledDataSource ds = PagedLiveResults.this.dataSource;
                if (ds != null) {
                    ds.invalidate();
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.isActive) {
            this.monarchy.stopListening(this);
            this.isActive = false;
        }
    }

    void setDataSource(Monarchy.RealmTiledDataSource<T> dataSource) {
        this.dataSource = dataSource;
    }

    public void updateQuery(Monarchy.Query<T> query) {
        this.query.set(query);
        if (this.dataSource != null) {
            this.dataSource.invalidate();
        }
    }
}

