/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.monarchy;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MediatorLiveData;
import android.arch.lifecycle.Observer;
import android.arch.paging.DataSource;
import android.arch.paging.LivePagedListBuilder;
import android.arch.paging.PagedList;
import android.arch.paging.PositionalDataSource;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.zhuinden.monarchy.CopiedLiveResults;
import com.zhuinden.monarchy.LiveResults;
import com.zhuinden.monarchy.ManagedLiveResults;
import com.zhuinden.monarchy.MappedLiveResults;
import com.zhuinden.monarchy.PagedLiveResults;
import io.realm.OrderedCollectionChangeSet;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public final class Monarchy {
    private final Executor writeScheduler = Executors.newSingleThreadExecutor();
    private static volatile RealmConfiguration invalidDefaultConfig;
    private volatile RealmConfiguration realmConfiguration = null;
    private HandlerThread handlerThread;
    private Handler handler;
    private AtomicInteger refCount = new AtomicInteger(0);
    private ThreadLocal<Realm> realmThreadLocal = new ThreadLocal();
    private ThreadLocal<Map<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>>> resultsRefs = new ThreadLocal<Map<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>>>(){

        @Override
        protected Map<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>> initialValue() {
            return new IdentityHashMap<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>>();
        }
    };

    public static void init(Context context) {
        Realm.init((Context)context);
        invalidDefaultConfig = new RealmConfiguration.Builder().build();
        Realm.setDefaultConfiguration((RealmConfiguration)invalidDefaultConfig);
    }

    public static void setDefaultConfiguration(RealmConfiguration realmConfiguration) {
        Realm.setDefaultConfiguration((RealmConfiguration)realmConfiguration);
    }

    public static RealmConfiguration getDefaultConfiguration() {
        RealmConfiguration config = Realm.getDefaultConfiguration();
        if (config == invalidDefaultConfig) {
            throw new IllegalStateException("No default configuration is set!");
        }
        return config;
    }

    Monarchy(RealmConfiguration configuration) {
        this.realmConfiguration = configuration;
    }

    public final RealmConfiguration getRealmConfiguration() {
        return this.realmConfiguration == null ? Monarchy.getDefaultConfiguration() : this.realmConfiguration;
    }

    public final void runTransactionSync(final Realm.Transaction transaction) {
        this.doWithRealm(new RealmBlock(){

            @Override
            public void doWithRealm(Realm realm) {
                realm.executeTransaction(transaction);
            }
        });
    }

    private void assertMainThread() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("This method can only be called on the main thread!");
        }
    }

    <T extends RealmModel> void startListening(final @NonNull LiveResults<T> liveResults) {
        if (this.refCount.getAndIncrement() == 0) {
            this.handlerThread = new HandlerThread("MONARCHY_REALM-#" + this.hashCode());
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Realm realm = Realm.getInstance((RealmConfiguration)Monarchy.this.getRealmConfiguration());
                    if (Monarchy.this.realmThreadLocal.get() == null) {
                        Monarchy.this.realmThreadLocal.set(realm);
                    }
                }
            });
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                Realm realm = (Realm)Monarchy.this.realmThreadLocal.get();
                Monarchy.this.checkRealmValid(realm);
                RealmResults results = liveResults.createQuery(realm);
                ((Map)Monarchy.this.resultsRefs.get()).put(liveResults, results);
                results.addChangeListener(new RealmChangeListener<RealmResults<T>>(){

                    public void onChange(@NonNull RealmResults<T> realmResults) {
                        liveResults.updateResults(realmResults.createSnapshot());
                    }
                });
            }
        });
    }

    <T extends RealmModel> void stopListening(final @NonNull LiveResults<T> liveResults) {
        if (this.handler == null) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                Realm realm = (Realm)Monarchy.this.realmThreadLocal.get();
                Monarchy.this.checkRealmValid(realm);
                RealmResults realmResults = (RealmResults)((Map)Monarchy.this.resultsRefs.get()).remove(liveResults);
                if (realmResults != null) {
                    realmResults.removeAllChangeListeners();
                }
            }
        });
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (Monarchy.this.refCount.decrementAndGet() == 0) {
                    Realm realm = (Realm)Monarchy.this.realmThreadLocal.get();
                    Monarchy.this.checkRealmValid(realm);
                    realm.close();
                    if (Realm.getLocalInstanceCount((RealmConfiguration)Monarchy.this.getRealmConfiguration()) <= 0) {
                        Monarchy.this.realmThreadLocal.set(null);
                    }
                    Monarchy.this.handlerThread.quit();
                    Monarchy.this.handlerThread = null;
                    Monarchy.this.handler = null;
                }
            }
        });
    }

    private void checkRealmValid(Realm realm) {
        if (realm == null || realm.isClosed()) {
            throw new IllegalStateException("Unexpected state: Realm is not open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWithRealm(RealmBlock realmBlock) {
        RealmConfiguration configuration = this.getRealmConfiguration();
        try (Realm realm = null;){
            realm = Realm.getInstance((RealmConfiguration)configuration);
            realmBlock.doWithRealm(realm);
        }
    }

    public final void writeAsync(final Realm.Transaction transaction) {
        this.writeScheduler.execute(new Runnable(){

            @Override
            public void run() {
                Monarchy.this.runTransactionSync(transaction);
            }
        });
    }

    public <T extends RealmModel> List<T> findAllSync(Realm realm, Query<T> query) {
        return query.createQuery(realm).findAll().createSnapshot();
    }

    public <T extends RealmModel> LiveData<List<T>> findAllCopiedWithChanges(Query<T> query) {
        this.assertMainThread();
        return new CopiedLiveResults<T>(this, query);
    }

    public <T extends RealmModel, U> LiveData<List<U>> findAllMappedWithChanges(Query<T> query, Mapper<U, T> mapper) {
        this.assertMainThread();
        return new MappedLiveResults<T, U>(this, query, mapper);
    }

    public <T extends RealmModel> LiveData<ManagedChangeSet<T>> findAllManagedWithChanges(Query<T> query) {
        this.assertMainThread();
        return new ManagedLiveResults<T>(this, query);
    }

    public <T extends RealmModel> DataSource.Factory<Integer, T> createDataSourceFactory(Query<T> query) {
        this.assertMainThread();
        PagedLiveResults<T> liveResults = new PagedLiveResults<T>(this, query);
        return new RealmDataSourceFactory<T>(this, liveResults);
    }

    public <R, T extends RealmModel> LiveData<PagedList<R>> findAllPagedWithChanges(DataSource.Factory<Integer, T> dataSourceFactory, LivePagedListBuilder<Integer, R> livePagedListBuilder) {
        this.assertMainThread();
        final MediatorLiveData mediator = new MediatorLiveData();
        if (!(dataSourceFactory instanceof RealmDataSourceFactory)) {
            throw new IllegalArgumentException("Monarchy is only compatible with DataSource.Factory created by Monarchy.");
        }
        RealmDataSourceFactory realmDataSourceFactory = (RealmDataSourceFactory)dataSourceFactory;
        PagedLiveResults liveResults = realmDataSourceFactory.pagedLiveResults;
        mediator.addSource(liveResults, new Observer<PagedList<T>>(){

            public void onChanged(@Nullable PagedList<T> ts) {
            }
        });
        LiveData computableLiveData = livePagedListBuilder.setFetchExecutor((Executor)new RealmQueryExecutor(this)).build();
        mediator.addSource(computableLiveData, new Observer<PagedList<R>>(){

            public void onChanged(@Nullable PagedList<R> data) {
                mediator.postValue(data);
            }
        });
        return mediator;
    }

    private static class RealmDataSourceFactory<T extends RealmModel>
    extends DataSource.Factory<Integer, T> {
        Monarchy monarchy;
        final PagedLiveResults<T> pagedLiveResults;

        public RealmDataSourceFactory(Monarchy monarchy, PagedLiveResults<T> pagedLiveResults) {
            this.monarchy = monarchy;
            this.pagedLiveResults = pagedLiveResults;
        }

        public DataSource<Integer, T> create() {
            RealmTiledDataSource<T> dataSource = new RealmTiledDataSource<T>(this.monarchy, this.pagedLiveResults);
            this.pagedLiveResults.setDataSource(dataSource);
            return dataSource;
        }
    }

    static class RealmTiledDataSource<T extends RealmModel>
    extends TiledDataSource<T> {
        final Monarchy monarchy;
        final LiveResults<T> liveResults;

        public RealmTiledDataSource(Monarchy monarchy, LiveResults<T> liveResults) {
            this.monarchy = monarchy;
            this.liveResults = liveResults;
        }

        @Override
        @WorkerThread
        public int countItems() {
            Realm realm = (Realm)this.monarchy.realmThreadLocal.get();
            RealmResults results = (RealmResults)((Map)this.monarchy.resultsRefs.get()).get(this.liveResults);
            if (realm.isClosed() || results == null || !results.isValid()) {
                return 0;
            }
            return results.size();
        }

        public boolean isInvalid() {
            Realm realm = (Realm)this.monarchy.realmThreadLocal.get();
            realm.refresh();
            return super.isInvalid();
        }

        @Override
        @WorkerThread
        public List<T> loadRange(final int startPosition, final int count) {
            final int countItems = this.countItems();
            if (countItems == 0) {
                return Collections.emptyList();
            }
            final ArrayList list = new ArrayList(count);
            this.monarchy.doWithRealm(new RealmBlock(){

                @Override
                public void doWithRealm(Realm realm) {
                    RealmResults results = (RealmResults)((Map)RealmTiledDataSource.this.monarchy.resultsRefs.get()).get(RealmTiledDataSource.this.liveResults);
                    for (int i = startPosition; i < startPosition + count && i < countItems; ++i) {
                        list.add(realm.copyFromRealm((RealmModel)results.get(i)));
                    }
                }
            });
            return Collections.unmodifiableList(list);
        }
    }

    static abstract class TiledDataSource<T>
    extends PositionalDataSource<T> {
        TiledDataSource() {
        }

        @WorkerThread
        public abstract int countItems();

        @WorkerThread
        public abstract List<T> loadRange(int var1, int var2);

        public final void loadInitial(@NonNull PositionalDataSource.LoadInitialParams params, @NonNull PositionalDataSource.LoadInitialCallback<T> callback) {
            int firstLoadSize;
            int totalCount = this.countItems();
            if (totalCount == 0) {
                callback.onResult(Collections.emptyList(), 0, 0);
                return;
            }
            int firstLoadPosition = TiledDataSource.computeInitialLoadPosition((PositionalDataSource.LoadInitialParams)params, (int)totalCount);
            List<T> list = this.loadRange(firstLoadPosition, firstLoadSize = TiledDataSource.computeInitialLoadSize((PositionalDataSource.LoadInitialParams)params, (int)firstLoadPosition, (int)totalCount));
            if (list != null && list.size() == firstLoadSize) {
                callback.onResult(list, firstLoadPosition, totalCount);
            } else {
                this.invalidate();
            }
        }

        public final void loadRange(@NonNull PositionalDataSource.LoadRangeParams params, @NonNull PositionalDataSource.LoadRangeCallback<T> callback) {
            List<T> list = this.loadRange(params.startPosition, params.loadSize);
            if (list != null) {
                callback.onResult(list);
            } else {
                this.invalidate();
            }
        }
    }

    private static class RealmQueryExecutor
    implements Executor {
        final Monarchy monarchy;

        public RealmQueryExecutor(Monarchy monarchy) {
            this.monarchy = monarchy;
        }

        @Override
        public void execute(@NonNull Runnable command) {
            if (this.monarchy.handler == null) {
                return;
            }
            if (Looper.myLooper() == this.monarchy.handler.getLooper()) {
                command.run();
            } else {
                this.monarchy.handler.post(command);
            }
        }
    }

    public static interface RealmBlock {
        public void doWithRealm(Realm var1);
    }

    public static interface Mapper<R, T> {
        public R map(T var1);
    }

    public static interface Query<T extends RealmModel> {
        public RealmQuery<T> createQuery(Realm var1);
    }

    public static class Builder {
        private RealmConfiguration realmConfiguration = Realm.getDefaultConfiguration();

        public Builder setRealmConfiguration(RealmConfiguration realmConfiguration) {
            this.realmConfiguration = realmConfiguration;
            return this;
        }

        public Monarchy build() {
            return new Monarchy(this.realmConfiguration);
        }
    }

    public static class ManagedChangeSet<T extends RealmModel> {
        private final RealmResults<T> realmResults;
        private final OrderedCollectionChangeSet orderedCollectionChangeSet;

        ManagedChangeSet(RealmResults<T> realmResults, OrderedCollectionChangeSet orderedCollectionChangeSet) {
            this.realmResults = realmResults;
            this.orderedCollectionChangeSet = orderedCollectionChangeSet;
        }

        public RealmResults<T> getRealmResults() {
            return this.realmResults;
        }

        @NonNull
        public OrderedCollectionChangeSet getOrderedCollectionChangeSet() {
            return this.orderedCollectionChangeSet;
        }
    }
}

