/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.monarchy;

import android.arch.lifecycle.LiveData;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zhuinden.monarchy.CopiedLiveResults;
import com.zhuinden.monarchy.LiveResults;
import com.zhuinden.monarchy.ManagedLiveResults;
import com.zhuinden.monarchy.MappedLiveResults;
import io.realm.OrderedCollectionChangeSet;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public final class Monarchy {
    private final Executor writeScheduler = Executors.newSingleThreadExecutor();
    private static RealmConfiguration invalidDefaultConfig;
    private volatile RealmConfiguration realmConfiguration = null;
    private HandlerThread handlerThread;
    private Handler handler;
    private AtomicInteger refCount = new AtomicInteger(0);
    private ThreadLocal<Realm> realmThreadLocal = new ThreadLocal();
    private ThreadLocal<Map<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>>> resultsRefs = new ThreadLocal<Map<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>>>(){

        @Override
        protected Map<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>> initialValue() {
            return new IdentityHashMap<LiveResults<? extends RealmModel>, RealmResults<? extends RealmModel>>();
        }
    };

    public static void init(Context context) {
        Realm.init((Context)context);
        invalidDefaultConfig = new RealmConfiguration.Builder().build();
        Realm.setDefaultConfiguration((RealmConfiguration)invalidDefaultConfig);
    }

    public static void setDefaultConfiguration(RealmConfiguration realmConfiguration) {
        Realm.setDefaultConfiguration((RealmConfiguration)realmConfiguration);
    }

    public static RealmConfiguration getDefaultConfiguration() {
        RealmConfiguration config = Realm.getDefaultConfiguration();
        if (config == invalidDefaultConfig) {
            throw new IllegalStateException("No default configuration is set!");
        }
        return config;
    }

    Monarchy(RealmConfiguration configuration) {
        this.realmConfiguration = configuration;
    }

    public final RealmConfiguration getRealmConfiguration() {
        return this.realmConfiguration == null ? Monarchy.getDefaultConfiguration() : this.realmConfiguration;
    }

    public final void runTransactionSync(final Realm.Transaction transaction) {
        this.doWithRealm(new RealmBlock(){

            @Override
            public void doWithRealm(Realm realm) {
                realm.executeTransaction(transaction);
            }
        });
    }

    private void assertMainThread() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("This method can only be called on the main thread!");
        }
    }

    public <T extends RealmModel> void startListening(final LiveResults<T> liveResults) {
        if (this.refCount.getAndIncrement() == 0) {
            this.handlerThread = new HandlerThread("MONARCHY_REALM-#" + this.hashCode());
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Realm realm = Realm.getInstance((RealmConfiguration)Monarchy.this.getRealmConfiguration());
                    if (Monarchy.this.realmThreadLocal.get() == null) {
                        Monarchy.this.realmThreadLocal.set(realm);
                    }
                }
            });
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                Realm realm = (Realm)Monarchy.this.realmThreadLocal.get();
                Monarchy.this.checkRealmValid(realm);
                RealmResults results = liveResults.createQuery(realm);
                ((Map)Monarchy.this.resultsRefs.get()).put(liveResults, results);
                results.addChangeListener(new RealmChangeListener<RealmResults<T>>(){

                    public void onChange(@NonNull RealmResults<T> realmResults) {
                        liveResults.updateResults(realmResults.createSnapshot());
                    }
                });
            }
        });
    }

    public <T extends RealmModel> void stopListening(final LiveResults<T> liveResults) {
        if (this.handler == null) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                Realm realm = (Realm)Monarchy.this.realmThreadLocal.get();
                Monarchy.this.checkRealmValid(realm);
                RealmResults realmResults = (RealmResults)((Map)Monarchy.this.resultsRefs.get()).remove(liveResults);
                if (realmResults != null) {
                    realmResults.removeAllChangeListeners();
                }
            }
        });
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (Monarchy.this.refCount.decrementAndGet() == 0) {
                    Realm realm = (Realm)Monarchy.this.realmThreadLocal.get();
                    Monarchy.this.checkRealmValid(realm);
                    realm.close();
                    if (Realm.getLocalInstanceCount((RealmConfiguration)Monarchy.this.getRealmConfiguration()) <= 0) {
                        Monarchy.this.realmThreadLocal.set(null);
                    }
                    Monarchy.this.handlerThread.quit();
                    Monarchy.this.handlerThread = null;
                    Monarchy.this.handler = null;
                }
            }
        });
    }

    private void checkRealmValid(Realm realm) {
        if (realm == null || realm.isClosed()) {
            throw new IllegalStateException("Unexpected state: Realm is not open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWithRealm(RealmBlock realmBlock) {
        RealmConfiguration configuration = this.getRealmConfiguration();
        try (Realm realm = null;){
            realm = Realm.getInstance((RealmConfiguration)configuration);
            realmBlock.doWithRealm(realm);
        }
    }

    public final void writeAsync(final Realm.Transaction transaction) {
        this.writeScheduler.execute(new Runnable(){

            @Override
            public void run() {
                Monarchy.this.runTransactionSync(transaction);
            }
        });
    }

    public <T extends RealmModel> List<T> findAllSync(Realm realm, Query<T> query) {
        return query.createQuery(realm).findAll().createSnapshot();
    }

    public <T extends RealmModel> LiveData<List<T>> findAllCopiedWithChanges(Query<T> query) {
        this.assertMainThread();
        return new CopiedLiveResults<T>(this, query);
    }

    public <T extends RealmModel, U> LiveData<List<U>> findAllMappedWithChanges(Query<T> query, Mapper<U, T> mapper) {
        this.assertMainThread();
        return new MappedLiveResults<T, U>(this, query, mapper);
    }

    public <T extends RealmModel> LiveData<ManagedChangeSet<T>> findAllManagedWithChanges(Query<T> query) {
        this.assertMainThread();
        return new ManagedLiveResults<T>(this, query);
    }

    public static interface RealmBlock {
        public void doWithRealm(Realm var1);
    }

    public static interface Mapper<R, T> {
        public R map(T var1);
    }

    public static interface Query<T extends RealmModel> {
        public RealmQuery<T> createQuery(Realm var1);
    }

    public static class Builder {
        private RealmConfiguration realmConfiguration = Realm.getDefaultConfiguration();

        public Builder setRealmConfiguration(RealmConfiguration realmConfiguration) {
            this.realmConfiguration = realmConfiguration;
            return this;
        }

        public Monarchy build() {
            return new Monarchy(this.realmConfiguration);
        }
    }

    public static class ManagedChangeSet<T extends RealmModel> {
        private final RealmResults<T> realmResults;
        private final OrderedCollectionChangeSet orderedCollectionChangeSet;

        ManagedChangeSet(RealmResults<T> realmResults, OrderedCollectionChangeSet orderedCollectionChangeSet) {
            this.realmResults = realmResults;
            this.orderedCollectionChangeSet = orderedCollectionChangeSet;
        }

        public RealmResults<T> getRealmResults() {
            return this.realmResults;
        }

        @Nullable
        public OrderedCollectionChangeSet getOrderedCollectionChangeSet() {
            return this.orderedCollectionChangeSet;
        }
    }
}

